/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.annotations.Nullable;
import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.AllocationsRowListener;
import com.android.tools.idea.editors.allocations.AllocationsRowSorter;
import com.android.tools.idea.editors.allocations.AllocationsTableModel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.JBTable;
import com.intellij.util.config.Storage;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class AllocationsTableUtil {
    public static void setUpTable(final @Nullable Storage.PropertiesComponentStorage storage, final @NotNull JBTable allocationsTable, @Nullable ConsoleView consoleView) {
        if (allocationsTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocationsTable", "com/android/tools/idea/editors/allocations/AllocationsTableUtil", "setUpTable"));
        }
        allocationsTable.setSelectionMode(2);
        new TableSpeedSearch((JTable)allocationsTable){

            public int getElementCount() {
                return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
            }
        };
        allocationsTable.getSelectionModel().addListSelectionListener(new AllocationsRowListener(allocationsTable, consoleView));
        allocationsTable.setModel((TableModel)new AllocationsTableModel(new AllocationInfo[0]));
        allocationsTable.setRowSorter((RowSorter)new AllocationsRowSorter(allocationsTable.getModel()));
        if (storage != null) {
            if (storage.get("widthsSet") == null) {
                storage.put("widthsSet", Boolean.toString(true));
                AllocationsTableUtil.setDefaultColumnWidths(allocationsTable);
                BaseTableView.storeWidth((Storage)storage, (TableColumnModel)allocationsTable.getColumnModel());
            }
            BaseTableView.restore((Storage)storage, (JTable)allocationsTable);
            allocationsTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    BaseTableView.store((Storage)storage, (JTable)allocationsTable);
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                    BaseTableView.storeWidth((Storage)storage, (TableColumnModel)allocationsTable.getColumnModel());
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
        }
    }

    private static void setDefaultColumnWidths(@NotNull JBTable allocationsTable) {
        if (allocationsTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocationsTable", "com/android/tools/idea/editors/allocations/AllocationsTableUtil", "setDefaultColumnWidths"));
        }
        Column[] columns = Column.values();
        int cumulativeWidth = 0;
        int[] defaultWidths = new int[columns.length];
        FontMetrics metrics = allocationsTable.getFontMetrics(allocationsTable.getFont());
        for (Column column : columns) {
            int columnWidth;
            defaultWidths[column.ordinal()] = columnWidth = 3 * Math.max(metrics.stringWidth(column.description), metrics.stringWidth(String.valueOf(column.sampleData))) / 2;
            if (column == Column.ALLOCATION_SITE) continue;
            cumulativeWidth += columnWidth;
        }
        int remainingWidth = allocationsTable.getWidth() - cumulativeWidth;
        if (remainingWidth > 0) {
            defaultWidths[Column.ALLOCATION_SITE.ordinal()] = remainingWidth;
        }
        for (Column column : columns) {
            allocationsTable.getColumn((Object)column.description).setPreferredWidth(defaultWidths[column.ordinal()]);
        }
    }

    static enum Column {
        ALLOCATION_ORDER("Allocation Order", 0),
        ALLOCATED_CLASS("Allocated Class", "com.sample.data.AllocatedClass"),
        ALLOCATION_SIZE("Allocation Size", 0),
        THREAD_ID("Thread Id", 0),
        ALLOCATION_SITE("Allocation Site", "com.sample.data.AllocationSite.method(AllocationSite.java:000)");

        public final String description;
        public final Object sampleData;

        private Column(String description, Object sampleData) {
            this.description = description;
            this.sampleData = sampleData;
        }
    }
}

