/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.navigation.Point;
import com.android.tools.idea.rendering.RenderedView;
import java.awt.Dimension;
import java.awt.Rectangle;

public class Transform {
    public final float myScale;

    public Transform(float scale) {
        this.myScale = scale;
    }

    private int scale(int d) {
        return (int)((float)d * this.myScale);
    }

    public int modelToViewX(int x) {
        return this.scale(x);
    }

    public int modelToViewY(int y) {
        return this.scale(y);
    }

    public int modelToViewW(int d) {
        return this.scale(d);
    }

    public int modelToViewH(int d) {
        return this.scale(d);
    }

    public java.awt.Point modelToView(Point loc) {
        return new java.awt.Point(this.modelToViewX(loc.x), this.modelToViewY(loc.y));
    }

    public Dimension modelToView(com.android.navigation.Dimension size) {
        return new Dimension(this.modelToViewW(size.width), this.modelToViewH(size.height));
    }

    public Rectangle getBounds(RenderedView v) {
        return new Rectangle(this.modelToViewX(v.x), this.modelToViewY(v.y), this.modelToViewW(v.w), this.modelToViewH(v.h));
    }

    private int unScale(int d) {
        return (int)((float)d / this.myScale);
    }

    public int viewToModelX(int d) {
        return this.unScale(d);
    }

    public int viewToModelY(int d) {
        return this.unScale(d);
    }

    public int viewToModelW(int d) {
        return this.unScale(d);
    }

    public int viewToModelH(int d) {
        return this.unScale(d);
    }

    public Point viewToModel(java.awt.Point loc) {
        return new Point(this.viewToModelX(loc.x), this.viewToModelY(loc.y));
    }

    public com.android.navigation.Dimension viewToModel(Dimension dim) {
        return new com.android.navigation.Dimension(this.viewToModelW(dim.width), this.viewToModelH(dim.height));
    }
}

