/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKeyType;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.tools.idea.gradle.parser.NonGroovyValueFactory;
import com.android.tools.idea.gradle.parser.Repository;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public enum BuildFileKey {
    PLUGIN_CLASSPATH("buildscript/dependencies/classpath", BuildFileKeyType.STRING),
    PLUGIN_REPOSITORY("buildscript/repositories", "Android Plugin Repository", BuildFileKeyType.CLOSURE, Repository.getFactory()),
    PLUGIN_VERSION("buildscript/dependencies/classpath", "Android Plugin Version", BuildFileKeyType.STRING, null){

        @Override
        public Object getValue(@NotNull GroovyPsiElement arg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKey$1", "getValue"));
            }
            String s = (String)PLUGIN_CLASSPATH.getValue(arg);
            if (s != null && s.startsWith("com.android.tools.build:gradle:")) {
                return s.substring("com.android.tools.build:gradle:".length());
            }
            return null;
        }

        @Override
        public void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value, @Nullable ValueFactory.KeyFilter filter) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKey$1", "setValue"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKey$1", "setValue"));
            }
            PLUGIN_CLASSPATH.setValue(arg, "com.android.tools.build:gradle:" + value);
        }
    }
    ,
    ALLPROJECTS_LIBRARY_REPOSITORY("allprojects/repositories", "Default Library Repository", BuildFileKeyType.CLOSURE, Repository.getFactory()),
    LIBRARY_REPOSITORY("repositories", "Library Repository", BuildFileKeyType.CLOSURE, Repository.getFactory()),
    DEPENDENCIES("dependencies", null, BuildFileKeyType.CLOSURE, Dependency.getFactory()),
    MIN_SDK_VERSION("minSdkVersion", BuildFileKeyType.INTEGER_OR_STRING),
    APPLICATION_ID("applicationId", BuildFileKeyType.STRING),
    PACKAGE_NAME("packageName", BuildFileKeyType.STRING),
    PROGUARD_FILE("proguardFile", BuildFileKeyType.FILE_AS_STRING),
    SIGNING_CONFIG("signingConfig", BuildFileKeyType.REFERENCE),
    TARGET_SDK_VERSION("targetSdkVersion", BuildFileKeyType.INTEGER_OR_STRING),
    TEST_INSTRUMENTATION_RUNNER("testInstrumentationRunner", BuildFileKeyType.STRING),
    TEST_APPLICATION_ID("testApplicationId", BuildFileKeyType.STRING),
    TEST_PACKAGE_NAME("testPackageName", BuildFileKeyType.STRING),
    VERSION_CODE("versionCode", BuildFileKeyType.INTEGER),
    VERSION_NAME("versionName", BuildFileKeyType.STRING),
    DEBUGGABLE("debuggable", BuildFileKeyType.BOOLEAN),
    JNI_DEBUG_BUILD("jniDebugBuild", BuildFileKeyType.BOOLEAN),
    RENDERSCRIPT_DEBUG_BUILD("renderscriptDebugBuild", BuildFileKeyType.BOOLEAN),
    RENDERSCRIPT_OPTIM_LEVEL("renderscriptOptimLevel", BuildFileKeyType.INTEGER),
    RUN_PROGUARD("runProguard", BuildFileKeyType.BOOLEAN),
    APPLICATION_ID_SUFFIX("applicationIdSuffix", BuildFileKeyType.STRING),
    PACKAGE_NAME_SUFFIX("packageNameSuffix", BuildFileKeyType.STRING),
    VERSION_NAME_SUFFIX("versionNameSuffix", BuildFileKeyType.STRING),
    ZIP_ALIGN("zipAlign", BuildFileKeyType.BOOLEAN),
    KEY_ALIAS("keyAlias", BuildFileKeyType.STRING),
    KEY_PASSWORD("keyPassword", BuildFileKeyType.STRING),
    STORE_FILE("storeFile", BuildFileKeyType.FILE),
    STORE_PASSWORD("storePassword", BuildFileKeyType.STRING),
    DEFAULT_CONFIG("android/defaultConfig", BuildFileKeyType.CLOSURE),
    BUILD_TOOLS_VERSION("android/buildToolsVersion", BuildFileKeyType.STRING),
    COMPILE_SDK_VERSION("android/compileSdkVersion", BuildFileKeyType.INTEGER_OR_STRING),
    IGNORE_ASSETS_PATTERN("android/aaptOptions/ignoreAssetsPattern", BuildFileKeyType.STRING),
    INCREMENTAL_DEX("android/dexOptions/incremental", "Incremental Dex", BuildFileKeyType.BOOLEAN, null),
    NO_COMPRESS("android/aaptOptions/noCompress", BuildFileKeyType.STRING),
    SOURCE_COMPATIBILITY("android/compileOptions/sourceCompatibility", BuildFileKeyType.REFERENCE),
    TARGET_COMPATIBILITY("android/compileOptions/targetCompatibility", BuildFileKeyType.REFERENCE),
    GRADLE_WRAPPER_VERSION("", "Gradle version", BuildFileKeyType.STRING, NonGroovyValueFactory.getFactory()),
    SIGNING_CONFIGS("android/signingConfigs", null, BuildFileKeyType.CLOSURE, NamedObject.getFactory((List<BuildFileKey>)ImmutableList.of((Object)((Object)KEY_ALIAS), (Object)((Object)KEY_PASSWORD), (Object)((Object)STORE_FILE), (Object)((Object)STORE_PASSWORD)))),
    FLAVORS("android/productFlavors", null, BuildFileKeyType.CLOSURE, NamedObject.getFactory((List<BuildFileKey>)ImmutableList.of((Object)((Object)MIN_SDK_VERSION), (Object)((Object)APPLICATION_ID), (Object)((Object)PROGUARD_FILE), (Object)((Object)SIGNING_CONFIG), (Object)((Object)TARGET_SDK_VERSION), (Object)((Object)TEST_INSTRUMENTATION_RUNNER), (Object)((Object)TEST_APPLICATION_ID), (Object)((Object)VERSION_CODE), (Object)((Object)VERSION_NAME)))),
    BUILD_TYPES("android/buildTypes", null, BuildFileKeyType.CLOSURE, NamedObject.getFactory((List<BuildFileKey>)ImmutableList.of((Object)((Object)DEBUGGABLE), (Object)((Object)JNI_DEBUG_BUILD), (Object)((Object)SIGNING_CONFIG), (Object)((Object)RENDERSCRIPT_DEBUG_BUILD), (Object)((Object)RENDERSCRIPT_OPTIM_LEVEL), (Object)((Object)RUN_PROGUARD), (Object)((Object)PROGUARD_FILE), (Object)((Object)APPLICATION_ID_SUFFIX), (Object)((Object)VERSION_NAME_SUFFIX), (Object)((Object)ZIP_ALIGN))));

    private final String myPath;
    private final BuildFileKeyType myType;
    private final ValueFactory myValueFactory;
    private final String myDisplayName;
    private BuildFileKey myContainerType;
    private BuildFileKey myItemType;
    private boolean myShouldInsertAtBeginning;

    private BuildFileKey(String path, BuildFileKeyType type) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/parser/BuildFileKey", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/parser/BuildFileKey", "<init>"));
        }
        this(path, null, type, null);
    }

    private BuildFileKey(@NotNull String path, @Nullable String displayName, BuildFileKeyType type, ValueFactory factory) {
        int lastSlash;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/parser/BuildFileKey", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/parser/BuildFileKey", "<init>"));
        }
        this.myPath = path;
        this.myType = type;
        this.myValueFactory = factory;
        this.myDisplayName = displayName != null ? displayName : BuildFileKey.splitCamelCase((lastSlash = this.myPath.lastIndexOf(47)) >= 0 ? this.myPath.substring(lastSlash + 1) : this.myPath);
    }

    @NotNull
    static String splitCamelCase(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/gradle/parser/BuildFileKey", "splitCamelCase"));
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        boolean capitalizeNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append(' ');
                capitalizeNext = true;
            }
            lastWasUpperCase = isUpperCase;
            if (capitalizeNext) {
                c = Character.toUpperCase(c);
                capitalizeNext = false;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "splitCamelCase"));
        }
        return string2;
    }

    @NotNull
    static String escapeLiteralString(@Nullable Object o) {
        if (o == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "escapeLiteralString"));
            }
            return "";
        }
        String string = o.toString().replace("'", "\\'");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "escapeLiteralString"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public BuildFileKeyType getType() {
        BuildFileKeyType buildFileKeyType = this.myType;
        if (buildFileKeyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "getType"));
        }
        return buildFileKeyType;
    }

    @Nullable
    public ValueFactory getValueFactory() {
        return this.myValueFactory;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/BuildFileKey", "getPath"));
        }
        return string;
    }

    @Nullable
    public BuildFileKey getContainerType() {
        return this.myContainerType;
    }

    @Nullable
    public BuildFileKey getItemType() {
        return this.myItemType;
    }

    public boolean shouldInsertAtBeginning() {
        return this.myShouldInsertAtBeginning;
    }

    @Nullable
    protected Object getValue(@NotNull GroovyPsiElement arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKey", "getValue"));
        }
        if (this.myValueFactory != null && arg instanceof GrClosableBlock) {
            return this.myValueFactory.getValues((GrStatementOwner)((GrClosableBlock)arg));
        }
        return this.myType.getValue(arg);
    }

    protected void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKey", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKey", "setValue"));
        }
        this.setValue(arg, value, null);
    }

    protected void setValue(@NotNull GroovyPsiElement arg, @NotNull Object value, @Nullable ValueFactory.KeyFilter filter) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/android/tools/idea/gradle/parser/BuildFileKey", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/parser/BuildFileKey", "setValue"));
        }
        if (this.myValueFactory != null && arg instanceof GrClosableBlock && value instanceof List) {
            this.myValueFactory.setValues((GrStatementOwner)((GrClosableBlock)arg), (List)value, filter);
        } else {
            this.myType.setValue(arg, value);
        }
    }

    static {
        BuildFileKey.SIGNING_CONFIG.myContainerType = SIGNING_CONFIGS;
        BuildFileKey.SIGNING_CONFIGS.myItemType = SIGNING_CONFIG;
        BuildFileKey.SIGNING_CONFIGS.myShouldInsertAtBeginning = true;
    }
}

