/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class FixGradleModelVersionHyperlink
extends NotificationHyperlink {
    private final boolean myOpenMigrationGuide;

    public FixGradleModelVersionHyperlink() {
        this("Open migration guide, fix plug-in version and sync project", true);
    }

    public FixGradleModelVersionHyperlink(@NotNull String text, boolean openMigrationGuide) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleModelVersionHyperlink", "<init>"));
        }
        super("fixGradleElements", text);
        this.myOpenMigrationGuide = openMigrationGuide;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/FixGradleModelVersionHyperlink", "execute"));
        }
        if (this.myOpenMigrationGuide) {
            BrowserUtil.browse((String)"http://tools.android.com/tech-docs/new-build-system/migrating_to_09");
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        boolean atLeastOnUpdated = false;
        for (Module module : moduleManager.getModules()) {
            GradleBuildFile buildFile;
            Object pluginVersion;
            VirtualFile file = GradleUtil.getGradleBuildFile(module);
            if (file == null || (pluginVersion = (buildFile = new GradleBuildFile(file, project)).getValue(BuildFileKey.PLUGIN_VERSION)) == null) continue;
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    buildFile.setValue(BuildFileKey.PLUGIN_VERSION, "0.13.0");
                }
            });
            atLeastOnUpdated = true;
        }
        if (!atLeastOnUpdated) {
            String msg = "Unable to find any references to the Android Gradle plug-in in build.gradle files.\n\nPlease click the link to perform a textual search and then update the build files manually.";
            SearchInBuildFilesHyperlink hyperlink = new SearchInBuildFilesHyperlink("com.android.tools.build:gradle");
            AndroidGradleNotification.getInstance(project).showBalloon("Quick Fix Failed", msg, NotificationType.ERROR, hyperlink);
            return;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        if (wrapperPropertiesFile != null) {
            FixGradleVersionInWrapperHyperlink.updateGradleVersion(project, wrapperPropertiesFile, "2.1");
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

