/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    public AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        if (viewSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        if (sourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceType", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        if (projectViewPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectViewPane", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "<init>"));
        }
        super(project, (Object)facet, viewSettings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList children = Lists.newArrayList();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        AndroidProjectTreeBuilder treeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        for (PsiDirectory directory : this.getSourceDirectories()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            if (this.mySourceType == AndroidSourceType.JAVA) {
                children.addAll(this.annotateWithSourceProvider(directoryChildren));
            } else {
                children.addAll(directoryChildren);
            }
            treeBuilder.createMapping(directory.getVirtualFile(), (AbstractTreeNode)this);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "getChildren"));
        }
        return arrayList;
    }

    private Collection<AbstractTreeNode> annotateWithSourceProvider(Collection<AbstractTreeNode> directoryChildren) {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)directoryChildren.size());
        for (AbstractTreeNode child : directoryChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                children.add(new AndroidPsiDirectoryNode(this.myProject, directory, this.getSettings(), this.findJavaSourceProvider(directory.getVirtualFile())));
                continue;
            }
            children.add(child);
        }
        return children;
    }

    @Nullable
    private IdeaSourceProvider findJavaSourceProvider(VirtualFile virtualFile) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders((AndroidFacet)((Object)this.getValue()))) {
            if (!provider.containsFile(virtualFile)) continue;
            return provider;
        }
        return null;
    }

    protected List<PsiDirectory> getSourceDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList psiDirectories = Lists.newArrayListWithExpectedSize((int)this.mySourceRoots.size());
        for (VirtualFile root : this.mySourceRoots) {
            PsiDirectory directory;
            if (!root.isValid() || (directory = psiManager.findDirectory(root)) == null) continue;
            psiDirectories.add(directory);
        }
        return psiDirectories;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = this.mySourceType.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.mySourceType.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "contains"));
        }
        for (VirtualFile root : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return ((Object)this.mySourceRoots).equals(that.mySourceRoots);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySourceType.hashCode();
        for (VirtualFile root : this.mySourceRoots) {
            result = 31 * result + root.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        List<PsiDirectory> folders = this.getSourceDirectories();
        PsiDirectory[] psiDirectoryArray = folders.toArray(new PsiDirectory[folders.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode", "getDirectories"));
        }
        return psiDirectoryArray;
    }
}

