/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class ClassConverter {
    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        int current = ClassConverter.getCurrentClassVersion();
        byte[] byArray = ClassConverter.rewriteClass(classData, current, 0);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        return byArray;
    }

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData, final int maxVersion, final int minVersion) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        assert (maxVersion >= minVersion);
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (version > maxVersion) {
                    version = maxVersion;
                }
                if (version < minVersion) {
                    version = minVersion;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        byte[] byArray = classWriter.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        return byArray;
    }

    public static int jdkToClassVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/rendering/ClassConverter", "jdkToClassVersion"));
        }
        int dot = version.indexOf(46);
        if (dot != -1) {
            int major;
            int end = version.length();
            for (int i = ++dot; i < end; ++i) {
                if (Character.isDigit(version.charAt(i))) continue;
                end = i;
                break;
            }
            if (end > dot && (major = Integer.valueOf(version.substring(dot, end)).intValue()) > 0) {
                return major + 44;
            }
        }
        return -1;
    }

    public static String classVersionToJdk(int version) {
        return "1." + Integer.toString(version - 44);
    }

    public static int findHighestMajorVersion(Collection<Throwable> list) {
        int result = 0;
        for (Throwable t : list) {
            if (!(t instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)t;
            result = Math.max(result, error.getMajor());
        }
        return result;
    }

    public static String getCurrentJdkVersion() {
        String version = SystemInfo.JAVA_VERSION;
        int suffix = version.indexOf(95);
        if (suffix != -1) {
            version = version.substring(0, suffix);
        }
        return version;
    }

    public static int getCurrentClassVersion() {
        return ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "isValidClassFile"));
        }
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "getMagic"));
        }
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }
}

