/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.ChooseTemplateStep;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.NewModuleDynamicPath;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.WizardPath;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.options.ConfigurationException;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyPathWrapper
implements NewModuleDynamicPath {
    private final NewModuleWizardState myWizardState;
    private final WizardPath myWizardPath;
    private final List<ModuleWizardStep> mySteps;
    private Iterable<ModuleTemplate> myTypes;
    private DynamicWizard myWizard;
    private int myCurrentStep;

    public LegacyPathWrapper(NewModuleWizardState wizardState, WizardPath wizardPath) {
        this.myWizardState = wizardState;
        this.myWizardPath = wizardPath;
        this.mySteps = ImmutableList.copyOf(this.myWizardPath.getSteps());
    }

    private static boolean isStepValid(ModuleWizardStep currentStep) {
        try {
            return currentStep.validate();
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        if (fromBeginning) {
            ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            if (moduleTemplate instanceof TemplateEntryModuleTemplate) {
                this.myWizardState.setTemplateLocation(((TemplateEntryModuleTemplate)moduleTemplate).getTemplateFile());
            }
            this.myCurrentStep = this.findNext(-1, 1);
        } else {
            this.myCurrentStep = this.findNext(this.mySteps.size(), -1);
        }
        this.updateWizard();
    }

    private int findNext(int currentStep, int direction) {
        boolean isWithinBounds;
        int stepCount = this.mySteps.size();
        do {
            boolean bl = isWithinBounds = (currentStep += direction) >= 0 && currentStep < stepCount;
        } while (isWithinBounds && !this.myWizardPath.isStepVisible(this.mySteps.get(currentStep)));
        return !isWithinBounds ? -1 : currentStep;
    }

    public ModuleWizardStep getCurrentStep() {
        return this.mySteps.get(this.myCurrentStep);
    }

    @Override
    public boolean hasNext() {
        return this.findNext(this.myCurrentStep, 1) >= 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.findNext(this.myCurrentStep, -1) >= 0;
    }

    @Override
    public boolean canGoPrevious() {
        return true;
    }

    @Override
    public boolean canGoNext() {
        return LegacyPathWrapper.isStepValid(this.getCurrentStep()) && this.hasNext();
    }

    @Override
    public boolean containsStep(@NotNull String stepName, boolean visibleOnly) {
        if (stepName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepName", "com/android/tools/idea/wizard/LegacyPathWrapper", "containsStep"));
        }
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void navigateToNamedStep(@NotNull String stepName, boolean requireVisible) {
        if (stepName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepName", "com/android/tools/idea/wizard/LegacyPathWrapper", "navigateToNamedStep"));
        }
        for (ModuleWizardStep step : this.mySteps) {
            if (!stepName.equals(step.getName())) continue;
            this.myCurrentStep = this.mySteps.indexOf(step);
            this.updateWizard();
            return;
        }
    }

    @Override
    public boolean isPathVisible() {
        ModuleTemplate moduleTemplate = this.myWizard.getState().get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        return moduleTemplate != null && Iterables.contains(this.myTypes, (Object)moduleTemplate);
    }

    @Override
    public int getVisibleStepCount() {
        int count = 0;
        for (ModuleWizardStep step : this.mySteps) {
            if (!this.myWizardPath.isStepVisible(step)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void attachToWizard(DynamicWizard dynamicWizard) {
        this.myWizard = dynamicWizard;
    }

    @Override
    @Nullable
    public DynamicWizard getWizard() {
        return this.myWizard;
    }

    @Override
    public boolean isPathRequired() {
        return true;
    }

    @Override
    @Nullable
    public Step next() {
        return this.navigate(1);
    }

    private Step navigate(int direction) {
        this.myCurrentStep = this.findNext(this.myCurrentStep, direction);
        assert (this.myCurrentStep >= 0);
        this.updateWizard();
        return (Step)this.mySteps.get(this.myCurrentStep);
    }

    @Override
    @Nullable
    public Step previous() {
        return this.navigate(-1);
    }

    @Override
    public boolean performFinishingActions() {
        this.myWizardPath.createModule();
        return true;
    }

    @Override
    public void updateCurrentStep() {
    }

    @Override
    public void setErrorHtml(String errorMessage) {
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        if (this.myTypes == null) {
            this.myTypes = ImmutableList.copyOf((Iterable)Iterables.transform(this.myWizardPath.getBuiltInTemplates(), (Function)new Function<ChooseTemplateStep.MetadataListItem, ModuleTemplate>(){

                public ModuleTemplate apply(ChooseTemplateStep.MetadataListItem input) {
                    return new TemplateEntryModuleTemplate(input);
                }
            }));
        }
        Iterable<ModuleTemplate> iterable = this.myTypes;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/LegacyPathWrapper", "getModuleTemplates"));
        }
        return iterable;
    }

    public void updateWizard() {
        if (this.isPathVisible()) {
            for (ModuleWizardStep step : this.myWizardPath.getSteps()) {
                step.updateStep();
            }
            this.myWizard.updateButtons(true, this.canGoNext(), !this.canGoNext() && LegacyPathWrapper.isStepValid(this.getCurrentStep()));
        }
    }

    @Override
    public boolean readyToLeavePath() {
        return true;
    }

    private static final class TemplateEntryModuleTemplate
    implements ModuleTemplate {
        private final ChooseTemplateStep.MetadataListItem myTemplate;

        public TemplateEntryModuleTemplate(ChooseTemplateStep.MetadataListItem template) {
            this.myTemplate = template;
        }

        @Override
        public boolean isGalleryModuleType() {
            return false;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        public String toString() {
            return this.myTemplate.toString();
        }

        @Override
        public String getName() {
            return this.myTemplate.toString();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplate != null ? this.myTemplate.getDescription() : "";
        }

        @Override
        public void updateWizardStateOnSelection(ScopedStateStore state) {
        }

        @Override
        @Nullable
        public FormFactorUtils.FormFactor getFormFactor() {
            return null;
        }

        public File getTemplateFile() {
            return this.myTemplate.getTemplateFile();
        }
    }
}

