/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.ChooseFromFileListDialog;
import com.android.tools.idea.wizard.ChooseGithubRepositoryStep;
import com.android.tools.idea.wizard.NewTemplateObjectWizard;
import com.android.tools.idea.wizard.TemplateWizard;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFromGithubWizard
extends TemplateWizard
implements TemplateWizardStep.UpdateListener {
    private static final Logger LOG = Logger.getInstance(NewFromGithubWizard.class);
    private static final String WIZARD_TITLE = "From GitHub";
    private static final long TIMEOUT = 3600000L;
    @Nullable
    private final VirtualFile myTargetFile;
    private Module myModule;
    private TemplateWizardState myWizardState = new TemplateWizardState();
    private ChooseGithubRepositoryStep myChooseGithubRepositoryStep;

    public NewFromGithubWizard(@Nullable Project project, @Nullable Module module, @Nullable VirtualFile targetFile) {
        super(WIZARD_TITLE, project);
        this.myModule = module;
        this.myTargetFile = targetFile;
        this.init();
    }

    @Override
    protected void init() {
        this.myChooseGithubRepositoryStep = new ChooseGithubRepositoryStep(this.myWizardState, this.myProject, this.myModule, this);
        this.mySteps.add(0, this.myChooseGithubRepositoryStep);
        super.init();
    }

    @NotNull
    public static GithubRepoContents downloadGithubRepo(@NotNull Project project, @NotNull String url, @Nullable String branch, @Nullable File cacheDirectory) {
        URL parsedUrl;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/NewFromGithubWizard", "downloadGithubRepo"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/wizard/NewFromGithubWizard", "downloadGithubRepo"));
        }
        GithubRepoContents returnValue = new GithubRepoContents();
        if (cacheDirectory == null) {
            cacheDirectory = new File(FileUtil.getTempDirectory(), "github_cache");
        }
        if (branch == null || branch.trim().isEmpty()) {
            branch = "master";
        }
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            returnValue.errorMessage = "Malformed URL";
            GithubRepoContents githubRepoContents = returnValue;
            if (githubRepoContents == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFromGithubWizard", "downloadGithubRepo"));
            }
            return githubRepoContents;
        }
        String repositoryName = "Github" + parsedUrl.getPath().replace('/', '-');
        final File outputFile = new File(cacheDirectory, repositoryName + ".zip");
        final String finalUrl = url + "/zipball/" + branch;
        File unzippedDir = new File(cacheDirectory, repositoryName);
        if (!unzippedDir.exists() || unzippedDir.lastModified() == 0L || System.currentTimeMillis() - unzippedDir.lastModified() > 3600000L) {
            FileUtil.delete((File)unzippedDir);
            try {
                Outcome outcome = DownloadUtil.provideDataWithProgressSynchronously((Project)project, (String)"Downloading project from GitHub", (String)"Downloading zip archive${content-length} ...", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                        DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)finalUrl, (File)outputFile);
                        return outputFile;
                    }
                }, null);
                Exception e = outcome.getException();
                if (e != null) {
                    throw e;
                }
                ZipUtil.unzip((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (File)unzippedDir, (File)outputFile, null, null, (boolean)true);
            }
            catch (Exception e) {
                returnValue.errorMessage = "Could not download specified project from Github. Check the URL and branchname.\n\n" + e.getMessage();
                GithubRepoContents githubRepoContents = returnValue;
                if (githubRepoContents == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFromGithubWizard", "downloadGithubRepo"));
                }
                return githubRepoContents;
            }
            outputFile.delete();
        }
        returnValue.rootFolder = unzippedDir;
        returnValue.templateFolders = TemplateManager.getTemplatesFromDirectory(unzippedDir, true);
        returnValue.sampleRoots = NewFromGithubWizard.findSamplesInDirectory(unzippedDir, true);
        GithubRepoContents githubRepoContents = returnValue;
        if (githubRepoContents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFromGithubWizard", "downloadGithubRepo"));
        }
        return githubRepoContents;
    }

    @NotNull
    public static List<File> findSamplesInDirectory(@NotNull File directory, boolean recursive) {
        File[] files;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/wizard/NewFromGithubWizard", "findSamplesInDirectory"));
        }
        ArrayList samples = Lists.newArrayList();
        if (new File(directory, "build.gradle").exists() || new File(directory, "settings.gradle").exists()) {
            samples.add(directory);
        }
        if (recursive && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                samples.addAll(NewFromGithubWizard.findSamplesInDirectory(file, true));
            }
        }
        ArrayList arrayList = samples;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewFromGithubWizard", "findSamplesInDirectory"));
        }
        return arrayList;
    }

    @Nullable
    public static String runTemplateWizard(@Nullable Project project, @Nullable Module module, @Nullable VirtualFile targetLocation, @NotNull GithubRepoContents githubRepoContents) {
        if (githubRepoContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "githubRepoContents", "com/android/tools/idea/wizard/NewFromGithubWizard", "runTemplateWizard"));
        }
        if (githubRepoContents.templateFolders == null || githubRepoContents.templateFolders.isEmpty()) {
            String error = githubRepoContents.errorMessage != null ? githubRepoContents.errorMessage : "No templates found. Please check the repository that you are attempting to import from.";
            return error;
        }
        NewTemplateObjectWizard wizard = githubRepoContents.templateFolders.size() == 1 ? new NewTemplateObjectWizard(project, module, targetLocation, WIZARD_TITLE, githubRepoContents.templateFolders.get(0)) : new NewTemplateObjectWizard(project, module, targetLocation, WIZARD_TITLE, githubRepoContents.templateFolders);
        wizard.show();
        if (wizard.isOK()) {
            wizard.createTemplateObject();
        }
        return null;
    }

    @Nullable
    private static String runImportWizard(Project project, Module module, GithubRepoContents githubRepoContents) {
        VirtualFile sourceFolder;
        if (githubRepoContents.sampleRoots == null || githubRepoContents.sampleRoots.isEmpty()) {
            String error = githubRepoContents.errorMessage != null ? githubRepoContents.errorMessage : "No importable samples found. Please check the repository that you are attempting to import from.";
            return error;
        }
        if (githubRepoContents.sampleRoots.size() == 1) {
            sourceFolder = VfsUtil.findFileByIoFile((File)githubRepoContents.rootFolder, (boolean)false);
        } else {
            ChooseFromFileListDialog dialog = new ChooseFromFileListDialog(project, githubRepoContents.sampleRoots);
            dialog.show();
            if (dialog.isOK()) {
                sourceFolder = VfsUtil.findFileByIoFile((File)dialog.getChosenFile(), (boolean)false);
            } else {
                return null;
            }
        }
        if (sourceFolder == null) {
            return "No file selected";
        }
        try {
            AndroidImportModuleAction.importGradleSubprojectAsModule(sourceFolder, project);
        }
        catch (IOException e) {
            return "An error occurred while importing a sample from github: " + e.getMessage();
        }
        return null;
    }

    private void setErrorHtml(String s) {
        ((TemplateWizardStep)this.mySteps.get(this.getCurrentStep())).setErrorHtml(s);
    }

    protected void doOKAction() {
        GithubRepoContents downloadResult = NewFromGithubWizard.downloadGithubRepo(this.myProject, this.myChooseGithubRepositoryStep.getUrl(), this.myChooseGithubRepositoryStep.getBranch(), null);
        if (downloadResult.errorMessage != null) {
            this.setErrorHtml(downloadResult.errorMessage);
            return;
        }
        assert (downloadResult.templateFolders != null && downloadResult.sampleRoots != null);
        super.doOKAction();
        String error = !downloadResult.templateFolders.isEmpty() ? NewFromGithubWizard.runTemplateWizard(this.myProject, this.myModule, this.myTargetFile, downloadResult) : NewFromGithubWizard.runImportWizard(this.myProject, this.myModule, downloadResult);
        if (error != null) {
            LOG.error(error);
        }
    }

    public static class GithubRepoContents {
        public List<File> templateFolders;
        public List<File> sampleRoots;
        public File rootFolder;
        public String errorMessage;
    }
}

