/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Log;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.adb.AdbService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.logcat.AdbErrors;
import org.jetbrains.android.logcat.AndroidLogcatConstants;
import org.jetbrains.android.logcat.AndroidLogcatView;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final String TOOL_WINDOW_ID = AndroidBundle.message("android.logcat.title", new Object[0]);
    @NonNls
    private static final String DEVICE_PANEL_CONTENT = "DevicePanelContent";
    @NonNls
    private static final String ADBLOGS_CONTENT_ID = "AdbLogsContent";
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/logcat/AndroidToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "org/jetbrains/android/logcat/AndroidToolWindowFactory", "createToolWindowContent"));
        }
        RunnerLayoutUi layoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("ddms", "ddms", "ddms", (Disposable)project);
        toolWindow.setIcon(AndroidIcons.AndroidToolWindow);
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        DeviceContext deviceContext = new DeviceContext();
        Content devicesContent = AndroidToolWindowFactory.createDeviceContent(layoutUi, project, deviceContext);
        Content logcatContent = AndroidToolWindowFactory.createLogcatContent(layoutUi, project, deviceContext);
        Content adbLogsContent = this.createAdbLogsContent(layoutUi, project);
        final AndroidLogcatView logcatView = (AndroidLogcatView)logcatContent.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
        DevicePanel devicePanel = (DevicePanel)devicesContent.getUserData(DEVICES_PANEL_KEY);
        assert (logcatView != null);
        assert (devicePanel != null);
        devicesContent.setSearchComponent((JComponent)logcatView.createSearchComponent(project));
        layoutUi.addContent(devicesContent, 0, PlaceInGrid.left, false);
        layoutUi.addContent(logcatContent, 0, PlaceInGrid.center, false);
        layoutUi.addContent(adbLogsContent, 1, PlaceInGrid.center, false);
        layoutUi.getOptions().setLeftToolbar(devicePanel.getToolbarActions(), "unknown");
        layoutUi.getOptions().setTopToolbar(logcatView.getToolbarActions(), "unknown");
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        loadingPanel.add((Component)layoutUi.getComponent());
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)loadingPanel, "DDMS", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)devicePanel);
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleView console;
                logcatView.activate();
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && window.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                    AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                }
            }
        }, project.getDisposed());
        File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        loadingPanel.setLoadingText("Initializing ADB");
        loadingPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future = AdbService.getDebugBridge(adb);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                loadingPanel.stopLoading();
            }

            public void onFailure(Throwable t) {
                loadingPanel.stopLoading();
                Logger LOG = Logger.getInstance(DevicePanel.class);
                LOG.error("Unable to obtain debug bridge", t);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private static Content createDeviceContent(RunnerLayoutUi layoutUi, Project project, DeviceContext deviceContext) {
        DevicePanel devicePanel = new DevicePanel(project, deviceContext);
        Content devicesContent = layoutUi.createContent(DEVICE_PANEL_CONTENT, (JComponent)devicePanel.getContentPanel(), AndroidBundle.message("android.ddms.devicepanel.title", new Object[0]), AndroidIcons.Android, null);
        devicesContent.setCloseable(false);
        devicesContent.putUserData(DEVICES_PANEL_KEY, (Object)devicePanel);
        return devicesContent;
    }

    private static Content createLogcatContent(RunnerLayoutUi layoutUi, final Project project, DeviceContext deviceContext) {
        final AndroidLogcatView logcatView = new AndroidLogcatView(project, deviceContext){

            @Override
            protected boolean isActive() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                return window.isVisible();
            }
        };
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){
            boolean myToolWindowVisible;

            public void stateChanged() {
                boolean visible;
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && (visible = window.isVisible()) != this.myToolWindowVisible) {
                    ConsoleView console;
                    this.myToolWindowVisible = visible;
                    logcatView.activate();
                    if (visible && (console = logcatView.getLogConsole().getConsole()) != null) {
                        AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                    }
                }
            }
        });
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        JPanel logcatContentPanel = logcatView.getContentPanel();
        Content logcatContent = layoutUi.createContent("Android Logcat", (JComponent)logcatContentPanel, "logcat", AndroidIcons.Ddms.Logcat, null);
        logcatContent.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        logcatContent.setDisposer((Disposable)logcatView);
        logcatContent.setCloseable(false);
        logcatContent.setPreferredFocusableComponent((JComponent)logcatContentPanel);
        return logcatContent;
    }

    private Content createAdbLogsContent(RunnerLayoutUi layoutUi, Project project) {
        ConsoleViewImpl console = new ConsoleViewImpl(project, false);
        Content adbLogsContent = layoutUi.createContent(ADBLOGS_CONTENT_ID, console.getComponent(), AndroidBundle.message("android.adb.logs.tab.title", new Object[0]), null, null);
        adbLogsContent.setCloseable(false);
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput((ConsoleView)console){
            final /* synthetic */ ConsoleView val$console;
            {
                this.val$console = consoleView;
            }

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
                AndroidToolWindowFactory.reportAdbLogMessage(logLevel, tag, message, this.val$console);
            }

            public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
                AndroidToolWindowFactory.reportAdbLogMessage(logLevel, tag, message, this.val$console);
            }
        });
        return adbLogsContent;
    }

    private static void reportAdbLogMessage(Log.LogLevel logLevel, String tag, String message, @NotNull ConsoleView consoleView) {
        ConsoleViewContentType contentType;
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "org/jetbrains/android/logcat/AndroidToolWindowFactory", "reportAdbLogMessage"));
        }
        if (message == null) {
            return;
        }
        if (logLevel == null) {
            logLevel = Log.LogLevel.INFO;
        }
        if (logLevel == Log.LogLevel.ERROR || logLevel == Log.LogLevel.ASSERT) {
            AdbErrors.reportError(message, tag);
        }
        if ((contentType = AndroidToolWindowFactory.toConsoleViewContentType(logLevel)) == null) {
            return;
        }
        String fullMessage = tag != null ? tag + ": " + message : message;
        consoleView.print(fullMessage + '\n', contentType);
    }

    @Nullable
    private static ConsoleViewContentType toConsoleViewContentType(@NotNull Log.LogLevel logLevel) {
        if (logLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logLevel", "org/jetbrains/android/logcat/AndroidToolWindowFactory", "toConsoleViewContentType"));
        }
        switch (logLevel) {
            case VERBOSE: {
                return null;
            }
            case DEBUG: {
                return null;
            }
            case INFO: {
                return ConsoleViewContentType.getConsoleViewType((Key)AndroidLogcatConstants.INFO);
            }
            case WARN: {
                return ConsoleViewContentType.getConsoleViewType((Key)AndroidLogcatConstants.WARNING);
            }
            case ERROR: {
                return ConsoleViewContentType.getConsoleViewType((Key)AndroidLogcatConstants.ERROR);
            }
            case ASSERT: {
                return ConsoleViewContentType.getConsoleViewType((Key)AndroidLogcatConstants.ASSERT);
            }
        }
        assert (false) : "Unknown log level " + logLevel;
        return null;
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/android/logcat/AndroidToolWindowFactory", "checkFacetAndSdk"));
        }
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        if (facets.size() == 0) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            console.clear();
            final Module module = facet.getModule();
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
                console.printHyperlink("configure", new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                });
                console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                console.print(AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName()) + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
    }

    private static class MyAndroidPlatformListener
    extends ModuleRootAdapter {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "org/jetbrains/android/logcat/AndroidToolWindowFactory$MyAndroidPlatformListener", "<init>"));
            }
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(ModuleRootEvent event) {
            final ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
            if (window == null) {
                return;
            }
            if (window.isDisposed() || !window.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Comparing.equal((Object)this.myPrevPlatform, (Object)newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!window.isDisposed() && window.isVisible()) {
                            MyAndroidPlatformListener.this.myView.activate();
                        }
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.size() > 0) {
                AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
                newPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            }
            return newPlatform;
        }
    }
}

