/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.Bootstrap;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Restarter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class Main {
    public static final int UPDATE_FAILED = 1;
    public static final int STARTUP_EXCEPTION = 2;
    public static final int STARTUP_IMPOSSIBLE = 3;
    public static final int LICENSE_ERROR = 4;
    public static final int PLUGIN_ERROR = 5;
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    private static final String[] NO_ARGS = new String[0];
    private static boolean isHeadless;
    private static boolean isCommandLine;

    private Main() {
    }

    public static void main(String[] args) {
        if (args.length == 1 && "%f".equals(args[0])) {
            args = NO_ARGS;
        }
        Main.setFlags(args);
        if (Main.isHeadless()) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        } else {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("Unable to detect graphics environment");
            }
            if (args.length == 0) {
                try {
                    Main.installPatch();
                }
                catch (Throwable t) {
                    Main.showMessage("Update Failed", t);
                    System.exit(1);
                }
            }
        }
        try {
            Bootstrap.main(args, Main.class.getName() + "Impl", "start");
        }
        catch (Throwable t) {
            Main.showMessage("Start Failed", t);
            System.exit(2);
        }
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static void setFlags(String[] args) {
        isHeadless = Main.isHeadless(args);
        isCommandLine = Main.isCommandLine(args);
    }

    private static boolean isHeadless(String[] args) {
        if (Boolean.valueOf(System.getProperty(AWT_HEADLESS)).booleanValue()) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String firstArg = args[0];
        return Comparing.strEqual((String)firstArg, (String)"ant") || Comparing.strEqual((String)firstArg, (String)"duplocate") || Comparing.strEqual((String)firstArg, (String)"traverseUI") || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    private static boolean isCommandLine(String[] args) {
        if (Main.isHeadless()) {
            return true;
        }
        return args.length > 0 && Comparing.strEqual((String)args[0], (String)"diff");
    }

    public static boolean isUITraverser(String[] args) {
        return args.length > 0 && Comparing.strEqual((String)args[0], (String)"traverseUI");
    }

    private static void installPatch() throws IOException {
        String platform = System.getProperty(PLATFORM_PREFIX_PROPERTY, "idea");
        String patchFileName = ("jetbrains.patch.jar." + platform).toLowerCase(Locale.US);
        String tempDir = System.getProperty("java.io.tmpdir");
        File patchCopy = new File(tempDir, patchFileName + "_copy");
        File log4jCopy = new File(tempDir, "log4j.jar." + platform + "_copy");
        if (!FileUtilRt.delete((File)patchCopy) || !FileUtilRt.delete((File)log4jCopy)) {
            throw new IOException("Cannot delete temporary files in " + tempDir);
        }
        File patch = new File(tempDir, patchFileName);
        if (!patch.exists()) {
            return;
        }
        File log4j = new File(PathManager.getLibPath(), "log4j.jar");
        if (!log4j.exists()) {
            throw new IOException("Log4J missing: " + log4j);
        }
        Main.copyFile(patch, patchCopy, true);
        Main.copyFile(log4j, log4jCopy, false);
        int status = 0;
        if (Restarter.isSupported()) {
            ArrayList<String> args = new ArrayList<String>();
            if (SystemInfoRt.isWindows) {
                File launcher = new File(PathManager.getBinPath(), "VistaLauncher.exe");
                args.add(Restarter.createTempExecutable((File)launcher).getPath());
            }
            Collections.addAll(args, System.getProperty("java.home") + "/bin/java", "-Xmx500m", "-classpath", patchCopy.getPath() + File.pathSeparator + log4jCopy.getPath(), "-Djava.io.tmpdir=" + tempDir, "-Didea.updater.log=" + PathManager.getLogPath(), "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName(), "com.intellij.updater.Runner", "install", PathManager.getHomePath());
            status = Restarter.scheduleRestart((String[])ArrayUtilRt.toStringArray(args));
        } else {
            String message = "Patch update is not supported - please do it manually";
            Main.showMessage("Update Error", message, true);
        }
        System.exit(status);
    }

    private static void copyFile(File original, File copy, boolean move) throws IOException {
        if (move) {
            if (!original.renameTo(copy) || !FileUtilRt.delete((File)original)) {
                throw new IOException("Cannot create temporary file: " + copy);
            }
        } else {
            FileUtilRt.copy((File)original, (File)copy);
            if (!copy.exists()) {
                throw new IOException("Cannot create temporary file: " + copy);
            }
        }
    }

    public static void showMessage(String title, Throwable t) {
        StringWriter message = new StringWriter();
        message.append("Internal error. Please report to http://");
        boolean studio = "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
        message.append(studio ? "code.google.com/p/android/issues" : "youtrack.jetbrains.com");
        message.append("\n\n");
        t.printStackTrace(new PrintWriter(message));
        Main.showMessage(title, message.toString(), true);
    }

    public static void showMessage(String title, String message, boolean error) {
        if (Main.isCommandLine()) {
            PrintStream stream = error ? System.err : System.out;
            stream.println("\n" + title + ": " + message);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            JTextPane textPane = new JTextPane();
            textPane.setEditable(false);
            textPane.setText(message.replaceAll("\t", "    "));
            textPane.setBackground(Color.white);
            textPane.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textPane, 20, 31);
            int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 150;
            Dimension component = scrollPane.getPreferredSize();
            if (component.height >= maxHeight) {
                Object setting = UIManager.get("ScrollBar.width");
                int width = setting instanceof Integer ? (Integer)setting : 20;
                scrollPane.setPreferredSize(new Dimension(component.width + width, maxHeight));
            }
            int type = error ? 0 : 1;
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, title, type);
        }
    }
}

