/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.TestSourceFolder")
public class TestDataGroupVirtualFile
extends VirtualFile {
    private final VirtualFile myBeforeFile;
    private final VirtualFile myAfterFile;

    public TestDataGroupVirtualFile(VirtualFile beforeFile, VirtualFile afterFile) {
        this.myBeforeFile = beforeFile;
        this.myAfterFile = afterFile;
    }

    @NotNull
    public String getName() {
        String prefix = StringUtil.commonPrefix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
        if (prefix.isEmpty()) {
            String string = StringUtil.commonSuffix((String)this.myBeforeFile.getName(), (String)this.myAfterFile.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getName"));
            }
            return string;
        }
        String string = prefix + "." + this.myBeforeFile.getExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getName"));
        }
        return string;
    }

    public VirtualFile getBeforeFile() {
        return this.myBeforeFile;
    }

    public VirtualFile getAfterFile() {
        return this.myAfterFile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getFileSystem"));
        }
        return localFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myBeforeFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGroupVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.myBeforeFile.isValid() && this.myAfterFile.isValid();
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

