/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WeakStringInterner
extends StringInterner {
    private final ConcurrentWeakHashMap<String, WeakReference<String>> myMap = new ConcurrentWeakHashMap();

    @Override
    @NotNull
    public String intern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        WeakReference<String> key = new WeakReference<String>(name);
        String interned = (String)SoftReference.dereference(ConcurrencyUtil.cacheOrGet(this.myMap, name, key));
        if (interned != null) {
            String string = interned;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "intern"));
            }
            return string;
        }
        this.myMap.put((Object)name, key);
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        return string;
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    @NotNull
    public Set<String> getValues() {
        HashSet<String> result = ContainerUtil.newHashSet();
        for (WeakReference value : this.myMap.values()) {
            ContainerUtil.addIfNotNull(result, value.get());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "getValues"));
        }
        return hashSet;
    }
}

