/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStringUtil {
    @NonNls
    private static final String HTML_HEADER = "<html>";
    @NonNls
    private static final String BODY_HEADER = "<body>";
    @NonNls
    private static final String HTML_FOOTER = "</html>";
    @NonNls
    private static final String BODY_FOOTER = "</body>";

    private XmlStringUtil() {
    }

    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xml/util/XmlStringUtil", "wrapInHtml"));
        }
        String string = HTML_HEADER + result + HTML_FOOTER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "wrapInHtml"));
        }
        return string;
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        if (tooltip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltip", "com/intellij/xml/util/XmlStringUtil", "isWrappedInHtml"));
        }
        return StringUtil.startsWithIgnoreCase(tooltip, HTML_HEADER) && StringUtil.endsWithIgnoreCase(tooltip, HTML_FOOTER);
    }

    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        if (toolTip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolTip", "com/intellij/xml/util/XmlStringUtil", "stripHtml"));
        }
        toolTip = StringUtil.trimStart(toolTip, HTML_HEADER);
        toolTip = StringUtil.trimStart(toolTip, BODY_HEADER);
        toolTip = StringUtil.trimEnd(toolTip, HTML_FOOTER);
        String string = toolTip = StringUtil.trimEnd(toolTip, BODY_FOOTER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlStringUtil", "stripHtml"));
        }
        return string;
    }
}

