/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.util.UntrackedFilesNotifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker {
    private static final String CHERRY_PICK_HEAD_FILE = "CHERRY_PICK_HEAD";
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final ChangeListManager myChangeListManager;
    private final boolean myAutoCommit;

    public GitCherryPicker(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade platformFacade, boolean autoCommit) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPicker", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/cherrypick/GitCherryPicker", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/cherrypick/GitCherryPicker", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myPlatformFacade = platformFacade;
        this.myAutoCommit = autoCommit;
        this.myChangeListManager = this.myPlatformFacade.getChangeListManager(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cherryPick(@NotNull Map<GitRepository, List<VcsFullCommitDetails>> commitsInRoots) {
        if (commitsInRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsInRoots", "git4idea/cherrypick/GitCherryPicker", "cherryPick"));
        }
        ArrayList<GitCommitWrapper> successfulCommits = new ArrayList<GitCommitWrapper>();
        DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            for (Map.Entry<GitRepository, List<VcsFullCommitDetails>> entry : commitsInRoots.entrySet()) {
                GitRepository repository = entry.getKey();
                boolean result = this.cherryPick(repository, entry.getValue(), successfulCommits);
                repository.update();
                if (result) continue;
                return;
            }
            this.notifySuccess(successfulCommits);
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject);
        }
    }

    private boolean cherryPick(@NotNull GitRepository repository, @NotNull List<VcsFullCommitDetails> commits, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "cherryPick"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPicker", "cherryPick"));
        }
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "cherryPick"));
        }
        for (VcsFullCommitDetails commit : commits) {
            GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
            GitSimpleEventDetector localChangesOverwrittenDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository.getRoot());
            GitCommandResult result = this.myGit.cherryPick(repository, ((Hash)commit.getId()).asString(), this.myAutoCommit, conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector);
            GitCommitWrapper commitWrapper = new GitCommitWrapper(commit);
            if (result.success()) {
                if (this.myAutoCommit) {
                    successfulCommits.add(commitWrapper);
                    continue;
                }
                boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits);
                if (committed) continue;
                this.notifyCommitCancelled(commitWrapper, successfulCommits);
                return false;
            }
            if (conflictDetector.hasHappened()) {
                boolean mergeCompleted = new CherryPickConflictResolver(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getId()).asString(), commit.getAuthor().getName(), commit.getSubject()).merge();
                if (mergeCompleted) {
                    boolean committed = this.updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(repository, commitWrapper, successfulCommits);
                    if (committed) continue;
                    this.notifyCommitCancelled(commitWrapper, successfulCommits);
                    return false;
                }
                this.updateChangeListManager(commit);
                this.notifyConflictWarning(repository, commitWrapper, successfulCommits);
                return false;
            }
            if (untrackedFilesDetector.wasMessageDetected()) {
                String description = GitCherryPicker.commitDetails(commitWrapper) + "<br/>Some untracked working tree files would be overwritten by cherry-pick.<br/>" + "Please move, remove or add them before you can cherry-pick. <a href='view'>View them</a>";
                description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
                UntrackedFilesNotifier.notifyUntrackedFilesOverwrittenBy(this.myProject, repository.getRoot(), untrackedFilesDetector.getRelativeFilePaths(), "cherry-pick", description);
                return false;
            }
            if (localChangesOverwrittenDetector.hasHappened()) {
                this.notifyError("Your local changes would be overwritten by cherry-pick.<br/>Commit your changes or stash them to proceed.", commitWrapper, successfulCommits);
                return false;
            }
            this.notifyError(result.getErrorOutputAsHtmlString(), commitWrapper, successfulCommits);
            return false;
        }
        return true;
    }

    private boolean updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess(@NotNull GitRepository repository, @NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess"));
        }
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "updateChangeListManagerShowCommitDialogAndRemoveChangeListOnSuccess"));
        }
        CherryPickData data = this.updateChangeListManager(commit.getCommit());
        boolean committed = this.showCommitDialogAndWaitForCommit(repository, commit, data.myChangeList, data.myCommitMessage);
        if (committed) {
            this.removeChangeList(data);
            successfulCommits.add(commit);
            return true;
        }
        return false;
    }

    private void removeChangeList(CherryPickData list) {
        this.myChangeListManager.setDefaultChangeList(list.myPreviouslyDefaultChangeList);
        if (!this.myChangeListManager.getDefaultChangeList().equals(list.myChangeList)) {
            this.myChangeListManager.removeChangeList(list.myChangeList);
        }
    }

    private void notifyConflictWarning(@NotNull GitRepository repository, @NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "notifyConflictWarning"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "notifyConflictWarning"));
        }
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "notifyConflictWarning"));
        }
        ResolveLinkListener resolveLinkListener = new ResolveLinkListener(this.myProject, this.myGit, this.myPlatformFacade, repository.getRoot(), ((Hash)commit.getCommit().getId()).toShortString(), commit.getCommit().getAuthor().getName(), commit.getSubject());
        String description = GitCherryPicker.commitDetails(commit) + "<br/>Unresolved conflicts remain in the working tree. <a href='resolve'>Resolve them.<a/>";
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Cherry-picked with conflicts", description, (NotificationListener)resolveLinkListener);
    }

    private void notifyCommitCancelled(@NotNull GitCommitWrapper commit, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "notifyCommitCancelled"));
        }
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "notifyCommitCancelled"));
        }
        if (successfulCommits.isEmpty()) {
            return;
        }
        String description = GitCherryPicker.commitDetails(commit);
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Cherry-pick cancelled", description, null);
    }

    private CherryPickData updateChangeListManager(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "updateChangeListManager"));
        }
        List paths = ChangesUtil.getPaths((Collection)commit.getChanges());
        this.refreshChangedFiles(paths);
        String commitMessage = GitCherryPicker.createCommitMessage(commit);
        LocalChangeList previouslyDefaultChangeList = this.myChangeListManager.getDefaultChangeList();
        LocalChangeList changeList = this.createChangeListAfterUpdate(commit, paths, commitMessage);
        return new CherryPickData(changeList, commitMessage, previouslyDefaultChangeList);
    }

    @NotNull
    private LocalChangeList createChangeListAfterUpdate(final @NotNull VcsFullCommitDetails commit, final @NotNull Collection<FilePath> paths, final @NotNull String commitMessage) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "createChangeListAfterUpdate"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "git4idea/cherrypick/GitCherryPicker", "createChangeListAfterUpdate"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker", "createChangeListAfterUpdate"));
        }
        final AtomicReference changeList = new AtomicReference();
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GitCherryPicker.this.myChangeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        changeList.set(GitCherryPicker.this.createChangeList(commit, commitMessage));
                    }
                }, InvokeAfterUpdateMode.SYNCHRONOUS_NOT_CANCELLABLE, "Cherry-pick", (Consumer)new Consumer<VcsDirtyScopeManager>(){

                    public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                        vcsDirtyScopeManager.filePathsDirty(paths, null);
                    }
                }, ModalityState.NON_MODAL);
            }
        }, ModalityState.NON_MODAL);
        LocalChangeList localChangeList = (LocalChangeList)changeList.get();
        if (localChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createChangeListAfterUpdate"));
        }
        return localChangeList;
    }

    @NotNull
    private static String createCommitMessage(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "createCommitMessage"));
        }
        String string = commit.getFullMessage() + "\n(cherry picked from commit " + ((Hash)commit.getId()).toShortString() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createCommitMessage"));
        }
        return string;
    }

    private boolean showCommitDialogAndWaitForCommit(final @NotNull GitRepository repository, final @NotNull GitCommitWrapper commit, final @NotNull LocalChangeList changeList, final @NotNull String commitMessage) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "showCommitDialogAndWaitForCommit"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "showCommitDialogAndWaitForCommit"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "git4idea/cherrypick/GitCherryPicker", "showCommitDialogAndWaitForCommit"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker", "showCommitDialogAndWaitForCommit"));
        }
        final AtomicBoolean commitSucceeded = new AtomicBoolean();
        final Semaphore sem = new Semaphore(0);
        this.myPlatformFacade.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    GitCherryPicker.this.cancelCherryPick(repository);
                    Collection changes = commit.getCommit().getChanges();
                    boolean commitNotCancelled = GitCherryPicker.this.myPlatformFacade.getVcsHelper(GitCherryPicker.this.myProject).commitChanges(changes, changeList, commitMessage, new CommitResultHandler(){

                        public void onSuccess(@NotNull String commitMessage) {
                            if (commitMessage == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker$2$1", "onSuccess"));
                            }
                            commit.setActualSubject(commitMessage);
                            commitSucceeded.set(true);
                            sem.release();
                        }

                        public void onFailure() {
                            commitSucceeded.set(false);
                            sem.release();
                        }
                    });
                    if (!commitNotCancelled) {
                        commitSucceeded.set(false);
                        sem.release();
                    }
                }
                catch (Throwable t) {
                    LOG.error(t);
                    commitSucceeded.set(false);
                    sem.release();
                }
            }
        }, ModalityState.NON_MODAL);
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private void cancelCherryPick(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "cancelCherryPick"));
        }
        if (this.myAutoCommit) {
            this.removeCherryPickHead(repository);
        }
    }

    private void removeCherryPickHead(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "removeCherryPickHead"));
        }
        File cherryPickHeadFile = new File(repository.getGitDir().getPath(), CHERRY_PICK_HEAD_FILE);
        final VirtualFile cherryPickHead = this.myPlatformFacade.getLocalFileSystem().refreshAndFindFileByIoFile(cherryPickHeadFile);
        if (cherryPickHead != null && cherryPickHead.exists()) {
            this.myPlatformFacade.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        cherryPickHead.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    private void notifyError(@NotNull String content, @NotNull GitCommitWrapper failedCommit, @NotNull List<GitCommitWrapper> successfulCommits) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "git4idea/cherrypick/GitCherryPicker", "notifyError"));
        }
        if (failedCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedCommit", "git4idea/cherrypick/GitCherryPicker", "notifyError"));
        }
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "notifyError"));
        }
        String description = GitCherryPicker.commitDetails(failedCommit) + "<br/>" + content;
        description = description + GitCherryPicker.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("Cherry-pick failed", description);
    }

    @NotNull
    private static String getSuccessfulCommitDetailsIfAny(@NotNull List<GitCommitWrapper> successfulCommits) {
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "getSuccessfulCommitDetailsIfAny"));
        }
        String description = "";
        if (!successfulCommits.isEmpty()) {
            description = description + "<hr/>However cherry-pick succeeded for the following " + StringUtil.pluralize((String)"commit", (int)successfulCommits.size()) + ":<br/>";
            description = description + GitCherryPicker.getCommitsDetails(successfulCommits);
        }
        String string = description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "getSuccessfulCommitDetailsIfAny"));
        }
        return string;
    }

    private void notifySuccess(@NotNull List<GitCommitWrapper> successfulCommits) {
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "notifySuccess"));
        }
        String description = GitCherryPicker.getCommitsDetails(successfulCommits);
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Cherry-pick successful", description);
    }

    @NotNull
    private static String getCommitsDetails(@NotNull List<GitCommitWrapper> successfulCommits) {
        if (successfulCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCommits", "git4idea/cherrypick/GitCherryPicker", "getCommitsDetails"));
        }
        String description = "";
        for (GitCommitWrapper commit : successfulCommits) {
            description = description + GitCherryPicker.commitDetails(commit) + "<br/>";
        }
        String string = description.substring(0, description.length() - "<br/>".length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "getCommitsDetails"));
        }
        return string;
    }

    @NotNull
    private static String commitDetails(@NotNull GitCommitWrapper commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "commitDetails"));
        }
        String string = ((Hash)commit.getCommit().getId()).toShortString() + " " + commit.getOriginalSubject();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "commitDetails"));
        }
        return string;
    }

    private void refreshChangedFiles(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "git4idea/cherrypick/GitCherryPicker", "refreshChangedFiles"));
        }
        List virtualFiles = ContainerUtil.skipNulls((Collection)ContainerUtil.map(filePaths, (Function)new Function<FilePath, VirtualFile>(){

            public VirtualFile fun(FilePath file) {
                return GitCherryPicker.this.myPlatformFacade.getLocalFileSystem().refreshAndFindFileByPath(file.getPath());
            }
        }));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray((Collection)virtualFiles, VirtualFile.class)));
    }

    @NotNull
    private LocalChangeList createChangeList(@NotNull VcsFullCommitDetails commit, @NotNull String commitMessage) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "createChangeList"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker", "createChangeList"));
        }
        Collection changes = commit.getChanges();
        if (!changes.isEmpty()) {
            String changeListName = this.createNameForChangeList(commitMessage, 0).replace('\n', ' ');
            LocalChangeList changeList = ((ChangeListManagerEx)this.myChangeListManager).addChangeList(changeListName, commitMessage, (Object)commit);
            this.myChangeListManager.moveChangesTo(changeList, changes.toArray(new Change[changes.size()]));
            this.myChangeListManager.setDefaultChangeList(changeList);
            LocalChangeList localChangeList = changeList;
            if (localChangeList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createChangeList"));
            }
            return localChangeList;
        }
        LocalChangeList localChangeList = this.myChangeListManager.getDefaultChangeList();
        if (localChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createChangeList"));
        }
        return localChangeList;
    }

    @NotNull
    private String createNameForChangeList(@NotNull String proposedName, int step) {
        if (proposedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proposedName", "git4idea/cherrypick/GitCherryPicker", "createNameForChangeList"));
        }
        for (LocalChangeList list : this.myChangeListManager.getChangeLists()) {
            if (!list.getName().equals(GitCherryPicker.nameWithStep(proposedName, step))) continue;
            String string = this.createNameForChangeList(proposedName, step + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createNameForChangeList"));
            }
            return string;
        }
        String string = GitCherryPicker.nameWithStep(proposedName, step);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createNameForChangeList"));
        }
        return string;
    }

    private static String nameWithStep(String name, int step) {
        return step == 0 ? name : name + "-" + step;
    }

    private static class GitCommitWrapper {
        @NotNull
        private final VcsFullCommitDetails myOriginalCommit;
        @NotNull
        private String myActualSubject;

        private GitCommitWrapper(@NotNull VcsFullCommitDetails commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker$GitCommitWrapper", "<init>"));
            }
            this.myOriginalCommit = commit;
            this.myActualSubject = commit.getSubject();
        }

        @NotNull
        public String getSubject() {
            String string = this.myActualSubject;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker$GitCommitWrapper", "getSubject"));
            }
            return string;
        }

        public void setActualSubject(@NotNull String actualSubject) {
            if (actualSubject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualSubject", "git4idea/cherrypick/GitCherryPicker$GitCommitWrapper", "setActualSubject"));
            }
            this.myActualSubject = actualSubject;
        }

        @NotNull
        public VcsFullCommitDetails getCommit() {
            VcsFullCommitDetails vcsFullCommitDetails = this.myOriginalCommit;
            if (vcsFullCommitDetails == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker$GitCommitWrapper", "getCommit"));
            }
            return vcsFullCommitDetails;
        }

        public String getOriginalSubject() {
            return this.myOriginalCommit.getSubject();
        }
    }

    private static class CherryPickMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private String myCommitHash;
        private String myCommitAuthor;
        private String myCommitMessage;

        public CherryPickMergeDialogCustomizer(String commitHash, String commitAuthor, String commitMessage) {
            this.myCommitHash = commitHash;
            this.myCommitAuthor = commitAuthor;
            this.myCommitMessage = commitMessage;
        }

        public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
            return "<html>Conflicts during cherry-picking commit <code>" + this.myCommitHash + "</code> made by " + this.myCommitAuthor + "<br/>" + "<code>\"" + this.myCommitMessage + "\"</code></html>";
        }

        public String getLeftPanelTitle(VirtualFile file) {
            return "Local changes";
        }

        public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber lastRevisionNumber) {
            return "<html>Changes from cherry-pick <code>" + this.myCommitHash + "</code>";
        }
    }

    private static class ResolveLinkListener
    implements NotificationListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Git myGit;
        @NotNull
        private final GitPlatformFacade myFacade;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myHash;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final String myMessage;

        public ResolveLinkListener(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (commitHash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (commitAuthor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitAuthor", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            if (commitMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "<init>"));
            }
            this.myProject = project;
            this.myGit = git;
            this.myFacade = facade;
            this.myRoot = root;
            this.myHash = commitHash;
            this.myAuthor = commitAuthor;
            this.myMessage = commitMessage;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/cherrypick/GitCherryPicker$ResolveLinkListener", "hyperlinkUpdate"));
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                new CherryPickConflictResolver(this.myProject, this.myGit, this.myFacade, this.myRoot, this.myHash, this.myAuthor, this.myMessage).mergeNoProceed();
            }
        }
    }

    private static class CherryPickConflictResolver
    extends GitConflictResolver {
        public CherryPickConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitPlatformFacade facade, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (git == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (commitHash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (commitAuthor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitAuthor", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            if (commitMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "git4idea/cherrypick/GitCherryPicker$CherryPickConflictResolver", "<init>"));
            }
            super(project, git, facade, Collections.singleton(root), CherryPickConflictResolver.makeParams(commitHash, commitAuthor, commitMessage));
        }

        private static GitConflictResolver.Params makeParams(String commitHash, String commitAuthor, String commitMessage) {
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Cherry-picked with conflicts");
            params.setMergeDialogCustomizer(new CherryPickMergeDialogCustomizer(commitHash, commitAuthor, commitMessage));
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }
    }

    private static class CherryPickData {
        private final LocalChangeList myChangeList;
        private final String myCommitMessage;
        private final LocalChangeList myPreviouslyDefaultChangeList;

        private CherryPickData(LocalChangeList list, String message, LocalChangeList previouslyDefaultChangeList) {
            this.myChangeList = list;
            this.myCommitMessage = message;
            this.myPreviouslyDefaultChangeList = previouslyDefaultChangeList;
        }
    }
}

