/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.reset.GitResetMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Git.Settings", storages={@Storage(file="$WORKSPACE_FILE$")})
public class GitVcsSettings
implements PersistentStateComponent<State>,
DvcsSyncSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final GitVcsApplicationSettings myAppSettings;
    private State myState = new State();

    public GitVcsSettings(GitVcsApplicationSettings appSettings) {
        this.myAppSettings = appSettings;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return this.myAppSettings;
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)PeriodicalTasksCloser.getInstance().safeGetService(project, GitVcsSettings.class);
    }

    public UpdateMethod getUpdateType() {
        return this.myState.UPDATE_TYPE;
    }

    public void setUpdateType(UpdateMethod updateType) {
        this.myState.UPDATE_TYPE = updateType;
    }

    @NotNull
    public UpdateChangesPolicy updateChangesPolicy() {
        UpdateChangesPolicy updateChangesPolicy = this.myState.UPDATE_CHANGES_POLICY;
        if (updateChangesPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "updateChangesPolicy"));
        }
        return updateChangesPolicy;
    }

    public void setUpdateChangesPolicy(UpdateChangesPolicy value) {
        this.myState.UPDATE_CHANGES_POLICY = value;
    }

    public void saveCommitAuthor(String author) {
        this.myState.PREVIOUS_COMMIT_AUTHORS.remove(author);
        while (this.myState.PREVIOUS_COMMIT_AUTHORS.size() >= 16) {
            this.myState.PREVIOUS_COMMIT_AUTHORS.remove(this.myState.PREVIOUS_COMMIT_AUTHORS.size() - 1);
        }
        this.myState.PREVIOUS_COMMIT_AUTHORS.add(0, author);
    }

    public String[] getCommitAuthors() {
        return ArrayUtil.toStringArray(this.myState.PREVIOUS_COMMIT_AUTHORS);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean autoUpdateIfPushRejected() {
        return this.myState.PUSH_AUTO_UPDATE;
    }

    public void setAutoUpdateIfPushRejected(boolean autoUpdate) {
        this.myState.PUSH_AUTO_UPDATE = autoUpdate;
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = this.myState.ROOT_SYNC;
        if (value == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getSyncSetting"));
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value syncSetting) {
        if (syncSetting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncSetting", "git4idea/config/GitVcsSettings", "setSyncSetting"));
        }
        this.myState.ROOT_SYNC = syncSetting;
    }

    @Nullable
    public String getRecentRootPath() {
        return this.myState.RECENT_GIT_ROOT_PATH;
    }

    public void setRecentRoot(@NotNull String recentGitRootPath) {
        if (recentGitRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentGitRootPath", "git4idea/config/GitVcsSettings", "setRecentRoot"));
        }
        this.myState.RECENT_GIT_ROOT_PATH = recentGitRootPath;
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        Map<String, String> map = this.myState.RECENT_BRANCH_BY_REPOSITORY;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsSettings", "getRecentBranchesByRepository"));
        }
        return map;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        if (repositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryPath", "git4idea/config/GitVcsSettings", "setRecentBranchOfRepository"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/config/GitVcsSettings", "setRecentBranchOfRepository"));
        }
        this.myState.RECENT_BRANCH_BY_REPOSITORY.put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return this.myState.RECENT_COMMON_BRANCH;
    }

    public void setRecentCommonBranch(@NotNull String branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/config/GitVcsSettings", "setRecentCommonBranch"));
        }
        this.myState.RECENT_COMMON_BRANCH = branch;
    }

    public void setAutoCommitOnCherryPick(boolean autoCommit) {
        this.myState.AUTO_COMMIT_ON_CHERRY_PICK = autoCommit;
    }

    public boolean isAutoCommitOnCherryPick() {
        return this.myState.AUTO_COMMIT_ON_CHERRY_PICK;
    }

    public boolean warnAboutCrlf() {
        return this.myState.WARN_ABOUT_CRLF;
    }

    public void setWarnAboutCrlf(boolean warn) {
        this.myState.WARN_ABOUT_CRLF = warn;
    }

    public boolean warnAboutDetachedHead() {
        return this.myState.WARN_ABOUT_DETACHED_HEAD;
    }

    public void setWarnAboutDetachedHead(boolean warn) {
        this.myState.WARN_ABOUT_DETACHED_HEAD = warn;
    }

    @Nullable
    public GitResetMode getResetMode() {
        return this.myState.RESET_MODE;
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "git4idea/config/GitVcsSettings", "setResetMode"));
        }
        this.myState.RESET_MODE = mode;
    }

    public boolean isForcePushAllowed() {
        return this.myState.FORCE_PUSH_ALLOWED;
    }

    public void setForcePushAllowed(boolean allowed) {
        this.myState.FORCE_PUSH_ALLOWED = allowed;
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return this.myState.PUSH_TAGS;
    }

    public void setPushTagMode(@Nullable GitPushTagMode mode) {
        this.myState.PUSH_TAGS = mode;
    }

    @Deprecated
    public boolean isIdeaSsh() {
        if (this.getAppSettings().getIdeaSsh() == null) {
            this.getAppSettings().setIdeaSsh(this.myState.SSH_EXECUTABLE);
        }
        return this.getAppSettings().getIdeaSsh() == GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
    }

    public static class State {
        public List<String> PREVIOUS_COMMIT_AUTHORS = new ArrayList<String>();
        public GitVcsApplicationSettings.SshExecutable SSH_EXECUTABLE = GitVcsApplicationSettings.SshExecutable.IDEA_SSH;
        public UpdateChangesPolicy UPDATE_CHANGES_POLICY = UpdateChangesPolicy.STASH;
        public UpdateMethod UPDATE_TYPE = UpdateMethod.BRANCH_DEFAULT;
        public boolean PUSH_AUTO_UPDATE = false;
        public DvcsSyncSettings.Value ROOT_SYNC = DvcsSyncSettings.Value.NOT_DECIDED;
        public String RECENT_GIT_ROOT_PATH = null;
        public Map<String, String> RECENT_BRANCH_BY_REPOSITORY = new HashMap<String, String>();
        public String RECENT_COMMON_BRANCH = null;
        public boolean AUTO_COMMIT_ON_CHERRY_PICK = false;
        public boolean WARN_ABOUT_CRLF = true;
        public boolean WARN_ABOUT_DETACHED_HEAD = true;
        public GitResetMode RESET_MODE = null;
        public boolean FORCE_PUSH_ALLOWED = false;
        public GitPushTagMode PUSH_TAGS = null;
    }

    public static enum UpdateChangesPolicy {
        STASH,
        SHELVE;

    }
}

