/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import java.util.Collection;
import java.util.TreeSet;

public class CachedRefs
implements SymbolicRefsI {
    private GitBranchesCollection myCollection;
    private GitBranch myCurrentBranch;
    private String myTrackedRemoteName;
    private String myUsername;
    private AbstractHash myHeadHash;
    private TreeSet<String> myLocalBranches;
    private TreeSet<String> myRemoteBranches;
    private final MultiMap<String, Pair<SymbolicRefs.Kind, String>> myRefsMap = new MultiMap();

    public void setCurrentBranch(GitBranch currentBranch) {
        this.myCurrentBranch = currentBranch;
    }

    public void setCollection(GitBranchesCollection collection) {
        this.myCollection = collection;
    }

    public void setTrackedRemoteName(String trackedRemoteName) {
        this.myTrackedRemoteName = trackedRemoteName;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public void setHeadHash(AbstractHash headHash) {
        this.myHeadHash = headHash;
    }

    public TreeSet<String> getLocalBranches() {
        if (this.myLocalBranches == null) {
            Collection<GitLocalBranch> branches = this.myCollection.getLocalBranches();
            this.myLocalBranches = new TreeSet();
            for (GitLocalBranch branch : branches) {
                this.myLocalBranches.add(branch.getName());
            }
        }
        return this.myLocalBranches;
    }

    public TreeSet<String> getRemoteBranches() {
        if (this.myRemoteBranches == null) {
            Collection<GitRemoteBranch> branches = this.myCollection.getRemoteBranches();
            this.myRemoteBranches = new TreeSet();
            for (GitRemoteBranch branch : branches) {
                this.myRemoteBranches.add(branch.getName());
            }
        }
        return this.myRemoteBranches;
    }

    @Override
    public String getCurrentName() {
        return this.myCurrentBranch == null ? null : this.myCurrentBranch.getName();
    }

    @Override
    public GitBranch getCurrent() {
        return this.myCurrentBranch;
    }

    @Override
    public SymbolicRefs.Kind getKind(String s) {
        if (this.getLocalBranches().contains(s)) {
            return SymbolicRefs.Kind.LOCAL;
        }
        if (this.getRemoteBranches().contains(s)) {
            return SymbolicRefs.Kind.REMOTE;
        }
        return SymbolicRefs.Kind.TAG;
    }

    @Override
    public String getTrackedRemoteName() {
        return this.myTrackedRemoteName;
    }

    @Override
    public String getUsername() {
        return this.myUsername;
    }

    @Override
    public AbstractHash getHeadHash() {
        return this.myHeadHash;
    }

    public Collection<? extends GitBranch> getLocal() {
        return this.myCollection.getLocalBranches();
    }

    public Collection<? extends GitBranch> getRemote() {
        return this.myCollection.getRemoteBranches();
    }
}

