/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.GitVcs;
import git4idea.history.wholeTree.GitLog;
import git4idea.history.wholeTree.LogFactoryService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class GitProjectLogManager {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.browser.GitProjectLogManager");
    public static final String CONTENT_KEY = "Log";
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final LogFactoryService myLogFactoryService;
    private final AtomicReference<Content> myCurrentContent;
    private final AtomicReference<GitLog> myLogRef;
    private VcsListener myListener;
    public static final Topic<CurrentBranchListener> CHECK_CURRENT_BRANCH = new Topic("CHECK_CURRENT_BRANCH", CurrentBranchListener.class);
    private CurrentBranchListener myCurrentBranchListener;
    private MessageBusConnection myConnection;

    public GitProjectLogManager(Project project, ProjectLevelVcsManager vcsManager, LogFactoryService logFactoryService) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myLogFactoryService = logFactoryService;
        this.myCurrentContent = new AtomicReference();
        this.myLogRef = new AtomicReference();
        this.myListener = new VcsListener(){

            public void directoryMappingChanged() {
                GitProjectLogManager.this.invokeLaterRecalculateWindows();
            }
        };
        this.myCurrentBranchListener = new CurrentBranchListener(){

            public void consume(VirtualFile file) {
            }
        };
    }

    public static GitProjectLogManager getInstance(Project project) {
        return (GitProjectLogManager)PeriodicalTasksCloser.getInstance().safeGetService(project, GitProjectLogManager.class);
    }

    public void deactivate() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myVcsManager.removeVcsListener(this.myListener);
        if (this.myCurrentContent.get() != null) {
            ChangesViewContentI cvcm = ChangesViewContentManager.getInstance((Project)this.myProject);
            cvcm.removeContent(this.myCurrentContent.get());
            this.myCurrentContent.set(null);
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    public void activate() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.myVcsManager.addVcsListener(this.myListener);
        this.invokeLaterRecalculateWindows();
        this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        this.myConnection.subscribe(CHECK_CURRENT_BRANCH, (Object)this.myCurrentBranchListener);
    }

    private void invokeLaterRecalculateWindows() {
        new AbstractCalledLater(this.myProject, ModalityState.NON_MODAL){

            public void run() {
                GitProjectLogManager.this.recalculateWindows();
            }
        }.callMe();
    }

    private void recalculateWindows() {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        VirtualFile[] roots = this.myVcsManager.getRootsUnderVcs((AbstractVcs)vcs);
        List<VirtualFile> fileList = Arrays.asList(roots);
        ChangesViewContentI cvcm = ChangesViewContentManager.getInstance((Project)this.myProject);
        Content currContent = this.myCurrentContent.get();
        if (currContent != null) {
            this.myLogRef.get().rootsChanged(fileList);
            return;
        }
        GitLog gitLog = this.myLogFactoryService.createComponent(true);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(gitLog.getVisualComponent(), CONTENT_KEY, false);
        content.setCloseable(false);
        cvcm.addContent(content);
        Disposer.register((Disposable)content, (Disposable)gitLog);
        this.myLogRef.set(gitLog);
        this.myCurrentContent.set(content);
        gitLog.rootsChanged(fileList);
    }

    public GitLog getLog() {
        return this.myLogRef.get();
    }

    public static interface CurrentBranchListener
    extends Consumer<VirtualFile> {
    }
}

