/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class BasePopupAction
extends DumbAwareAction
implements CustomComponentAction {
    public static final Color DARKER = UIUtil.getInactiveTextColor().darker().darker();
    protected final JLabel myLabel;
    protected final JPanel myPanel;
    protected final Project myProject;
    protected DefaultActionGroup myAsTextAction;
    private boolean myGreyed;

    public BasePopupAction(Project project, String labeltext, String asTextLabel) {
        this.myProject = project;
        this.myPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.myPanel, 0);
        this.myPanel.setLayout(layout);
        this.myLabel = new JLabel();
        final JLabel show = new JLabel(labeltext);
        show.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        show.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.myLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : DARKER);
        this.myPanel.add(show);
        this.myPanel.add(this.myLabel);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 3));
        JLabel iconLabel = new JLabel(AllIcons.Ide.Statusbar_arrows);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this.myPanel.add((Component)iconLabel, (Object)this.myLabel);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/history/wholeTree/BasePopupAction$1", "onClick"));
                }
                BasePopupAction.this.doAction(e);
                return true;
            }
        }.installOn((Component)this.myPanel);
        if (!UIUtil.isUnderDarcula()) {
            this.myPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    show.setForeground(UIUtil.getTextAreaForeground());
                    BasePopupAction.this.myLabel.setForeground(UIUtil.getTextFieldForeground());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    show.setForeground(UIUtil.getInactiveTextColor());
                    BasePopupAction.this.setLabelFg();
                }
            });
        }
        this.myAsTextAction = new DefaultActionGroup(asTextLabel, true);
    }

    protected void doAction(MouseEvent e) {
        DefaultActionGroup group = this.createActionGroup();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myPanel.getParent());
        DataContext dataContext = SimpleDataContext.getSimpleContext((String)CommonDataKeys.PROJECT.getName(), (Object)this.myProject, (DataContext)parent);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, new Runnable(){

            @Override
            public void run() {
            }
        }, 20);
        if (e != null) {
            popup.show(new RelativePoint(e));
        } else {
            Dimension dimension = popup.getContent().getPreferredSize();
            Point at = new Point(-dimension.width / 2, -dimension.height);
            popup.show(new RelativePoint((Component)this.myLabel, at));
        }
    }

    protected DefaultActionGroup createActionGroup() {
        final DefaultActionGroup group = new DefaultActionGroup();
        this.createActions(new Consumer<AnAction>(){

            public void consume(AnAction anAction) {
                group.add(anAction);
            }
        });
        return group;
    }

    protected abstract void createActions(Consumer<AnAction> var1);

    public void actionPerformed(AnActionEvent e) {
    }

    public JComponent createCustomComponent(Presentation presentation) {
        return this.myPanel;
    }

    public AnAction asTextAction() {
        this.myAsTextAction.removeAll();
        this.createActions(new Consumer<AnAction>(){

            public void consume(AnAction anAction) {
                BasePopupAction.this.myAsTextAction.add(anAction);
            }
        });
        return this.myAsTextAction;
    }

    public void greyPanelFg(boolean value) {
        this.myGreyed = value;
        this.setLabelFg();
    }

    private void setLabelFg() {
        this.myLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : (this.myGreyed ? UIUtil.getInactiveTextColor() : DARKER));
    }
}

