/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CommitIdsHolder<Item> {
    private final MyLruCache<Item, Item> myRequests = new MyLruCache(50, 30);
    private final Object myLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<Item> s) {
        Object object = this.myLock;
        synchronized (object) {
            for (Item hash : s) {
                this.myRequests.put(hash, hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveData() {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Item> get(int size) {
        HashSet<Item> result = new HashSet<Item>();
        Object object = this.myLock;
        synchronized (object) {
            Iterator<Item> iterator = this.myRequests.iterator();
            for (int cnt = 0; iterator.hasNext() && cnt < size; ++cnt) {
                Item hash = iterator.next();
                iterator.remove();
                result.add(hash);
            }
        }
        return result;
    }

    private static class MyLruCache<Key, Val>
    extends SLRUMap<Key, Val> {
        private MyLruCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        public boolean isEmpty() {
            return this.myProtectedQueue.keySet().isEmpty() && this.myProbationalQueue.keySet().isEmpty();
        }

        public Iterator<Key> iterator() {
            ArrayList iterators = new ArrayList(2);
            iterators.add(this.myProbationalQueue.keySet().iterator());
            iterators.add(this.myProtectedQueue.keySet().iterator());
            return ContainerUtil.concatIterators(iterators);
        }
    }
}

