/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import git4idea.history.wholeTree.GitLogSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ContainedInBranchesConfigDialog
extends DialogWrapper {
    private JPanel myPanel;
    private CheckBoxList<String> myLocalBranches;
    private CheckBoxList<String> myRemoteBranches;
    private final Project myProject;
    private boolean myChanged;
    private JRadioButton myHighlight;

    public ContainedInBranchesConfigDialog(Project project, Collection<String> localBranches, Collection<String> remoteBranches, String currentLocal, String currentRemote) {
        super(project, true);
        this.myProject = project;
        this.setTitle("Configure Branches Presentation");
        this.initUi(project, localBranches, remoteBranches, currentLocal, currentRemote);
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "git4idea.history.wholeTree.ContainedInBranchesConfigDialog";
    }

    private void initUi(Project project, Collection<String> localBranches, Collection<String> remoteBranches, String currentLocal, String currentRemote) {
        this.myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
        this.myLocalBranches = new MyCheckBoxList(currentLocal);
        this.myRemoteBranches = new MyCheckBoxList(currentRemote);
        gb.gridwidth = 2;
        JLabel label = new JLabel("Select branches for \"Contained in branches\" field:");
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.myPanel.add((Component)label, gb);
        ButtonGroup bg = new ButtonGroup();
        this.myHighlight = new JRadioButton("Highlight them");
        JRadioButton filter = new JRadioButton("Filter others out");
        bg.add(this.myHighlight);
        bg.add(filter);
        gb.gridwidth = 1;
        gb.gridx = 0;
        ++gb.gridy;
        this.myPanel.add((Component)this.myHighlight, gb);
        ++gb.gridy;
        this.myPanel.add((Component)filter, gb);
        gb.insets.top = 10;
        gb.gridwidth = 1;
        ++gb.gridy;
        this.myPanel.add((Component)new JLabel("Local branches"), gb);
        ++gb.gridx;
        this.myPanel.add((Component)new JLabel("Remote branches"), gb);
        gb.insets.top = 0;
        ++gb.gridy;
        gb.gridx = 0;
        gb.fill = 1;
        gb.weightx = 0.5;
        gb.weighty = 1.0;
        this.myLocalBranches.setBorder(null);
        this.myRemoteBranches.setBorder(null);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myLocalBranches), gb);
        ++gb.gridx;
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myRemoteBranches), gb);
        GitLogSettings gitLogSettings = GitLogSettings.getInstance(project);
        ContainedInBranchesConfigDialog.setItems(localBranches, gitLogSettings.getLocalBranchesCopy(), this.myLocalBranches);
        ContainedInBranchesConfigDialog.setItems(remoteBranches, gitLogSettings.getRemoteBranchesCopy(), this.myRemoteBranches);
        this.myHighlight.setSelected(gitLogSettings.isHighlight());
        filter.setSelected(!gitLogSettings.isHighlight());
        new ListSpeedSearch(this.myLocalBranches);
        new ListSpeedSearch(this.myRemoteBranches);
        this.focus(this.myLocalBranches);
        this.focus(this.myRemoteBranches);
    }

    private void focus(final CheckBoxList list) {
        list.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (list.getItemsCount() > 0 && list.getSelectedIndex() == -1) {
                    list.setSelectedIndex(0);
                    list.removeFocusListener((FocusListener)this);
                }
            }
        });
    }

    public boolean isChanged() {
        return this.myChanged;
    }

    private static void setItems(Collection<String> localBranches, Set<String> localBranchesCopy, CheckBoxList<String> list) {
        TreeMap<String, Boolean> localBranchesState = new TreeMap<String, Boolean>();
        for (String localBranch : localBranches) {
            localBranchesState.put(localBranch, localBranchesCopy.contains(localBranch));
        }
        list.setStringItems(localBranchesState);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLocalBranches;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        GitLogSettings gitLogSettings = GitLogSettings.getInstance(this.myProject);
        ArrayList<String> local = ContainedInBranchesConfigDialog.gatherSelected((DefaultListModel)this.myLocalBranches.getModel());
        ArrayList<String> remote = ContainedInBranchesConfigDialog.gatherSelected((DefaultListModel)this.myRemoteBranches.getModel());
        boolean highlightChanged = gitLogSettings.isHighlight() != this.myHighlight.isSelected();
        gitLogSettings.setHighlight(this.myHighlight.isSelected());
        if (gitLogSettings.setIfChanged(local, remote) || highlightChanged) {
            this.myChanged = true;
        }
        super.doOKAction();
    }

    public static ArrayList<String> gatherSelected(DefaultListModel localModel) {
        ArrayList<String> selected = new ArrayList<String>();
        Enumeration elements = localModel.elements();
        while (elements.hasMoreElements()) {
            JCheckBox cb = (JCheckBox)elements.nextElement();
            if (!cb.isSelected()) continue;
            selected.add(cb.getText());
        }
        return selected;
    }

    private static class MyCheckBoxList
    extends CheckBoxList<String> {
        private final String myBold;
        private static final Border FOCUSED_BORDER = UIManager.getBorder("List.focusCellHighlightBorder");
        private final EmptyBorder myEmptyBorder;

        private MyCheckBoxList(String bold) {
            this.myBold = bold;
            Insets borderInsets = FOCUSED_BORDER.getBorderInsets(new JCheckBox());
            this.myEmptyBorder = new EmptyBorder(borderInsets);
            this.setSelectionMode(2);
        }

        protected void adjustRendering(JCheckBox checkBox, boolean selected, boolean hasFocus) {
            checkBox.setFocusPainted(false);
            if (this.myBold != null && this.myBold.equals(checkBox.getText())) {
                checkBox.setFont(checkBox.getFont().deriveFont(1));
            } else {
                checkBox.setFont(checkBox.getFont().deriveFont(0));
            }
            if (hasFocus) {
                checkBox.setBorder(FOCUSED_BORDER);
            } else {
                checkBox.setBorder(this.myEmptyBorder);
            }
        }
    }
}

