/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import git4idea.GitBranch;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.LowLevelAccessImpl;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.DetailsLoaderImpl;
import git4idea.history.wholeTree.UIRefresh;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsCache {
    private static final int ourSize = 500;
    private final SLRUMap<Pair<VirtualFile, AbstractHash>, GitHeavyCommit> myCache;
    private final SLRUMap<Pair<VirtualFile, AbstractHash>, List<String>> myBranches;
    private final Project myProject;
    private final DetailsLoaderImpl myDetailsLoader;
    private final BackgroundTaskQueue myQueue;
    private UIRefresh myRefresh;
    private final Map<VirtualFile, Map<AbstractHash, String>> myStash;
    private final Object myLock;
    private static final Logger LOG = Logger.getInstance((String)"git4idea.history.wholeTree.DetailsCache");
    private ModalityState myState;

    public DetailsCache(Project project, UIRefresh uiRefresh, DetailsLoaderImpl detailsLoader, BackgroundTaskQueue queue) {
        this.myProject = project;
        this.myDetailsLoader = detailsLoader;
        this.myQueue = queue;
        this.myStash = new HashMap<VirtualFile, Map<AbstractHash, String>>();
        this.myRefresh = uiRefresh;
        this.myLock = new Object();
        this.myCache = new SLRUMap(500, 150);
        this.myBranches = new SLRUMap(20, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitHeavyCommit convert(VirtualFile root, AbstractHash hash) {
        Object object = this.myLock;
        synchronized (object) {
            return (GitHeavyCommit)this.myCache.get((Object)Pair.create((Object)root, (Object)hash));
        }
    }

    public void acceptQuestion(MultiMap<VirtualFile, AbstractHash> hashes) {
        if (hashes.isEmpty()) {
            return;
        }
        this.myDetailsLoader.load(hashes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptAnswer(Collection<GitHeavyCommit> commits, VirtualFile root) {
        Object object = this.myLock;
        synchronized (object) {
            for (GitHeavyCommit commit : commits) {
                this.myCache.put((Object)Pair.create((Object)root, (Object)commit.getShortHash()), (Object)commit);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetailsCache.this.myRefresh.detailsLoaded();
            }
        });
    }

    public void rootsChanged(Collection<VirtualFile> roots) {
        this.myDetailsLoader.setRoots(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBranches(VirtualFile root, AbstractHash hash, List<String> s) {
        Object object = this.myLock;
        synchronized (object) {
            this.myBranches.put((Object)Pair.create((Object)root, (Object)hash), s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getBranches(VirtualFile root, AbstractHash hash) {
        Object object = this.myLock;
        synchronized (object) {
            return (List)this.myBranches.get((Object)Pair.create((Object)root, (Object)hash));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAsideCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myBranches.clear();
            this.myStash.clear();
            HashSet<Pair> forDeletion = new HashSet<Pair>();
            for (Map.Entry entry : this.myCache.entrySet()) {
                GitHeavyCommit value = (GitHeavyCommit)entry.getValue();
                if (value.getLocalBranches().isEmpty() && value.getRemoteBranches().isEmpty() && value.getTags().isEmpty()) continue;
                forDeletion.add(Pair.create((Object)((Pair)entry.getKey()).getFirst(), (Object)((Pair)entry.getKey()).getSecond()));
            }
            for (Pair pair : forDeletion) {
                this.myCache.remove((Object)pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putStash(VirtualFile root, Map<AbstractHash, String> stash) {
        Object object = this.myLock;
        synchronized (object) {
            this.myStash.put(root, stash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getStashName(VirtualFile root, AbstractHash hash) {
        Object object = this.myLock;
        synchronized (object) {
            Map<AbstractHash, String> map = this.myStash.get(root);
            return map == null ? null : map.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBranches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myBranches.clear();
        }
    }

    public void loadAndPutBranches(final VirtualFile root, final AbstractHash abstractHash, final Consumer<List<String>> continuation, final Processor<AbstractHash> recheck) {
        this.myQueue.run(new Task.Backgroundable(this.myProject, "Load contained in branches", true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                List<String> branches;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/wholeTree/DetailsCache$2", "run"));
                }
                if (!recheck.process((Object)abstractHash)) {
                    return;
                }
                if (DetailsCache.this.getBranches(root, abstractHash) != null) {
                    return;
                }
                try {
                    branches = new LowLevelAccessImpl(this.myProject, root).getBranchesWithCommit(abstractHash.getString());
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    branches = Collections.singletonList("Can not load branches due to error: " + e.getMessage());
                }
                DetailsCache.this.putBranches(root, abstractHash, branches);
                final List<String> finalBranches = branches;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        continuation.consume((Object)finalBranches);
                    }
                });
            }
        }, this.myState, null);
    }

    public void setModalityState(ModalityState state) {
        this.myState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportRefs(VirtualFile root, CachedRefs refs) {
        Object object = this.myLock;
        synchronized (object) {
            HashSet<Pair> forDeletion = new HashSet<Pair>();
            HashSet<String> hashes = new HashSet<String>();
            AbstractHash headHash = refs.getHeadHash();
            Collection<? extends GitBranch> local = refs.getLocal();
            for (GitBranch gitBranch : local) {
                hashes.add(gitBranch.getHash());
            }
            Collection<? extends GitBranch> remote = refs.getRemote();
            for (GitBranch gitBranch : remote) {
                hashes.add(gitBranch.getHash());
            }
            for (Map.Entry entry : this.myCache.entrySet()) {
                AbstractHash hash;
                GitHeavyCommit value = (GitHeavyCommit)entry.getValue();
                if (!root.equals(((Pair)entry.getKey()).getFirst()) || !(hash = value.getShortHash()).equals(headHash) && !hashes.contains(value.getHash().getValue())) continue;
                forDeletion.add(Pair.create((Object)((Pair)entry.getKey()).getFirst(), (Object)((Pair)entry.getKey()).getSecond()));
            }
            for (Pair pair : forDeletion) {
                this.myCache.remove((Object)pair);
            }
        }
    }
}

