/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.LowLevelAccess;
import git4idea.history.browser.LowLevelAccessImpl;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitIdsHolder;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.DetailsLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DetailsLoaderImpl
implements DetailsLoader {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.wholeTree.DetailsLoaderImpl");
    private static final int ourLoadSize = 20;
    private final BackgroundTaskQueue myQueue;
    private final Map<VirtualFile, CommitIdsHolder<AbstractHash>> myLoadIdsGatherer;
    private final Map<VirtualFile, LowLevelAccess> myAccesses;
    private DetailsCache myDetailsCache;
    private final Project myProject;
    private final Map<VirtualFile, CachedRefs> myRefs;
    private final Object myLock;
    private ModalityState myState;

    public DetailsLoaderImpl(Project project, BackgroundTaskQueue queue) {
        this.myQueue = queue;
        this.myProject = project;
        this.myLoadIdsGatherer = new HashMap();
        this.myAccesses = new HashMap();
        this.myRefs = new HashMap();
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailsCache(DetailsCache detailsCache) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDetailsCache = detailsCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoots(Collection<VirtualFile> roots) {
        Object object = this.myLock;
        synchronized (object) {
            this.myLoadIdsGatherer.clear();
            this.myAccesses.clear();
            for (VirtualFile root : roots) {
                this.myLoadIdsGatherer.put(root, new CommitIdsHolder());
                this.myAccesses.put(root, new LowLevelAccessImpl(this.myProject, root));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(MultiMap<VirtualFile, AbstractHash> hashes) {
        Object object = this.myLock;
        synchronized (object) {
            for (VirtualFile root : hashes.keySet()) {
                CommitIdsHolder<AbstractHash> holder = this.myLoadIdsGatherer.get(root);
                holder.add(hashes.get((Object)root));
                this.myQueue.run((Task.Backgroundable)new Worker(this.myProject, root, this.myAccesses.get(root), this.myDetailsCache, this.myQueue), this.myState, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportRefs(VirtualFile root, CachedRefs refs) {
        Object object = this.myLock;
        synchronized (object) {
            this.myRefs.put(root, refs);
        }
        this.myDetailsCache.reportRefs(root, refs);
    }

    public void setModalityState(ModalityState state) {
        this.myState = state;
    }

    private class Worker
    extends Task.Backgroundable {
        private final LowLevelAccess myAccess;
        private final DetailsCache myDetailsCache;
        private final BackgroundTaskQueue myQueue;
        private final VirtualFile myVirtualFile;

        private Worker(Project project, VirtualFile virtualFile, LowLevelAccess access, DetailsCache detailsCache, BackgroundTaskQueue queue) {
            super(project, "Load git commits details", false, BackgroundFromStartOption.getInstance());
            this.myVirtualFile = virtualFile;
            this.myAccess = access;
            this.myDetailsCache = detailsCache;
            this.myQueue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            SymbolicRefsI refs;
            CommitIdsHolder holder;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/wholeTree/DetailsLoaderImpl$Worker", "run"));
            }
            Object object = DetailsLoaderImpl.this.myLock;
            synchronized (object) {
                holder = (CommitIdsHolder)DetailsLoaderImpl.this.myLoadIdsGatherer.get(this.myVirtualFile);
                refs = (SymbolicRefsI)DetailsLoaderImpl.this.myRefs.get(this.myAccess.getRoot());
            }
            if (holder == null) {
                return;
            }
            Collection<AbstractHash> hashes = holder.get(20);
            try {
                this.loadDetails(hashes, refs);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                for (AbstractHash hash : hashes) {
                    try {
                        this.loadDetails(Collections.singletonList(hash), refs);
                    }
                    catch (VcsException e1) {
                        LOG.info((Throwable)e1);
                        this.myDetailsCache.acceptAnswer(Collections.singletonList(this.createNotLoadedCommit(hash)), this.myAccess.getRoot());
                    }
                }
            }
            if (holder.haveData()) {
                this.myQueue.run((Task.Backgroundable)this, DetailsLoaderImpl.this.myState, null);
            }
        }

        private void loadDetails(Collection<AbstractHash> hashes, SymbolicRefsI refs) throws VcsException {
            ArrayList<String> converted = new ArrayList<String>();
            for (AbstractHash hash : hashes) {
                if (this.myDetailsCache.convert(this.myVirtualFile, hash) != null) continue;
                converted.add(hash.getString());
            }
            if (!hashes.isEmpty()) {
                List<GitHeavyCommit> result = this.myAccess.getCommitDetails(converted, refs);
                if (result != null && !result.isEmpty()) {
                    this.myDetailsCache.acceptAnswer(result, this.myAccess.getRoot());
                    for (GitHeavyCommit gitCommit : result) {
                        converted.remove(gitCommit.getShortHash().getString());
                    }
                }
                if (!converted.isEmpty()) {
                    ArrayList<GitHeavyCommit> error = new ArrayList<GitHeavyCommit>();
                    for (String s : converted) {
                        error.add(this.createNotLoadedCommit(AbstractHash.create(s)));
                    }
                    this.myDetailsCache.acceptAnswer(error, this.myAccess.getRoot());
                }
            }
        }

        private GitHeavyCommit createNotLoadedCommit(AbstractHash shortHash) {
            String notKnown = "Can not load";
            return new GitHeavyCommit((VirtualFile)NullVirtualFile.INSTANCE, shortHash, SHAHash.emulate(shortHash), "Can not load", "Can not load", new Date(0L), "Can not load", "Can not load details", Collections.<String>emptySet(), Collections.<FilePath>emptyList(), "Can not load", "Can not load", Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<Change>emptyList(), 0L);
        }
    }
}

