/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.diff.impl.CaptionIcon;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.UIVcsUtil;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.ContainedInBranchesConfigDialog;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GitLogSettings;
import git4idea.history.wholeTree.GitLogUI;
import git4idea.history.wholeTree.HighlightingRendererBase;
import icons.Git4ideaIcons;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class GitLogDetailsPanel {
    public static final String CONFIGURE_BRANCHES = "configure_branches";
    private static final String NOTHING_SELECTED = "nothingSelected";
    private static final String LOADING = "loading";
    private static final String DATA = "data";
    private static final String MULTIPLE_SELECTED = "multiple_selected";
    private final JPanel myPanel;
    private JPanel myMarksPanel;
    private final MyPresentationData myPresentationData;
    private final HtmlHighlighter myHtmlHighlighter;
    private JEditorPane myJEditorPane;
    private VirtualFile myRoot;
    private GitHeavyCommit myCommit;
    private final Convertor<VirtualFile, CachedRefs> myRefsProvider;
    private final Processor<AbstractHash> myMarkProcessor;

    public GitLogDetailsPanel(final Project myProject, DetailsCache detailsCache, final Convertor<VirtualFile, CachedRefs> refsProvider, Processor<AbstractHash> markProcessor) {
        this.myRefsProvider = refsProvider;
        this.myMarkProcessor = markProcessor;
        this.myPanel = new JPanel(new CardLayout());
        this.myPanel.add((Component)UIVcsUtil.errorPanel((String)"Nothing selected", (boolean)false), NOTHING_SELECTED);
        this.myPanel.add((Component)UIVcsUtil.errorPanel((String)"Loading...", (boolean)false), LOADING);
        this.myPanel.add((Component)UIVcsUtil.errorPanel((String)"Several commits selected", (boolean)false), MULTIPLE_SELECTED);
        this.myHtmlHighlighter = new HtmlHighlighter();
        this.myPresentationData = new MyPresentationData(myProject, detailsCache, this.myHtmlHighlighter);
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0);
        this.myJEditorPane = new JEditorPane("text/html", "");
        this.myJEditorPane.setPreferredSize(new Dimension(150, 100));
        this.myJEditorPane.setEditable(false);
        this.myJEditorPane.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myJEditorPane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (GitLogDetailsPanel.CONFIGURE_BRANCHES.equals(e.getDescription())) {
                    if (GitLogDetailsPanel.this.myRoot == null) {
                        return;
                    }
                    CachedRefs symbolicRefs = (CachedRefs)refsProvider.convert((Object)GitLogDetailsPanel.this.myRoot);
                    if (symbolicRefs == null) {
                        return;
                    }
                    TreeSet<String> localBranches = symbolicRefs.getLocalBranches();
                    if (localBranches == null || localBranches.isEmpty()) {
                        VcsBalloonProblemNotifier.showOverChangesView((Project)myProject, (String)"Branches is not loaded yet", (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
                        return;
                    }
                    ContainedInBranchesConfigDialog dialog = new ContainedInBranchesConfigDialog(myProject, localBranches, symbolicRefs.getRemoteBranches(), symbolicRefs.getCurrentName(), symbolicRefs.getTrackedRemoteName());
                    dialog.show();
                    if (dialog.isChanged()) {
                        GitLogDetailsPanel.this.myPresentationData.branchesPresentation();
                        GitLogDetailsPanel.this.changeDetailsText();
                    }
                    return;
                }
                super.hyperlinkActivated(e);
            }
        });
        this.myMarksPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.myMarksPanel, 0);
        this.myMarksPanel.setLayout(boxLayout);
        gb.weightx = 1.0;
        wrapper.add((Component)this.myMarksPanel, gb);
        ++gb.gridy;
        gb.weighty = 1.0;
        gb.fill = 1;
        JBScrollPane tableScroll = new JBScrollPane((Component)this.myJEditorPane);
        tableScroll.setBorder(null);
        this.myJEditorPane.setBorder(null);
        wrapper.add((Component)tableScroll, gb);
        this.myJEditorPane.setBackground(UIUtil.getTableBackground());
        this.myMarksPanel.setBackground(UIUtil.getTableBackground());
        wrapper.setBackground(UIUtil.getTableBackground());
        this.myPanel.add((Component)wrapper, DATA);
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, NOTHING_SELECTED);
    }

    public HtmlHighlighter getHtmlHighlighter() {
        return this.myHtmlHighlighter;
    }

    public void severalSelected() {
        this.myPresentationData.clear();
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, MULTIPLE_SELECTED);
    }

    public void nothingSelected() {
        this.myPresentationData.clear();
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, NOTHING_SELECTED);
    }

    public void setBranches(List<String> branchesList) {
        this.myPresentationData.setBranches(branchesList);
        this.changeDetailsText();
    }

    public void loading(VirtualFile root) {
        this.myRoot = root;
        this.myPresentationData.clear();
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, LOADING);
    }

    public void setData(VirtualFile root, @NotNull GitHeavyCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/history/wholeTree/GitLogDetailsPanel", "setData"));
        }
        this.myRoot = root;
        this.myCommit = commit;
        this.redrawBranchLabels();
        this.myPresentationData.setCommit(root, commit);
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, DATA);
        this.changeDetailsText();
    }

    private void changeDetailsText() {
        if (this.myPresentationData.isReady()) {
            this.myJEditorPane.setText(this.myPresentationData.getText());
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }
    }

    void redrawBranchLabels() {
        Font tableFont = this.myJEditorPane.getFont();
        Font font = tableFont.deriveFont((float)(tableFont.getSize() - 1));
        String currentBranch = this.myCommit.getCurrentBranch();
        this.myMarksPanel.removeAll();
        if (this.myMarkProcessor.process((Object)this.myCommit.getShortHash())) {
            this.myMarksPanel.add(new JLabel(Git4ideaIcons.Star));
        }
        for (String s : this.myCommit.getLocalBranches()) {
            this.myMarksPanel.add(new JLabel((Icon)new CaptionIcon(GitLogUI.Colors.local, font, s, (Component)this.myMarksPanel, CaptionIcon.Form.SQUARE, false, s.equals(currentBranch))));
        }
        String remoteName = ((CachedRefs)this.myRefsProvider.convert((Object)this.myRoot)).getTrackedRemoteName();
        for (String s : this.myCommit.getRemoteBranches()) {
            this.myMarksPanel.add(new JLabel((Icon)new CaptionIcon(GitLogUI.Colors.remote, font, s, (Component)this.myMarksPanel, CaptionIcon.Form.SQUARE, false, s.equals(remoteName))));
        }
        for (String s : this.myCommit.getTags()) {
            this.myMarksPanel.add(new JLabel((Icon)new CaptionIcon(GitLogUI.Colors.tag, font, s, (Component)this.myMarksPanel, CaptionIcon.Form.ROUNDED, false, false)));
        }
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    private static class MyPresentationData {
        private String myStartPattern;
        private final String myEndPattern = "</td></tr></table></body></html>";
        private String myBranches;
        private final Project myProject;
        private final DetailsCache myDetailsCache;
        private final HtmlHighlighter myHighlighter;
        private List<String> myBranchesList;

        private MyPresentationData(Project project, DetailsCache detailsCache, HtmlHighlighter highlighter) {
            this.myProject = project;
            this.myDetailsCache = detailsCache;
            this.myHighlighter = highlighter;
        }

        public void setCommit(VirtualFile root, GitHeavyCommit c) {
            String hash = this.myHighlighter.getResult(c.getHash().getValue());
            String author = this.myHighlighter.getResult(c.getAuthor());
            String committer = this.myHighlighter.getResult(c.getCommitter());
            String comment = IssueLinkHtmlRenderer.formatTextWithLinks((Project)this.myProject, (String)c.getDescription(), (Convertor)new Convertor<String, String>(){

                public String convert(String o) {
                    return MyPresentationData.this.myHighlighter.getResult(o);
                }
            });
            StringBuilder sb = new StringBuilder().append("<html><head>").append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())).append("</head><body><table>");
            String stashName = this.myDetailsCache.getStashName(root, c.getShortHash());
            if (!StringUtil.isEmptyOrSpaces((String)stashName)) {
                sb.append("<tr valign=\"top\"><td><b>").append(stashName).append("</b></td><td></td></tr>");
            }
            sb.append("<tr valign=\"top\"><td><i>Hash:</i></td><td>").append(hash).append("</td></tr><tr valign=\"top\"><td><i>Author:</i></td><td>").append(author).append(" (").append(c.getAuthorEmail()).append(") <i>at</i> ").append(DateFormatUtil.formatPrettyDateTime((long)c.getAuthorTime())).append("</td></tr><tr valign=\"top\"><td><i>Committer:</i></td><td>").append(committer).append(" (").append(c.getComitterEmail()).append(") <i>at</i> ").append(DateFormatUtil.formatPrettyDateTime((Date)c.getDate())).append("</td></tr><tr valign=\"top\"><td><i>Description:</i></td><td><b>").append(comment).append("</b></td></tr>");
            sb.append("<tr valign=\"top\"><td><i>Contained in branches:</i><br/><a href=\"configure_branches\">Configure</a></td><td>");
            this.myStartPattern = sb.toString();
        }

        public void setBranches(List<String> branches) {
            this.myBranchesList = branches;
            this.branchesPresentation();
        }

        public void branchesPresentation() {
            GitLogSettings settings = GitLogSettings.getInstance(this.myProject);
            Set<String> locals = settings.getLocalBranchesCopy();
            Set<String> remotes = settings.getRemoteBranchesCopy();
            StringBuilder sb = new StringBuilder();
            if (this.myBranchesList != null && !this.myBranchesList.isEmpty()) {
                for (int i = 0; i < this.myBranchesList.size(); ++i) {
                    boolean contained;
                    String s = this.myBranchesList.get(i);
                    boolean bl = contained = locals.contains(s) || remotes.contains(s);
                    if ((contained || settings.isHighlight()) && sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (contained) {
                        if (settings.isHighlight()) {
                            sb.append("<b>").append(s).append("</b>");
                            continue;
                        }
                        sb.append(s);
                        continue;
                    }
                    if (!settings.isHighlight()) continue;
                    sb.append(s);
                }
                this.myBranches = sb.toString();
            } else {
                this.myBranches = this.myBranchesList != null && this.myBranchesList.isEmpty() ? "<font color=gray>&lt;no branches&gt;</font><br/>" : "<font color=gray>Loading...</font><br/>";
            }
        }

        protected String getBranches() {
            return this.myBranches == null ? "<font color=gray>Loading...</font>" : this.myBranches;
        }

        public boolean isReady() {
            return this.myStartPattern != null;
        }

        public String getText() {
            return this.myStartPattern + this.getBranches() + "</td></tr></table></body></html>";
        }

        public void clear() {
            this.myBranches = null;
        }
    }

    private static class HtmlHighlighter
    extends HighlightingRendererBase {
        private final StringBuilder mySb = new StringBuilder();

        private HtmlHighlighter() {
        }

        @Override
        protected void highlight(String s) {
            this.mySb.append("<font color=rgb(255,128,0)>").append(s).append("</font>");
        }

        @Override
        protected void usual(String s) {
            this.mySb.append(s);
        }

        public String getResult(String text) {
            this.mySb.setLength(0);
            this.tryHighlight(text);
            return this.mySb.toString();
        }
    }
}

