/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.google.common.collect.Sets;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.history.browser.ChangesFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GitLogFilters {
    @Nullable
    private final ChangesFilter.Comment myCommentFilter;
    @Nullable
    private final Set<ChangesFilter.Filter> myCommitterFilters;
    @Nullable
    private final Set<ChangesFilter.Filter> myDateFilters;
    @Nullable
    private final Map<VirtualFile, ChangesFilter.Filter> myStructureFilters;
    @Nullable
    private final List<String> myPossibleReferencies;
    private boolean myUseOnlyHashes;

    public GitLogFilters() {
        this(null, null, null, null, null);
    }

    public GitLogFilters(@Nullable ChangesFilter.Comment commentFilter, @Nullable Set<ChangesFilter.Filter> committerFilters, Set<ChangesFilter.Filter> filters, @Nullable Map<VirtualFile, ChangesFilter.Filter> structureFilters, @Nullable List<String> possibleReferencies) {
        this.myCommentFilter = commentFilter;
        this.myCommitterFilters = committerFilters;
        this.myDateFilters = filters;
        this.myStructureFilters = structureFilters;
        this.myPossibleReferencies = possibleReferencies;
    }

    public void callConsumer(Consumer<List<ChangesFilter.Filter>> consumer, boolean takeComment, VirtualFile root) {
        Set cartesian;
        ChangesFilter.Filter filter;
        ArrayList<Set<ChangesFilter.Filter>> filters = new ArrayList<Set<ChangesFilter.Filter>>();
        if (takeComment && this.myCommentFilter != null) {
            filters.add(Collections.singletonMap(this.myCommentFilter, this.myCommentFilter).keySet());
        }
        if (this.myCommitterFilters != null) {
            filters.add(this.myCommitterFilters);
        }
        if (this.myStructureFilters != null && (filter = this.myStructureFilters.get(root)) != null) {
            filters.add(Collections.singleton(filter));
        }
        if (this.myDateFilters != null) {
            filters.add(Collections.singleton(new ChangesFilter.And(this.myDateFilters.toArray(new ChangesFilter.Filter[this.myDateFilters.size()]))));
        }
        if ((cartesian = Sets.cartesianProduct(filters)).isEmpty()) {
            consumer.consume(Collections.emptyList());
        } else {
            for (List list : cartesian) {
                consumer.consume((Object)list);
            }
        }
    }

    @Nullable
    public ChangesFilter.Comment getCommentFilter() {
        return this.myCommentFilter;
    }

    @Nullable
    public Set<ChangesFilter.Filter> getCommitterFilters() {
        return this.myCommitterFilters;
    }

    public boolean haveCommitterOrCommentFilters() {
        return this.myCommitterFilters != null && !this.myCommitterFilters.isEmpty() || this.myCommentFilter != null;
    }

    @Nullable
    public Map<VirtualFile, ChangesFilter.Filter> getStructureFilters() {
        return this.myStructureFilters;
    }

    public boolean isEmpty() {
        return !(this.myCommentFilter != null || this.myCommitterFilters != null && !this.myCommitterFilters.isEmpty() || this.myStructureFilters != null && !this.myStructureFilters.isEmpty() || this.myDateFilters != null && !this.myDateFilters.isEmpty());
    }

    public boolean haveDisordering() {
        return !this.isEmpty();
    }

    @Nullable
    public List<String> getPossibleReferencies() {
        return this.myPossibleReferencies;
    }

    public boolean haveStructureFilter() {
        return this.myStructureFilters != null;
    }

    public boolean haveStructuresForRoot(VirtualFile root) {
        return this.haveStructureFilter() && this.myStructureFilters.containsKey(root);
    }

    public boolean isUseOnlyHashes() {
        return this.myUseOnlyHashes;
    }

    public void setUseOnlyHashes(boolean useOnlyHashes) {
        this.myUseOnlyHashes = useOnlyHashes;
    }
}

