/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.CaptionIcon;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.CheckSamePattern;
import com.intellij.openapi.vcs.ComparableComparator;
import com.intellij.openapi.vcs.Details;
import com.intellij.openapi.vcs.GenericDetailsLoader;
import com.intellij.openapi.vcs.RequestsMerger;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vcs.ui.SearchFieldAction;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.OnOff;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AdjustComponentWhenShown;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.MoreAction;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.changes.GitChangeUtils;
import git4idea.history.browser.CachedRefs;
import git4idea.history.browser.ChangesFilter;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.BranchSelectorAction;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.ContainedInBranchesConfigDialog;
import git4idea.history.wholeTree.DatesFilterAction;
import git4idea.history.wholeTree.DatesFilterI;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GitCommitDetailsProvider;
import git4idea.history.wholeTree.GitCreateNewTag;
import git4idea.history.wholeTree.GitLogDetailsPanel;
import git4idea.history.wholeTree.GitLogFilters;
import git4idea.history.wholeTree.GitLogSettings;
import git4idea.history.wholeTree.GitLogShowOnlyStarredCommitsAction;
import git4idea.history.wholeTree.GitTableScrollChangeListener;
import git4idea.history.wholeTree.GraphGutter;
import git4idea.history.wholeTree.HighlightingRendererBase;
import git4idea.history.wholeTree.Mediator;
import git4idea.history.wholeTree.RootsHolder;
import git4idea.history.wholeTree.SelectorList;
import git4idea.history.wholeTree.StepType;
import git4idea.history.wholeTree.StructureFilterAction;
import git4idea.history.wholeTree.StructureFilterI;
import git4idea.history.wholeTree.UIRefresh;
import git4idea.history.wholeTree.UserFilterI;
import git4idea.history.wholeTree.UsersFilterAction;
import git4idea.repo.GitRepository;
import icons.Git4ideaIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogUI
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.wholeTree.GitLogUI");
    public static final SimpleTextAttributes HIGHLIGHT_TEXT_ATTRIBUTES = new SimpleTextAttributes(64, UIUtil.getTableForeground());
    public static final String GIT_LOG_TABLE_PLACE = "git log table";
    private final Project myProject;
    private final GitVcs myVcs;
    private BigTableTableModel myTableModel;
    private DetailsCache myDetailsCache;
    private final Mediator myMediator;
    private Splitter mySplitter;
    private GitTableScrollChangeListener myMyChangeListener;
    private List<VirtualFile> myRootsUnderVcs;
    private final Map<VirtualFile, CachedRefs> myRefs;
    private final SymbolicRefs myRecalculatedCommon;
    private UIRefresh myUIRefresh;
    private JBTable myJBTable;
    private GraphGutter myGraphGutter;
    private RepositoryChangesBrowser myRepositoryChangesBrowser;
    final List<CommitI> myCommitsInRepositoryChangesBrowser;
    private boolean myDataBeingAdded;
    private boolean myStarted;
    private String myPreviousFilter;
    private final CommentSearchContext myCommentSearchContext;
    private final List<String> myUsersSearchContext;
    private String mySelectedBranch;
    private BranchSelectorAction myBranchSelectorAction;
    private final DescriptionRenderer myDescriptionRenderer;
    private GenericDetailsLoader<CommitI, GitHeavyCommit> myDetailsLoader;
    private GenericDetailsLoader<CommitI, List<String>> myBranchesLoader;
    private GitLogDetailsPanel myDetailsPanel;
    private StepType myState;
    private MoreAction myMoreAction;
    private UsersFilterAction myUsersFilterAction;
    private MyFilterUi myUserFilterI;
    private MyRefreshAction myRefreshAction;
    private MyStructureFilter myStructureFilter;
    private StructureFilterAction myStructureFilterAction;
    private DatesFilterAction myDatesFilterAction;
    private AnAction myCopyHashAction;
    private Consumer<CommitI> myDetailsLoaderImpl;
    private Consumer<CommitI> myBranchesLoaderImpl;
    private final RequestsMerger mySelectionRequestsMerger;
    private final TableCellRenderer myAuthorRenderer;
    private MyRootsAction myRootsAction;
    private JPanel myEqualToHeadr;
    private boolean myThereIsDisordering;
    private final MyShowTreeAction myMyShowTreeAction;
    private final GitLogShowOnlyStarredCommitsAction myFilterStarredAction;
    private boolean myIsFilterByStarOn;
    private JLabel myOrderLabel;
    private boolean myProjectScope;
    private ActionPopupMenu myContextMenu;
    private final Map<AbstractHash, Long> myMarked;
    private final Runnable myRefresh;
    private JViewport myTableViewPort;
    private MyGotoCommitAction myMyGotoCommitAction;
    private final Set<VirtualFile> myClearedHighlightingRoots;
    private final Splitter myDetailsSplitter;
    private JScrollPane myTableScrollPane;
    private MyTextFieldAction myTextFieldAction;
    private DatesFilterI myDatesFilter;
    private final GitLogSettings mySettings;
    private final ColumnInfo<Object, Object> COMMENT = new ColumnInfo<Object, Object>("Comment"){
        private final TableCellRenderer mySimpleRenderer;
        {
            this.mySimpleRenderer = new SimpleRenderer(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
        }

        public Object valueOf(Object o) {
            if (o instanceof GitHeavyCommit) {
                return o;
            }
            if (BigTableTableModel.LOADING == o) {
                return o;
            }
            return o == null ? "" : o.toString();
        }

        public TableCellRenderer getRenderer(Object o) {
            return o instanceof GitHeavyCommit ? GitLogUI.this.myDescriptionRenderer : this.mySimpleRenderer;
        }
    };
    private ColumnInfo<Object, String> AUTHOR;
    private final ColumnInfo<Object, String> DATE = new ColumnInfo<Object, String>("Date"){
        private final TableCellRenderer myRenderer;
        {
            this.myRenderer = new SimpleRenderer(SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
        }

        public String valueOf(Object o) {
            if (o instanceof GitHeavyCommit) {
                return DateFormatUtil.formatPrettyDateTime((Date)((GitHeavyCommit)o).getDate());
            }
            return "";
        }

        public TableCellRenderer getRenderer(Object o) {
            return this.myRenderer;
        }
    };

    public GitLogUI(Project project, Mediator mediator) {
        this.myProject = project;
        this.myVcs = GitVcs.getInstance(project);
        this.mySettings = GitLogSettings.getInstance(this.myProject);
        this.myMediator = mediator;
        this.myCommentSearchContext = new CommentSearchContext();
        this.myUsersSearchContext = new ArrayList<String>();
        this.myRefs = new HashMap<VirtualFile, CachedRefs>();
        this.myRecalculatedCommon = new SymbolicRefs();
        this.myPreviousFilter = "";
        this.myDescriptionRenderer = new DescriptionRenderer();
        this.myCommentSearchContext.addHighlighter(((DescriptionRenderer)this.myDescriptionRenderer).myInner.myWorker);
        this.myCommitsInRepositoryChangesBrowser = new ArrayList<CommitI>();
        this.myMarked = new HashMap<AbstractHash, Long>();
        this.myClearedHighlightingRoots = new HashSet<VirtualFile>();
        this.mySelectionRequestsMerger = new RequestsMerger(new Runnable(){

            @Override
            public void run() {
                GitLogUI.this.selectionChanged();
            }
        }, (Consumer)new Consumer<Runnable>(){

            public void consume(Runnable runnable) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.createTableModel();
        this.myState = StepType.CONTINUE;
        this.initUiRefresh();
        this.myAuthorRenderer = new HighLightingRenderer(HIGHLIGHT_TEXT_ATTRIBUTES, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myMyShowTreeAction = new MyShowTreeAction();
        this.myIsFilterByStarOn = false;
        this.myFilterStarredAction = new GitLogShowOnlyStarredCommitsAction(this.createOnOffForFilterStarred());
        this.myRefresh = new Runnable(){

            @Override
            public void run() {
                GitLogUI.this.reloadRequest();
            }
        };
        this.myDetailsSplitter = new Splitter(true, 0.6f);
        this.myDetailsSplitter.setShowDividerControls(true);
    }

    private OnOff createOnOffForFilterStarred() {
        return new OnOff(){

            public boolean isOn() {
                return GitLogUI.this.myIsFilterByStarOn;
            }

            public void on() {
                GitLogUI.this.myIsFilterByStarOn = true;
                this.toggleOtherFiltersPresentation();
                GitLogUI.this.reloadRequest();
            }

            public void off() {
                GitLogUI.this.myIsFilterByStarOn = false;
                this.toggleOtherFiltersPresentation();
                GitLogUI.this.reloadRequest();
            }

            private void toggleOtherFiltersPresentation() {
                GitLogUI.this.myDatesFilterAction.greyPanelFg(GitLogUI.this.myIsFilterByStarOn);
                GitLogUI.this.myStructureFilterAction.greyPanelFg(GitLogUI.this.myIsFilterByStarOn);
                GitLogUI.this.myBranchSelectorAction.greyPanelFg(GitLogUI.this.myIsFilterByStarOn);
                GitLogUI.this.myUsersFilterAction.greyPanelFg(GitLogUI.this.myIsFilterByStarOn);
                GitLogUI.this.myTextFieldAction.setTextFieldFg(GitLogUI.this.myIsFilterByStarOn);
            }
        };
    }

    public void initFromSettings() {
        this.mySelectedBranch = this.mySettings.getSelectedBranch();
        this.myUserFilterI.myFilter = this.mySettings.getSelectedUser();
        this.myUserFilterI.myMeSelected = this.mySettings.isSelectedUserMe();
        this.myUsersFilterAction.setSelectedPresets(this.mySettings.getSelectedUser(), this.mySettings.isSelectedUserMe());
        this.myBranchSelectorAction.setPreset(this.mySelectedBranch);
        List<String> selectedPaths = this.mySettings.getSelectedPaths();
        if (selectedPaths != null && !selectedPaths.isEmpty()) {
            ArrayList<VirtualFile> paths = new ArrayList<VirtualFile>();
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (String path : selectedPaths) {
                VirtualFile vf = lfs.refreshAndFindFileByIoFile(new File(path));
                if (vf == null) {
                    return;
                }
                paths.add(vf);
            }
            this.myStructureFilter.myAllSelected = false;
            this.myStructureFilter.getSelected().addAll(paths);
        }
        this.myStructureFilterAction.setPreset();
        if (this.mySettings.getDateState().mySelectedTime) {
            this.myDatesFilterAction.setPreset(this.mySettings.getDateState());
        }
        HashSet<VirtualFile> activeRoots = new HashSet<VirtualFile>();
        Set<String> saved = this.mySettings.getActiveRoots();
        if (!saved.isEmpty()) {
            for (VirtualFile vf : this.myRootsUnderVcs) {
                if (!saved.contains(vf.getPath())) continue;
                activeRoots.add(vf);
            }
            if (!activeRoots.isEmpty()) {
                this.myTableModel.setActiveRoots(activeRoots);
            }
        }
    }

    private void setOrderText(boolean topoOrder) {
        this.myOrderLabel.setText(topoOrder ? "Topo Order" : "Date Order");
    }

    private void initUiRefresh() {
        this.myUIRefresh = new UIRefresh(){

            @Override
            public void detailsLoaded() {
                GitLogUI.this.tryRefreshDetails();
                GitLogUI.this.fireTableRepaint();
            }

            @Override
            public void linesReloaded(boolean drawMore) {
                if (!StepType.STOP.equals((Object)GitLogUI.this.myState) && !StepType.FINISHED.equals((Object)GitLogUI.this.myState)) {
                    GitLogUI.this.myState = drawMore ? StepType.PAUSE : StepType.CONTINUE;
                }
                GitLogUI.this.fireTableRepaint();
                GitLogUI.this.updateMoreVisibility();
                GitLogUI.this.orderLabelVisibility();
            }

            @Override
            public void acceptException(Exception e) {
                LOG.info((Throwable)e);
                if (GitLogUI.this.myVcs.getExecutableValidator().isExecutableValid()) {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)GitLogUI.this.myProject, (String)e.getMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            }

            @Override
            public void finished() {
                GitLogUI.this.myState = StepType.FINISHED;
                GitLogUI.this.updateMoreVisibility();
            }

            @Override
            public void reportStash(VirtualFile root, @Nullable Couple<AbstractHash> hash) {
                GitLogUI.this.myTableModel.stashFor(root, hash);
            }

            @Override
            public void reportSymbolicRefs(VirtualFile root, CachedRefs symbolicRefs) {
                GitLogUI.this.myRefs.put(root, symbolicRefs);
                GitLogUI.this.myTableModel.setHeadIfEmpty(root, symbolicRefs.getHeadHash());
                GitLogUI.this.myRecalculatedCommon.clear();
                if (GitLogUI.this.myRefs.isEmpty()) {
                    return;
                }
                CheckSamePattern currentUser = new CheckSamePattern();
                CheckSamePattern currentBranch = new CheckSamePattern();
                for (CachedRefs refs : GitLogUI.this.myRefs.values()) {
                    GitLogUI.this.myRecalculatedCommon.addLocals(refs.getLocalBranches());
                    GitLogUI.this.myRecalculatedCommon.addRemotes(refs.getRemoteBranches());
                    String currentFromRefs = refs.getCurrent() == null ? null : refs.getCurrent().getFullName();
                    currentBranch.iterate((Object)currentFromRefs);
                    currentUser.iterate((Object)refs.getUsername());
                }
                if (currentBranch.isSame()) {
                    GitLogUI.this.myRecalculatedCommon.setCurrent(((CachedRefs)GitLogUI.this.myRefs.values().iterator().next()).getCurrent());
                }
                if (currentUser.isSame()) {
                    String username = (String)currentUser.getSameValue();
                    GitLogUI.this.myRecalculatedCommon.setUsername(username);
                    GitLogUI.this.myUserFilterI.setMe(username);
                }
                GitLogUI.this.myBranchSelectorAction.setSymbolicRefs(GitLogUI.this.myRecalculatedCommon);
                GitLogUI.this.myBranchSelectorAction.asTextAction();
            }
        };
    }

    private void orderLabelVisibility() {
        this.myOrderLabel.setVisible(this.myGraphGutter.getComponent().getWidth() > 60);
    }

    private void fireTableRepaint() {
        TableSelectionKeeper keeper = new TableSelectionKeeper(this.myJBTable, this.myTableModel);
        keeper.put();
        this.myDataBeingAdded = true;
        this.myTableModel.fireTableDataChanged();
        keeper.restore();
        this.myDataBeingAdded = false;
        this.myJBTable.revalidate();
        this.myJBTable.repaint();
        ((JComponent)this.myEqualToHeadr.getParent()).revalidate();
        this.myEqualToHeadr.getParent().repaint();
    }

    private void start() {
        this.myStarted = true;
        this.myMyChangeListener.start();
        this.myGraphGutter.setRowHeight(this.myJBTable.getRowHeight());
        this.myGraphGutter.start();
        this.rootsChanged(this.myRootsUnderVcs);
    }

    public void dispose() {
    }

    public UIRefresh getUIRefresh() {
        return this.myUIRefresh;
    }

    public void createMe() {
        this.mySplitter = new Splitter(false, 0.7f);
        JPanel wrapper = this.createMainTable();
        this.mySplitter.setFirstComponent((JComponent)wrapper);
        JComponent component = this.createRepositoryBrowserDetails();
        this.mySplitter.setSecondComponent(component);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                if (GitLogUI.this.myMyChangeListener != null) {
                    GitLogUI.this.myMyChangeListener.stop();
                }
            }
        });
        this.createDetailLoaders();
    }

    private void createDetailLoaders() {
        this.myDetailsLoaderImpl = new Consumer<CommitI>(){

            public void consume(CommitI commitI) {
                if (commitI == null || commitI.holdsDecoration()) {
                    return;
                }
                GitHeavyCommit gitCommit = GitLogUI.this.fullCommitPresentation(commitI);
                if (gitCommit == null) {
                    MultiMap question = new MultiMap();
                    question.putValue(commitI.selectRepository(GitLogUI.this.myRootsUnderVcs), (Object)commitI.getHash());
                    GitLogUI.this.myDetailsCache.acceptQuestion((MultiMap<VirtualFile, AbstractHash>)question);
                } else {
                    try {
                        GitLogUI.this.myDetailsLoader.take((Object)commitI, (Object)gitCommit);
                    }
                    catch (Details.AlreadyDisposedException alreadyDisposedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.myDetailsLoader = new GenericDetailsLoader(this.myDetailsLoaderImpl, (PairConsumer)new PairConsumer<CommitI, GitHeavyCommit>(){

            public void consume(CommitI commitI, GitHeavyCommit commit) {
                GitLogUI.this.myDetailsPanel.setData((VirtualFile)commitI.selectRepository(GitLogUI.this.myRootsUnderVcs), commit);
            }
        });
        this.myBranchesLoaderImpl = new Consumer<CommitI>(){
            private final Processor<AbstractHash> myRecheck = new Processor<AbstractHash>(){

                public boolean process(AbstractHash abstractHash) {
                    if (GitLogUI.this.myBranchesLoader.getCurrentlySelected() == null) {
                        return false;
                    }
                    return Comparing.equal((Object)((CommitI)GitLogUI.this.myBranchesLoader.getCurrentlySelected()).getHash(), (Object)abstractHash);
                }
            };

            public void consume(final CommitI commitI) {
                if (commitI == null) {
                    return;
                }
                VirtualFile root = (VirtualFile)commitI.selectRepository(GitLogUI.this.myRootsUnderVcs);
                List<String> branches = GitLogUI.this.myDetailsCache.getBranches(root, commitI.getHash());
                if (branches != null) {
                    try {
                        GitLogUI.this.myBranchesLoader.take((Object)commitI, branches);
                    }
                    catch (Details.AlreadyDisposedException e) {
                        // empty catch block
                    }
                    return;
                }
                GitLogUI.this.myDetailsCache.loadAndPutBranches(root, commitI.getHash(), new Consumer<List<String>>(){

                    public void consume(List<String> strings) {
                        if (GitLogUI.this.myProject.isDisposed() || strings == null) {
                            return;
                        }
                        try {
                            GitLogUI.this.myBranchesLoader.take((Object)commitI, strings);
                        }
                        catch (Details.AlreadyDisposedException alreadyDisposedException) {
                            // empty catch block
                        }
                    }
                }, this.myRecheck);
            }
        };
        this.myBranchesLoader = new GenericDetailsLoader(this.myBranchesLoaderImpl, (PairConsumer)new PairConsumer<CommitI, List<String>>(){

            public void consume(CommitI commitI, List<String> strings) {
                GitLogUI.this.myDetailsPanel.setBranches(strings);
            }
        });
    }

    private JComponent createRepositoryBrowserDetails() {
        this.myRepositoryChangesBrowser = new RepositoryChangesBrowser(this.myProject, Collections.emptyList(), Collections.emptyList(), null);
        this.myRepositoryChangesBrowser.getDiffAction().registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)this.myJBTable);
        this.myRepositoryChangesBrowser.getViewer().setScrollPaneBorder(IdeBorderFactory.createBorder((int)3));
        this.myJBTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GitLogUI.this.myGraphGutter.getComponent().repaint();
                GitLogUI.this.mySelectionRequestsMerger.request();
            }
        });
        return this.myRepositoryChangesBrowser;
    }

    private void selectionChanged() {
        if (this.myDataBeingAdded) {
            this.mySelectionRequestsMerger.request();
            return;
        }
        int[] rows = this.myJBTable.getSelectedRows();
        this.selectionChangedForDetails(rows);
        if (rows.length == 0) {
            this.myRepositoryChangesBrowser.getViewer().setEmptyText("Nothing selected");
            return;
        }
        if (rows.length >= 10) {
            this.myRepositoryChangesBrowser.getViewer().setEmptyText("Too many rows selected");
            return;
        }
        if (!this.myDataBeingAdded && !this.gatherNotLoadedData()) {
            this.myRepositoryChangesBrowser.getViewer().setEmptyText("Loading...");
        }
    }

    private void tryRefreshDetails() {
        MeaningfulSelection meaningfulSelection = new MeaningfulSelection(this.myJBTable.getSelectedRows(), this.myTableModel);
        if (meaningfulSelection.getMeaningfulRows() == 1) {
            CommitI commit = meaningfulSelection.getCommit();
            this.myDetailsLoaderImpl.consume((Object)commit);
            this.myBranchesLoaderImpl.consume((Object)commit);
        }
    }

    private void selectionChangedForDetails(int[] rows) {
        MeaningfulSelection meaningfulSelection = new MeaningfulSelection(rows, this.myTableModel);
        int meaningfulRows = meaningfulSelection.getMeaningfulRows();
        CommitI commitAt = meaningfulSelection.getCommit();
        if (meaningfulRows == 0) {
            this.myDetailsPanel.nothingSelected();
            this.myDetailsLoader.updateSelection(null, false);
            this.myBranchesLoader.updateSelection(null, false);
        } else if (meaningfulRows == 1) {
            GitHeavyCommit commit = this.fullCommitPresentation(commitAt);
            if (commit == null) {
                this.myDetailsPanel.loading(commitAt.selectRepository(this.myRootsUnderVcs));
            }
            this.myDetailsLoader.updateSelection((Object)commitAt, false);
            this.myBranchesLoader.updateSelection((Object)commitAt, false);
        } else {
            this.myDetailsPanel.severalSelected();
            this.myDetailsLoader.updateSelection(null, false);
            this.myBranchesLoader.updateSelection(null, false);
        }
    }

    private GitHeavyCommit fullCommitPresentation(CommitI commitAt) {
        return this.myDetailsCache.convert(commitAt.selectRepository(this.myRootsUnderVcs), commitAt.getHash());
    }

    public void updateByScroll() {
        this.gatherNotLoadedData();
    }

    private boolean gatherNotLoadedData() {
        if (this.myDataBeingAdded) {
            return false;
        }
        int[] rows = this.myJBTable.getSelectedRows();
        ArrayList<GitHeavyCommit> commits = new ArrayList<GitHeavyCommit>();
        ArrayList<CommitI> forComparison = new ArrayList<CommitI>();
        MultiMap missingHashes = new MultiMap();
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            CommitI commitI = this.myTableModel.getCommitAt(row);
            if (commitI == null || commitI.holdsDecoration()) continue;
            GitHeavyCommit details = this.fullCommitPresentation(commitI);
            if (details == null) {
                missingHashes.putValue((Object)commitI.selectRepository(this.myRootsUnderVcs), (Object)commitI.getHash());
                continue;
            }
            if (!missingHashes.isEmpty()) continue;
            forComparison.add(commitI);
            commits.add(details);
        }
        if (!missingHashes.isEmpty()) {
            this.myDetailsCache.acceptQuestion((MultiMap<VirtualFile, AbstractHash>)missingHashes);
            return false;
        }
        if (Comparing.equal(this.myCommitsInRepositoryChangesBrowser, forComparison)) {
            return true;
        }
        this.myCommitsInRepositoryChangesBrowser.clear();
        this.myCommitsInRepositoryChangesBrowser.addAll(forComparison);
        ArrayList<Change> changes = new ArrayList<Change>();
        for (GitHeavyCommit commit : commits) {
            changes.addAll(commit.getChanges());
        }
        List zipped = CommittedChangesTreeBrowser.zipChanges(changes);
        this.myRepositoryChangesBrowser.setChangesToDisplay(zipped);
        return true;
    }

    private JPanel createMainTable() {
        this.myJBTable = new JBTable(this.myTableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                TableCellRenderer custom = GitLogUI.this.myTableModel.getColumnInfo(column).getRenderer(GitLogUI.this.myTableModel.getValueAt(row, column));
                return custom == null ? super.getCellRenderer(row, column) : custom;
            }
        };
        if (UIUtil.isUnderDarcula()) {
            this.myJBTable.setStriped(true);
            this.myJBTable.setShowGrid(false);
        }
        TableLinkMouseListener tableLinkListener = new TableLinkMouseListener(){

            protected Object tryGetTag(MouseEvent e, JTable table, int row, int column) {
                GitLogUI.this.myDescriptionRenderer.getTableCellRendererComponent(table, table.getValueAt(row, column), false, false, row, column);
                Rectangle rc = table.getCellRect(row, column, false);
                return GitLogUI.this.myDescriptionRenderer.myInner.getFragmentTag(e.getPoint().x - rc.x - GitLogUI.this.myDescriptionRenderer.getCurrentWidth());
            }
        };
        ActionToolbar actionToolbar = this.createToolbar();
        tableLinkListener.installOn((Component)this.myJBTable);
        this.myJBTable.getExpandableItemsHandler().setEnabled(false);
        this.myJBTable.setShowGrid(false);
        this.myJBTable.setModel((TableModel)this.myTableModel);
        this.myJBTable.setBorder(null);
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                GitLogUI.this.createContextMenu();
                GitLogUI.this.myContextMenu.getComponent().show(comp, x, y);
            }
        };
        this.myJBTable.addMouseListener((MouseListener)popupHandler);
        this.myTableScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myJBTable);
        this.myTableScrollPane.setBorder(IdeBorderFactory.createBorder((int)14));
        this.myGraphGutter = new GraphGutter(this.myTableModel);
        this.myGraphGutter.setJBTable(this.myJBTable);
        this.myTableViewPort = this.myTableScrollPane.getViewport();
        this.myGraphGutter.setTableViewPort(this.myTableViewPort);
        this.myGraphGutter.getComponent().addMouseListener((MouseListener)popupHandler);
        new AdjustComponentWhenShown(){

            protected boolean init() {
                return GitLogUI.this.adjustColumnSizes(GitLogUI.this.myTableScrollPane);
            }

            protected boolean canExecute() {
                return GitLogUI.this.myStarted;
            }
        }.install((Component)this.myJBTable);
        this.myMyChangeListener = new GitTableScrollChangeListener(this.myJBTable, this.myDetailsCache, this.myTableModel, new Runnable(){

            @Override
            public void run() {
                GitLogUI.this.updateByScroll();
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (GitLogUI.this.myGraphGutter.getComponent().isVisible()) {
                    GitLogUI.this.myGraphGutter.getComponent().repaint();
                }
            }
        });
        this.myTableScrollPane.getViewport().addChangeListener(this.myMyChangeListener);
        DataProviderPanel wrapper = new DataProviderPanel(new BorderLayout());
        wrapper.add((Component)actionToolbar.getComponent(), "North");
        JPanel mainBorderWrapper = new JPanel(new BorderLayout());
        JPanel wrapperGutter = new JPanel(new BorderLayout());
        this.createTreeUpperComponent();
        wrapperGutter.add((Component)this.myEqualToHeadr, "North");
        wrapperGutter.add((Component)this.myGraphGutter.getComponent(), "Center");
        mainBorderWrapper.add((Component)wrapperGutter, "West");
        mainBorderWrapper.add((Component)this.myTableScrollPane, "Center");
        wrapper.add((Component)mainBorderWrapper, "Center");
        this.myDetailsPanel = new GitLogDetailsPanel(this.myProject, this.myDetailsCache, new Convertor<VirtualFile, CachedRefs>(){

            public CachedRefs convert(VirtualFile o) {
                return (CachedRefs)GitLogUI.this.myRefs.get(o);
            }
        }, new Processor<AbstractHash>(){

            public boolean process(AbstractHash hash) {
                return GitLogUI.this.myMarked.containsKey(hash);
            }
        });
        this.myDetailsSplitter.setFirstComponent((JComponent)wrapper);
        JPanel details = this.myDetailsPanel.getComponent();
        details.setBorder(IdeBorderFactory.createBorder((int)6));
        this.setupDetailsSplitter(this.mySettings.isShowDetails());
        return this.myDetailsSplitter;
    }

    private void createTreeUpperComponent() {
        final MyTreeSettings treeSettings = new MyTreeSettings();
        this.myEqualToHeadr = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return this.getMySize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getMySize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getMySize();
            }

            public Dimension getMySize() {
                int height = GitLogUI.this.myJBTable.getTableHeader().getHeight();
                int width = ((GitLogUI)GitLogUI.this).myGraphGutter.getComponent().getPreferredSize().width;
                return new Dimension(width, height);
            }
        };
        this.myEqualToHeadr.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, UIUtil.getBorderColor()));
        JPanel wr2 = new JPanel(new BorderLayout());
        this.myOrderLabel = new JLabel();
        this.myOrderLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myOrderLabel.setBorder(new EmptyBorder(0, 1, 0, 0));
        wr2.add((Component)this.myOrderLabel, "West");
        wr2.add((Component)treeSettings.getLabel(), "East");
        this.myEqualToHeadr.add((Component)wr2, "Center");
        treeSettings.getLabel().setBorder(BorderFactory.createLineBorder(UIUtil.getLabelBackground()));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                treeSettings.execute(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                treeSettings.getLabel().setBackground(UIUtil.getLabelBackground());
                treeSettings.getLabel().setBorder(BorderFactory.createLineBorder(UIUtil.getLabelBackground()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                treeSettings.getLabel().setBackground(UIUtil.getLabelBackground().darker());
                treeSettings.getLabel().setBorder(BorderFactory.createLineBorder(Color.black));
            }
        };
        this.myEqualToHeadr.addMouseListener(mouseAdapter);
        treeSettings.getLabel().addMouseListener(mouseAdapter);
    }

    private void createContextMenu() {
        if (this.myContextMenu == null) {
            GitHeavyCommit commit;
            DefaultActionGroup group = new DefaultActionGroup();
            Point location = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(location, (Component)this.myJBTable);
            int row = this.myJBTable.rowAtPoint(location);
            if (row >= 0 && (commit = this.getCommitAtRow(row)) != null) {
                this.myUsersFilterAction.setPreselectedUser(commit.getCommitter());
            }
            group.add(GitLogUI.getCherryPickAction());
            group.add((AnAction)new CreatePatchFromChangesAction(){

                public void update(AnActionEvent e) {
                    Change[] changes;
                    e.getPresentation().setEnabled((changes = (Change[])e.getData(VcsDataKeys.CHANGES)) != null && changes.length > 0);
                }
            });
            group.add((AnAction)new MyCheckoutRevisionAction());
            group.add((AnAction)new MyCheckoutNewBranchAction());
            group.add((AnAction)new MyCreateNewTagAction());
            group.add((AnAction)new Separator());
            group.add(this.myCopyHashAction);
            group.add((AnAction)this.myMyShowTreeAction);
            group.add((AnAction)this.myMyGotoCommitAction);
            CustomShortcutSet shortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(71, 640));
            this.myMyGotoCommitAction.registerCustomShortcutSet((ShortcutSet)shortcutSet, (JComponent)this.myJBTable);
            this.myMyGotoCommitAction.registerCustomShortcutSet((ShortcutSet)shortcutSet, this.myGraphGutter.getComponent());
            MyHighlightCurrent myHighlightCurrent = new MyHighlightCurrent();
            CustomShortcutSet customShortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(87, SystemInfo.isMac ? 256 : 128));
            myHighlightCurrent.registerCustomShortcutSet((ShortcutSet)customShortcutSet, (JComponent)this.myJBTable);
            myHighlightCurrent.registerCustomShortcutSet((ShortcutSet)customShortcutSet, this.myGraphGutter.getComponent());
            group.add((AnAction)myHighlightCurrent);
            group.add((AnAction)new MyHighlightActionGroup());
            MyToggleCommitMark toggleCommitMark = new MyToggleCommitMark();
            toggleCommitMark.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)this.myJBTable);
            toggleCommitMark.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this.myGraphGutter.getComponent());
            group.add((AnAction)toggleCommitMark);
            group.add((AnAction)new Separator());
            group.add(this.myBranchSelectorAction.asTextAction());
            group.add(this.myUsersFilterAction.asTextAction());
            group.add(this.myStructureFilterAction.asTextAction());
            group.add(this.myDatesFilterAction.asTextAction());
            group.add((AnAction)new Separator());
            group.add((AnAction)this.myRefreshAction);
            group.addAll(GitLogUI.getCustomActions());
            this.myRefreshAction.registerShortcutOn((JComponent)this.myJBTable);
            this.myRefreshAction.registerShortcutOn(this.myGraphGutter.getComponent());
            this.myContextMenu = ActionManager.getInstance().createActionPopupMenu(GIT_LOG_TABLE_PLACE, (ActionGroup)group);
        }
    }

    @NotNull
    private static ActionGroup getCustomActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Git.LogContextMenu");
        if (actionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI", "getCustomActions"));
        }
        return actionGroup;
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        this.myBranchSelectorAction = new BranchSelectorAction(this.myProject, new Consumer<String>(){

            public void consume(String s) {
                GitLogUI.this.mySelectedBranch = s;
                GitLogUI.this.reloadRequest();
            }
        });
        this.myUserFilterI = new MyFilterUi(this.myRefresh);
        this.myUsersFilterAction = new UsersFilterAction(this.myProject, this.myUserFilterI);
        this.myTextFieldAction = new MyTextFieldAction();
        group.add((AnAction)this.myTextFieldAction);
        group.add((AnAction)this.myBranchSelectorAction);
        group.add((AnAction)this.myUsersFilterAction);
        Getter<List<VirtualFile>> rootsGetter = new Getter<List<VirtualFile>>(){

            public List<VirtualFile> get() {
                return GitLogUI.this.myRootsUnderVcs;
            }
        };
        this.myStructureFilter = new MyStructureFilter(this.myRefresh, (Getter)rootsGetter);
        this.myStructureFilterAction = new StructureFilterAction(this.myProject, this.myStructureFilter);
        group.add((AnAction)this.myStructureFilterAction);
        this.myDatesFilter = new DatesFilterI(){

            @Override
            public long getBefore() {
                return ((GitLogUI)GitLogUI.this).mySettings.getDateState().mySelectedTime ? ((GitLogUI)GitLogUI.this).mySettings.getDateState().myTimeBefore : -1L;
            }

            @Override
            public long getAfter() {
                return ((GitLogUI)GitLogUI.this).mySettings.getDateState().mySelectedTime ? ((GitLogUI)GitLogUI.this).mySettings.getDateState().myTimeAfter : -1L;
            }

            @Override
            public boolean isAll() {
                return !((GitLogUI)GitLogUI.this).mySettings.getDateState().mySelectedTime;
            }

            @Override
            public long getCommitTimeIfOne() {
                CommitI commitAt = GitLogUI.this.getCommitIfOneRealSelected();
                return commitAt == null ? -1L : commitAt.getTime();
            }

            @Override
            public void selectAll() {
                ((GitLogUI)GitLogUI.this).mySettings.getDateState().mySelectedTime = false;
                GitLogUI.this.myRefresh.run();
            }

            @Override
            public void filter(long before, long after, String presetFilterName) {
                GitLogSettings.MyDateState state = GitLogUI.this.mySettings.getDateState();
                state.myTimeBefore = before;
                state.myTimeAfter = after;
                state.mySelectedTime = true;
                state.myPresetFilter = presetFilterName;
                GitLogUI.this.myRefresh.run();
            }
        };
        this.myDatesFilterAction = new DatesFilterAction(this.myProject, this.myDatesFilter);
        group.add((AnAction)this.myDatesFilterAction);
        group.add((AnAction)this.myFilterStarredAction);
        group.add(GitLogUI.getCherryPickAction());
        group.add(ActionManager.getInstance().getAction("ChangesView.CreatePatchFromChanges"));
        this.myRefreshAction = new MyRefreshAction();
        this.myRootsAction = new MyRootsAction((Getter)rootsGetter, (JComponent)this.myJBTable);
        group.add((AnAction)this.myRootsAction);
        group.add((AnAction)this.myMyShowTreeAction);
        group.add((AnAction)new ToggleAction("Show Details", "Display details panel", AllIcons.Actions.Preview){

            public boolean isSelected(AnActionEvent e) {
                return !GitLogUI.this.myProject.isDisposed() && GitLogUI.this.mySettings.isShowDetails();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                GitLogUI.this.setupDetailsSplitter(state);
                if (!GitLogUI.this.myProject.isDisposed()) {
                    GitLogUI.this.mySettings.setShowDetails(state);
                }
            }
        });
        this.myMyGotoCommitAction = new MyGotoCommitAction();
        group.add((AnAction)this.myMyGotoCommitAction);
        group.add((AnAction)this.myRefreshAction);
        group.add((AnAction)new ContextHelpAction("reference.changesToolWindow.log"));
        this.myMoreAction = new MoreAction(){

            public void actionPerformed(AnActionEvent e) {
                GitLogUI.this.myMediator.continueLoading();
                GitLogUI.this.myState = StepType.CONTINUE;
                GitLogUI.this.updateMoreVisibility();
            }
        };
        group.add((AnAction)this.myMoreAction);
        this.myCopyHashAction = new AnAction("Copy Hash"){

            public void actionPerformed(AnActionEvent e) {
                int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
                StringBuilder sb = new StringBuilder();
                for (int row : selectedRows) {
                    CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(row);
                    if (commitAt == null) continue;
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(commitAt.getHash().getString());
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(GitLogUI.this.myJBTable.getSelectedRowCount() > 0);
            }
        };
        return ActionManager.getInstance().createActionToolbar("Git log", (ActionGroup)group, true);
    }

    private static AnAction getCherryPickAction() {
        return ActionManager.getInstance().getAction("Git.CherryPick");
    }

    private void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent(state ? this.myDetailsPanel.getComponent() : null);
        if (state) {
            this.myTableScrollPane.setBorder(IdeBorderFactory.createBorder((int)14));
        } else {
            this.myTableScrollPane.setBorder(IdeBorderFactory.createBorder((int)6));
        }
    }

    @NotNull
    private List<GitHeavyCommit> getSelectedCommits() {
        if (this.myJBTable == null) {
            List<GitHeavyCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI", "getSelectedCommits"));
            }
            return list;
        }
        ArrayList<GitHeavyCommit> commits = new ArrayList<GitHeavyCommit>();
        for (int row : this.myJBTable.getSelectedRows()) {
            CommitI commitI = this.myTableModel.getCommitAt(row);
            if (commitI == null) {
                List<GitHeavyCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI", "getSelectedCommits"));
                }
                return list;
            }
            if (commitI.holdsDecoration()) continue;
            VirtualFile root = commitI.selectRepository(this.myRootsUnderVcs);
            GitHeavyCommit gitCommit = this.myDetailsCache.convert(root, commitI.getHash());
            if (gitCommit == null) {
                List<GitHeavyCommit> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI", "getSelectedCommits"));
                }
                return list;
            }
            commits.add(gitCommit);
        }
        ArrayList<GitHeavyCommit> arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI", "getSelectedCommits"));
        }
        return arrayList;
    }

    @Nullable
    private GitHeavyCommit getCommitAtRow(int row) {
        CommitI commitAt = this.myTableModel.getCommitAt(row);
        if (commitAt == null) {
            return null;
        }
        GitHeavyCommit gitCommit = this.fullCommitPresentation(commitAt);
        if (gitCommit == null) {
            return null;
        }
        return gitCommit;
    }

    private boolean adjustColumnSizes(JScrollPane scrollPane) {
        if (this.myJBTable.getWidth() <= 0) {
            return false;
        }
        this.createContextMenu();
        TableColumnModel columnModel = this.myJBTable.getColumnModel();
        FontMetrics metrics = this.myJBTable.getFontMetrics(this.myJBTable.getFont());
        int height = metrics.getHeight();
        this.myJBTable.setRowHeight((int)((double)height * 1.3) + 1);
        this.myGraphGutter.setRowHeight(this.myJBTable.getRowHeight());
        this.myGraphGutter.setHeaderHeight(this.myJBTable.getTableHeader().getHeight());
        int dateWidth = metrics.stringWidth("Yesterday 00:00:00  " + scrollPane.getVerticalScrollBar().getWidth()) + columnModel.getColumnMargin();
        int nameWidth = metrics.stringWidth("Somelong W. UsernameToDisplay");
        int widthWas = 0;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            widthWas += columnModel.getColumn(i).getWidth();
        }
        columnModel.getColumn(1).setWidth(nameWidth);
        columnModel.getColumn(1).setPreferredWidth(nameWidth);
        columnModel.getColumn(2).setWidth(dateWidth);
        columnModel.getColumn(2).setPreferredWidth(dateWidth);
        int nullWidth = widthWas - dateWidth - nameWidth - columnModel.getColumnMargin() * 3;
        columnModel.getColumn(0).setWidth(nullWidth);
        columnModel.getColumn(0).setPreferredWidth(nullWidth);
        return true;
    }

    public JComponent getPanel() {
        return this.mySplitter;
    }

    public void rootsChanged(List<VirtualFile> rootsUnderVcs) {
        RootsHolder wasRootsHolder = this.myTableModel.getRootsHolder();
        HashSet<VirtualFile> activeRoots = new HashSet<VirtualFile>(rootsUnderVcs);
        if (wasRootsHolder != null) {
            HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>(wasRootsHolder.getRoots());
            excludedRoots.removeAll(this.myTableModel.getActiveRoots());
            activeRoots.removeAll(excludedRoots);
        }
        this.myRootsUnderVcs = rootsUnderVcs;
        RootsHolder rootsHolder = new RootsHolder(rootsUnderVcs);
        this.myTableModel.setRootsHolder(rootsHolder);
        this.myTableModel.setActiveRoots(activeRoots);
        this.myDetailsCache.rootsChanged(rootsUnderVcs);
        if (this.myStarted) {
            this.reloadRequest();
        }
    }

    public UIRefresh getRefreshObject() {
        return this.myUIRefresh;
    }

    public BigTableTableModel getTableModel() {
        return this.myTableModel;
    }

    private void createTableModel() {
        this.myTableModel = new BigTableTableModel(this.columns(), new Runnable(){

            @Override
            public void run() {
                GitLogUI.this.start();
            }
        });
    }

    List<ColumnInfo> columns() {
        this.initAuthor();
        return Arrays.asList(this.COMMENT, this.AUTHOR, this.DATE);
    }

    private Color getRowBg(int row) {
        int[] selectedRows = this.myJBTable.getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            for (int selectedRow : selectedRows) {
                if (selectedRow != row) continue;
                return UIUtil.getTableSelectionBackground();
            }
        }
        if (this.myClearedHighlightingRoots.isEmpty()) {
            return this.myTableModel.isInCurrentBranch(row) ? Colors.highlighted : (UIUtil.isUnderDarcula() ? UIUtil.getTableBackground().darker() : UIUtil.getTableBackground());
        }
        CommitI commitAt = this.myTableModel.getCommitAt(row);
        if (commitAt.holdsDecoration()) {
            return UIUtil.getTableBackground();
        }
        VirtualFile virtualFile = commitAt.selectRepository(this.myRootsUnderVcs);
        return this.myClearedHighlightingRoots.contains(virtualFile) ? UIUtil.getTableBackground() : (this.myTableModel.isInCurrentBranch(row) ? Colors.highlighted : UIUtil.getTableBackground());
    }

    private void initAuthor() {
        this.AUTHOR = new ColumnInfo<Object, String>("Author"){

            public String valueOf(Object o) {
                if (o instanceof GitHeavyCommit) {
                    return ((GitHeavyCommit)o).getAuthor();
                }
                return "";
            }

            public TableCellRenderer getRenderer(Object o) {
                return GitLogUI.this.myAuthorRenderer;
            }
        };
    }

    public void setDetailsCache(DetailsCache detailsCache) {
        this.myDetailsCache = detailsCache;
    }

    private void reloadRequest() {
        boolean haveFilters;
        this.mySettings.setSelectedBranch(this.mySelectedBranch);
        this.mySettings.setSelectedUser(this.myUserFilterI.myFilter);
        this.mySettings.setSelectedUserIsMe(this.myUserFilterI.isMeSelected());
        this.mySettings.setSelectedPaths(this.myStructureFilter.myAllSelected ? null : this.myStructureFilter.getSelected());
        this.myState = StepType.CONTINUE;
        int was = this.myTableModel.getRowCount();
        this.myDetailsCache.resetAsideCaches();
        List<String> startingPoints = this.mySelectedBranch == null ? Collections.emptyList() : Collections.singletonList(this.mySelectedBranch);
        GitLogSettings.MyDateState dateState = this.mySettings.getDateState();
        Set<ChangesFilter.Filter> dateFilters = null;
        if (dateState.mySelectedTime) {
            dateFilters = this.applyDateFilter();
        }
        this.myDescriptionRenderer.resetIcons();
        boolean commentFilterEmpty = StringUtil.isEmptyOrSpaces((String)this.myPreviousFilter);
        this.myCommentSearchContext.clear();
        this.myUsersSearchContext.clear();
        this.myThereIsDisordering = haveFilters = !commentFilterEmpty || this.myUserFilterI.myFilter != null || !this.myStructureFilter.myAllSelected || this.mySettings.getDateState().mySelectedTime || this.myIsFilterByStarOn;
        boolean topoOrder = !this.myThereIsDisordering && this.myRootsUnderVcs.size() == 1 ? this.mySettings.isTopoOrder() : false;
        this.myOrderLabel.setVisible(false);
        this.setOrderText(topoOrder);
        if (topoOrder) {
            this.myTableModel.useNoGroupingStrategy();
        } else {
            this.myTableModel.useDateGroupingStrategy();
        }
        this.myEqualToHeadr.getParent().setVisible(!this.myThereIsDisordering && this.myMyShowTreeAction.isSelected(null));
        if (!haveFilters) {
            this.myUsersSearchContext.clear();
            this.myMediator.reload(new RootsHolder(this.myRootsUnderVcs), startingPoints, null, new GitLogFilters(), topoOrder);
        } else if (this.myIsFilterByStarOn) {
            this.myUsersSearchContext.clear();
            this.myMediator.reloadSetFixed(this.myMarked, new RootsHolder(this.myRootsUnderVcs));
        } else {
            ChangesFilter.Comment comment = null;
            if (!commentFilterEmpty) {
                String commentFilter = this.myCommentSearchContext.preparse(this.myPreviousFilter);
                comment = new ChangesFilter.Comment(commentFilter);
            }
            Set<ChangesFilter.Filter> userFilters = null;
            if (this.myUserFilterI.myFilter != null) {
                userFilters = this.applyUserFilter();
            }
            Map<VirtualFile, ChangesFilter.Filter> structureFilters = null;
            if (!this.myStructureFilter.myAllSelected) {
                structureFilters = this.applyStructureFilter();
            }
            List<String> possibleReferencies = commentFilterEmpty ? null : Arrays.asList(this.myPreviousFilter.split("[\\s]"));
            this.myMediator.reload(new RootsHolder(this.myRootsUnderVcs), startingPoints, null, new GitLogFilters(comment, userFilters, dateFilters, structureFilters, possibleReferencies), topoOrder);
        }
        this.myCommentSearchContext.addHighlighter(this.myDetailsPanel.getHtmlHighlighter());
        this.updateMoreVisibility();
        this.mySelectionRequestsMerger.request();
        this.fireTableRepaint();
        this.myTableModel.fireTableRowsDeleted(0, was);
        this.myGraphGutter.getComponent().revalidate();
        this.myGraphGutter.getComponent().repaint();
    }

    private Set<ChangesFilter.Filter> applyDateFilter() {
        long timeAfter;
        HashSet<ChangesFilter.Filter> result = new HashSet<ChangesFilter.Filter>();
        long timeBefore = this.mySettings.getDateState().myTimeBefore;
        if (timeBefore > 0L) {
            result.add(new ChangesFilter.BeforeTime(timeBefore));
        }
        if ((timeAfter = this.mySettings.getDateState().myTimeAfter) > 0L) {
            result.add(new ChangesFilter.AfterTime(timeAfter));
        }
        return result;
    }

    private Map<VirtualFile, ChangesFilter.Filter> applyStructureFilter() {
        HashMap<VirtualFile, ChangesFilter.Filter> structureFilters = new HashMap<VirtualFile, ChangesFilter.Filter>();
        ArrayList<VirtualFile> selected = new ArrayList<VirtualFile>(this.myStructureFilter.getSelected());
        ArrayList<VirtualFile> copy = new ArrayList<VirtualFile>(this.myRootsUnderVcs);
        Collections.sort(copy, FilePathComparator.getInstance());
        Collections.reverse(copy);
        for (VirtualFile root : copy) {
            SmartList selectedForRoot = new SmartList();
            Iterator iterator = selected.iterator();
            while (iterator.hasNext()) {
                VirtualFile next = (VirtualFile)iterator.next();
                if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)next, (boolean)false)) continue;
                selectedForRoot.add(next);
                iterator.remove();
            }
            if (selectedForRoot.isEmpty()) continue;
            ChangesFilter.StructureFilter structureFilter = new ChangesFilter.StructureFilter();
            structureFilter.addFiles((Collection<VirtualFile>)selectedForRoot);
            structureFilters.put(root, structureFilter);
        }
        return structureFilters;
    }

    private Set<ChangesFilter.Filter> applyUserFilter() {
        String[] strings = this.myUserFilterI.myFilter.split(",");
        HashSet<ChangesFilter.Filter> userFilters = new HashSet<ChangesFilter.Filter>();
        for (String string : strings) {
            if ((string = string.trim()).length() == 0) continue;
            this.myUsersSearchContext.add(string.toLowerCase());
            String regexp = StringUtil.escapeToRegexp((String)string);
            userFilters.add(new ChangesFilter.Committer(regexp));
            userFilters.add(new ChangesFilter.Author(regexp));
        }
        return userFilters;
    }

    private void updateMoreVisibility() {
        if (StepType.PAUSE.equals((Object)this.myState)) {
            this.myMoreAction.setEnabled(true);
            this.myMoreAction.setVisible(true);
        } else if (StepType.CONTINUE.equals((Object)this.myState)) {
            this.myMoreAction.setVisible(true);
            this.myMoreAction.setEnabled(false);
        } else {
            this.myMoreAction.setVisible(false);
        }
    }

    public void setProjectScope(boolean projectScope) {
        this.myProjectScope = projectScope;
        this.myRootsAction.setEnabled(!projectScope);
    }

    private CommitI getCommitIfOneRealSelected() {
        int[] selectedRows = this.myJBTable.getSelectedRows();
        if (selectedRows.length != 1) {
            return null;
        }
        CommitI commitAt = this.myTableModel.getCommitAt(selectedRows[0]);
        if (commitAt.holdsDecoration()) {
            return null;
        }
        return commitAt;
    }

    private void weNeedOneCommitSelected(AnActionEvent e) {
        int[] selectedRows = this.myJBTable.getSelectedRows();
        if (selectedRows.length != 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        CommitI commitAt = this.myTableModel.getCommitAt(selectedRows[0]);
        if (commitAt.holdsDecoration()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    private void commitCanBeUsedForCheckout(AnActionEvent e) {
        int[] selectedRows = this.myJBTable.getSelectedRows();
        if (selectedRows.length != 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        CommitI commitAt = this.myTableModel.getCommitAt(selectedRows[0]);
        boolean enabled = !commitAt.holdsDecoration() && !this.myTableModel.isStashed(commitAt);
        e.getPresentation().setEnabled(enabled);
    }

    public void selectCommit(String commitId) {
        this.myJBTable.getSelectionModel().clearSelection();
        this.myMyGotoCommitAction.tryFind(commitId);
    }

    public class MyGotoCommitAction
    extends DumbAwareAction {
        public MyGotoCommitAction() {
            super("Find Commit", "Find commit by hash, reference or description fragment (in loaded part)", AllIcons.Actions.Menu_find);
        }

        public void actionPerformed(final AnActionEvent e) {
            final JTextField field = new JTextField(30);
            final String[] gotoString = new String[1];
            final JBPopup[] popup = new JBPopup[1];
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (10 == e.getKeyCode()) {
                        gotoString[0] = field.getText();
                        if (gotoString[0] != null) {
                            MyGotoCommitAction.this.tryFind(gotoString[0]);
                        }
                        if (popup[0] != null) {
                            popup[0].cancel();
                        }
                    }
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)field, "Center");
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)field);
            popup[0] = builder.setTitle("Goto").setResizable(true).setFocusable(true).setRequestFocus(true).setMovable(true).setModalContext(true).setAdText("Commit hash, or reference, or regexp for commit message").setDimensionServiceKey(GitLogUI.this.myProject, "Git.Log.Tree.Goto", true).setCancelOnClickOutside(true).addListener(new JBPopupListener(){

                public void beforeShown(LightweightWindowEvent event) {
                    IdeFocusManager.findInstanceByContext((DataContext)e.getDataContext()).requestFocus((Component)field, true);
                }

                public void onClosed(LightweightWindowEvent event) {
                }
            }).createPopup();
            UIUtil.installPopupMenuColorAndFonts((JComponent)popup[0].getContent());
            UIUtil.installPopupMenuBorder((JComponent)popup[0].getContent());
            popup[0].showInBestPositionFor(e.getDataContext());
        }

        private void tryFind(String reference) {
            int idx = this.getIdx(reference = reference.trim());
            if (idx == -1) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)GitLogUI.this.myProject, (String)("Nothing found for: \"" + reference + "\""), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
            } else {
                GitLogUI.this.myJBTable.getSelectionModel().addSelectionInterval(idx, idx);
                int scrollOffsetTop = GitLogUI.this.myJBTable.getRowHeight() * idx - GitLogUI.this.myTableViewPort.getHeight() / 2;
                if (scrollOffsetTop > 0) {
                    GitLogUI.this.myTableViewPort.setViewPosition(new Point(0, scrollOffsetTop));
                }
            }
        }

        private int getIdx(String reference) {
            int commitByIteration;
            int commitByIteration2;
            if (!StringUtil.containsWhitespaces((CharSequence)reference) && (commitByIteration2 = this.findCommitByIteration(reference)) != -1) {
                return commitByIteration2;
            }
            for (VirtualFile root : GitLogUI.this.myRootsUnderVcs) {
                int commitByIteration3;
                SHAHash shaHash = GitChangeUtils.commitExists(GitLogUI.this.myProject, root, reference, null, new String[0]);
                if (shaHash == null || (commitByIteration3 = this.findCommitByIteration(shaHash.getValue())) == -1) continue;
                return commitByIteration3;
            }
            HashSet<AbstractHash> hashes = new HashSet<AbstractHash>();
            for (VirtualFile root : GitLogUI.this.myRootsUnderVcs) {
                List<AbstractHash> abstractHashs = GitChangeUtils.commitExistsByComment(GitLogUI.this.myProject, root, reference);
                if (abstractHashs == null) continue;
                hashes.addAll(abstractHashs);
            }
            if (!hashes.isEmpty() && (commitByIteration = this.findCommitByIteration(hashes)) != -1) {
                return commitByIteration;
            }
            return -1;
        }

        private int findCommitByIteration(Set<AbstractHash> references) {
            for (int i = 0; i < GitLogUI.this.myTableModel.getRowCount(); ++i) {
                CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(i);
                if (commitAt.holdsDecoration() || !references.contains(commitAt.getHash())) continue;
                return i;
            }
            return -1;
        }

        private int findCommitByIteration(String reference) {
            for (int i = 0; i < GitLogUI.this.myTableModel.getRowCount(); ++i) {
                String string;
                CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(i);
                if (commitAt.holdsDecoration() || !(string = commitAt.getHash().getString()).startsWith(reference) && !reference.startsWith(string)) continue;
                return i;
            }
            return -1;
        }
    }

    private class MyCreateNewTagAction
    extends DumbAwareAction {
        private MyCreateNewTagAction() {
            super("New Tag");
        }

        public void actionPerformed(AnActionEvent e) {
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return;
            }
            CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRows[0]);
            if (commitAt.holdsDecoration() || GitLogUI.this.myTableModel.isStashed(commitAt)) {
                return;
            }
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(GitLogUI.this.myProject).getRepositoryForRoot((VirtualFile)commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs));
            if (repository == null) {
                return;
            }
            new GitCreateNewTag(GitLogUI.this.myProject, repository, commitAt.getHash().getString(), GitLogUI.this.myRefresh).execute();
        }

        public void update(AnActionEvent e) {
            GitLogUI.this.commitCanBeUsedForCheckout(e);
        }
    }

    private class MyCheckoutNewBranchAction
    extends DumbAwareAction {
        private MyCheckoutNewBranchAction() {
            super("New Branch", "Create new branch starting from the selected commit", IconUtil.getAddIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return;
            }
            CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRows[0]);
            if (commitAt.holdsDecoration() || GitLogUI.this.myTableModel.isStashed(commitAt)) {
                return;
            }
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(GitLogUI.this.myProject).getRepositoryForRoot((VirtualFile)commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs));
            if (repository == null) {
                return;
            }
            String reference = commitAt.getHash().getString();
            String name = GitBranchUtil.getNewBranchNameFromUser(GitLogUI.this.myProject, Collections.singleton(repository), "Checkout New Branch From " + reference);
            if (name != null) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)GitLogUI.this.myProject, GitBrancher.class);
                brancher.checkoutNewBranchStartingFrom(name, reference, Collections.singletonList(repository), GitLogUI.this.myRefresh);
            }
        }

        public void update(AnActionEvent e) {
            GitLogUI.this.commitCanBeUsedForCheckout(e);
        }
    }

    private class MyCheckoutRevisionAction
    extends DumbAwareAction {
        private MyCheckoutRevisionAction() {
            super("Checkout Revision");
        }

        public void actionPerformed(AnActionEvent e) {
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (selectedRows.length != 1) {
                return;
            }
            CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRows[0]);
            if (commitAt.holdsDecoration() || GitLogUI.this.myTableModel.isStashed(commitAt)) {
                return;
            }
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(GitLogUI.this.myProject).getRepositoryForRoot((VirtualFile)commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs));
            if (repository == null) {
                return;
            }
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)GitLogUI.this.myProject, GitBrancher.class);
            brancher.checkout(commitAt.getHash().getString(), Collections.singletonList(repository), GitLogUI.this.myRefresh);
        }

        public void update(AnActionEvent e) {
            GitLogUI.this.commitCanBeUsedForCheckout(e);
        }
    }

    private static enum Action {
        disabled,
        select,
        unselect;

    }

    public class MyToggleCommitMark
    extends DumbAwareAction {
        public MyToggleCommitMark() {
            super("Mark", "Mark", Git4ideaIcons.Star);
        }

        public void actionPerformed(AnActionEvent e) {
            CommitI commitAt;
            Action action = this.checkSelection();
            if (Action.disabled.equals((Object)action)) {
                return;
            }
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (Action.unselect.equals((Object)action)) {
                for (int selectedRow : selectedRows) {
                    commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRow);
                    if (commitAt.holdsDecoration()) continue;
                    GitLogUI.this.myMarked.remove(commitAt.getHash());
                }
            }
            if (Action.select.equals((Object)action)) {
                for (int selectedRow : selectedRows) {
                    commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRow);
                    if (commitAt.holdsDecoration()) continue;
                    GitLogUI.this.myMarked.put(commitAt.getHash(), commitAt.getTime());
                }
            }
            GitLogUI.this.myJBTable.repaint();
            GitLogUI.this.myGraphGutter.getComponent().repaint();
            GitLogUI.this.myDetailsPanel.redrawBranchLabels();
            GitLogUI.this.myDetailsPanel.getComponent().revalidate();
            GitLogUI.this.myDetailsPanel.getComponent().repaint();
        }

        public void update(AnActionEvent e) {
            Action action = this.checkSelection();
            e.getPresentation().setEnabled(!Action.disabled.equals((Object)action));
            e.getPresentation().setVisible(!Action.disabled.equals((Object)action));
            e.getPresentation().setText(Action.select.equals((Object)action) ? "Mark" : "Clear mark");
        }

        private Action checkSelection() {
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (selectedRows.length == 0) {
                return Action.disabled;
            }
            boolean haveSelected = false;
            boolean haveUnSelected = false;
            for (int selectedRow : selectedRows) {
                CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRow);
                if (commitAt.holdsDecoration()) continue;
                if (GitLogUI.this.myMarked.containsKey(commitAt.getHash())) {
                    haveSelected = true;
                    continue;
                }
                haveUnSelected = true;
            }
            if (!haveSelected && !haveUnSelected) {
                return Action.disabled;
            }
            if (haveSelected) {
                return Action.unselect;
            }
            return Action.select;
        }
    }

    public class MyHighlightActionGroup
    extends ActionGroup {
        private final DumbAwareAction myAllHeads;
        private final DumbAwareAction myClearAll;
        private final DumbAwareAction myHead;
        private final AnAction[] myAnActions;

        public MyHighlightActionGroup() {
            super("Highlight...", true);
            this.myAllHeads = new DumbAwareAction("All HEADs subgraphs"){

                public void actionPerformed(AnActionEvent e) {
                    for (VirtualFile root : GitLogUI.this.myTableModel.getActiveRoots()) {
                        AbstractHash headHash;
                        SymbolicRefsI symbolicRefs = (SymbolicRefsI)GitLogUI.this.myRefs.get(root);
                        if (symbolicRefs == null || (headHash = symbolicRefs.getHeadHash()) == null) continue;
                        GitLogUI.this.myTableModel.setHead(root, headHash);
                        GitLogUI.this.myClearedHighlightingRoots.removeAll(GitLogUI.this.myRootsUnderVcs);
                    }
                    GitLogUI.this.myJBTable.repaint();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    if (GitLogUI.this.myThereIsDisordering) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    e.getPresentation().setVisible(GitLogUI.this.myTableModel.getActiveRoots().size() > 1);
                }
            };
            this.myClearAll = new DumbAwareAction("Clear"){

                public void actionPerformed(AnActionEvent e) {
                    for (VirtualFile root : GitLogUI.this.myTableModel.getActiveRoots()) {
                        GitLogUI.this.myTableModel.setDumbHighlighter(root);
                    }
                    GitLogUI.this.myClearedHighlightingRoots.addAll(GitLogUI.this.myRootsUnderVcs);
                    GitLogUI.this.myJBTable.repaint();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    if (GitLogUI.this.myThereIsDisordering) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                }
            };
            this.myHead = new DumbAwareAction("HEAD subgraph"){

                public void actionPerformed(AnActionEvent e) {
                    int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
                    if (selectedRows.length != 1) {
                        return;
                    }
                    CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(selectedRows[0]);
                    if (commitAt.holdsDecoration()) {
                        return;
                    }
                    VirtualFile root = (VirtualFile)commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs);
                    SymbolicRefsI symbolicRefs = (SymbolicRefsI)GitLogUI.this.myRefs.get(root);
                    if (symbolicRefs == null) {
                        return;
                    }
                    AbstractHash headHash = symbolicRefs.getHeadHash();
                    if (headHash == null) {
                        return;
                    }
                    GitLogUI.this.myTableModel.setHead(root, headHash);
                    GitLogUI.this.myClearedHighlightingRoots.remove(root);
                    GitLogUI.this.myJBTable.repaint();
                }

                public void update(AnActionEvent e) {
                    if (GitLogUI.this.myThereIsDisordering) {
                        e.getPresentation().setEnabled(false);
                        return;
                    }
                    GitLogUI.this.weNeedOneCommitSelected(e);
                }
            };
            this.myAnActions = new AnAction[]{this.myHead, this.myAllHeads, this.myClearAll};
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!GitLogUI.this.myThereIsDisordering);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myAnActions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI$MyHighlightActionGroup", "getChildren"));
            }
            return this.myAnActions;
        }
    }

    public class MyHighlightCurrent
    extends DumbAwareAction {
        public MyHighlightCurrent() {
            super("Highlight subgraph");
        }

        public void actionPerformed(AnActionEvent e) {
            CommitI commitAt = GitLogUI.this.getCommitIfOneRealSelected();
            if (commitAt == null) {
                return;
            }
            VirtualFile root = (VirtualFile)commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs);
            GitLogUI.this.myTableModel.setHead(root, commitAt.getHash());
            GitLogUI.this.myClearedHighlightingRoots.remove(root);
            GitLogUI.this.myJBTable.repaint();
        }

        public void update(AnActionEvent e) {
            if (GitLogUI.this.myThereIsDisordering) {
                e.getPresentation().setEnabled(false);
                return;
            }
            GitLogUI.this.weNeedOneCommitSelected(e);
        }
    }

    public class MySelectRootsForTreeAction
    extends DumbAwareAction {
        public MySelectRootsForTreeAction() {
            super("Repositories...");
        }

        public void actionPerformed(AnActionEvent e) {
            final CheckBoxList checkBoxList = new CheckBoxList();
            final List<VirtualFile> order = GitLogUI.this.myTableModel.getOrder();
            Set<VirtualFile> activeRoots = GitLogUI.this.myTableModel.getActiveRoots();
            TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
            for (VirtualFile virtualFile : order) {
                map.put(virtualFile.getPath(), activeRoots.contains(virtualFile));
            }
            checkBoxList.setStringItems(map);
            final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)checkBoxList, (JComponent)checkBoxList).setRequestFocus(true).addListener(new JBPopupListener(){

                public void beforeShown(LightweightWindowEvent event) {
                    checkBoxList.setSelectedIndex(0);
                    IdeFocusManager.getInstance((Project)GitLogUI.this.myProject).requestFocus((Component)checkBoxList, true);
                }

                public void onClosed(LightweightWindowEvent event) {
                    if (event.isOk()) {
                        HashSet<String> paths = new HashSet<String>(ContainedInBranchesConfigDialog.gatherSelected((DefaultListModel)checkBoxList.getModel()));
                        if (paths.isEmpty()) {
                            GitLogUI.this.myMyShowTreeAction.setSelected(null, false);
                            return;
                        }
                        HashSet<VirtualFile> set = new HashSet<VirtualFile>(order);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            VirtualFile file = (VirtualFile)iterator.next();
                            if (paths.contains(file.getPath())) continue;
                            iterator.remove();
                        }
                        if (GitLogUI.this.myProjectScope) {
                            GitLogUI.this.mySettings.setActiveRoots(paths);
                        }
                        GitLogUI.this.myTableModel.setActiveRoots(set);
                        GitLogUI.this.myGraphGutter.getComponent().revalidate();
                        GitLogUI.this.myGraphGutter.getComponent().repaint();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GitLogUI.this.orderLabelVisibility();
                            }
                        });
                    }
                }
            }).setTitle("Show graph for:").setAdText("Press Enter to complete").createPopup();
            AnAction ok = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    popup.closeOk(e.getInputEvent());
                }
            };
            ok.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, (JComponent)checkBoxList);
            ok.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)checkBoxList);
            if (e != null && e.getInputEvent() instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                Dimension dimension = popup.getContent().getPreferredSize();
                Point at = new Point(20, 0);
                popup.show(new RelativePoint((Component)GitLogUI.this.myEqualToHeadr, at));
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            boolean enabled = GitLogUI.this.myRootsUnderVcs.size() > 1;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled);
        }
    }

    public class MyTreeSettings {
        private final DumbAwareAction myMultiColorAction;
        private final DumbAwareAction myCalmAction;
        private final Icon myIcon = AllIcons.General.ComboArrow;
        private final JLabel myLabel;
        private final MySelectRootsForTreeAction myRootsForTreeAction;
        private final DumbAwareAction myDateOrder;
        private final DumbAwareAction myTopoOrder;
        private final Icon myMarkIcon = PlatformIcons.CHECK_ICON;

        public MyTreeSettings() {
            this.myMultiColorAction = new DumbAwareAction("Multicolour"){

                public void actionPerformed(AnActionEvent e) {
                    GitLogUI.this.myGraphGutter.setStyle(GraphGutter.PresentationStyle.multicolour);
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(GraphGutter.PresentationStyle.multicolour.equals((Object)GitLogUI.this.myGraphGutter.getStyle()) ? AllIcons.General.Mdot : AllIcons.General.Mdot_empty);
                }
            };
            this.myCalmAction = new DumbAwareAction("Two Colors"){

                public void actionPerformed(AnActionEvent e) {
                    GitLogUI.this.myGraphGutter.setStyle(GraphGutter.PresentationStyle.calm);
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(GraphGutter.PresentationStyle.multicolour.equals((Object)GitLogUI.this.myGraphGutter.getStyle()) ? AllIcons.General.Mdot_empty : AllIcons.General.Mdot);
                }
            };
            this.myDateOrder = new DumbAwareAction("Date Order"){

                public void actionPerformed(AnActionEvent e) {
                    if (!GitLogUI.this.mySettings.isTopoOrder()) {
                        return;
                    }
                    GitLogUI.this.mySettings.setTopoOrder(false);
                    GitLogUI.this.reloadRequest();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(GitLogUI.this.mySettings.isTopoOrder() ? AllIcons.General.Mdot_empty : AllIcons.General.Mdot);
                }
            };
            this.myTopoOrder = new DumbAwareAction("Topo Order"){

                public void actionPerformed(AnActionEvent e) {
                    if (GitLogUI.this.mySettings.isTopoOrder()) {
                        return;
                    }
                    GitLogUI.this.mySettings.setTopoOrder(true);
                    GitLogUI.this.reloadRequest();
                }

                public void update(AnActionEvent e) {
                    super.update(e);
                    e.getPresentation().setIcon(GitLogUI.this.mySettings.isTopoOrder() ? AllIcons.General.Mdot : AllIcons.General.Mdot_empty);
                }
            };
            this.myRootsForTreeAction = new MySelectRootsForTreeAction();
            this.myLabel = new JLabel(this.myIcon);
            this.myLabel.setOpaque(false);
        }

        public JLabel getLabel() {
            return this.myLabel;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public void execute(MouseEvent e) {
            DefaultActionGroup group = this.createActionGroup();
            DataContext parent = DataManager.getInstance().getDataContext((Component)GitLogUI.this.myEqualToHeadr);
            DataContext dataContext = SimpleDataContext.getSimpleContext((String)CommonDataKeys.PROJECT.getName(), (Object)GitLogUI.this.myProject, (DataContext)parent);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, new Runnable(){

                @Override
                public void run() {
                }
            }, 20);
            popup.show(new RelativePoint(e));
        }

        private DefaultActionGroup createActionGroup() {
            DefaultActionGroup dab = new DefaultActionGroup();
            if (GitLogUI.this.myRootsUnderVcs.size() == 1) {
                dab.add((AnAction)this.myDateOrder);
                dab.add((AnAction)this.myTopoOrder);
                dab.add((AnAction)new Separator());
            }
            dab.add((AnAction)this.myMultiColorAction);
            dab.add((AnAction)this.myCalmAction);
            dab.add((AnAction)new Separator());
            dab.add((AnAction)this.myRootsForTreeAction);
            return dab;
        }
    }

    public class MyShowTreeAction
    extends ToggleAction
    implements DumbAware {
        private static final String SHOW_GRAPH_TITLE = "Show Graph";
        private static final String HIDE_GRAPH_TITLE = "Hide Graph";
        private static final String SHOW_GRAPH_DESCRIPTION = "Display commit graph";
        private static final String HIDE_GRAPH_DESCRIPTION = "Hide commit graph";
        private boolean myIsSelected;

        public MyShowTreeAction() {
            super(SHOW_GRAPH_TITLE, SHOW_GRAPH_DESCRIPTION, Git4ideaIcons.Branch);
            this.myIsSelected = GitLogUI.this.mySettings.isShowTree();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!GitLogUI.this.myThereIsDisordering);
            e.getPresentation().setText(this.isSelected(e) ? HIDE_GRAPH_TITLE : SHOW_GRAPH_TITLE);
            e.getPresentation().setDescription(this.isSelected(e) ? HIDE_GRAPH_DESCRIPTION : SHOW_GRAPH_DESCRIPTION);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIsSelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myIsSelected = state;
            GitLogUI.this.mySettings.setShowTree(state);
            if (!GitLogUI.this.myThereIsDisordering) {
                GitLogUI.this.myEqualToHeadr.getParent().setVisible(state);
            }
        }
    }

    private static class MyRootsAction
    extends AnAction {
        private boolean myEnabled;
        private final Getter<List<VirtualFile>> myRootsGetter;
        private final JComponent myComponent;

        private MyRootsAction(Getter<List<VirtualFile>> rootsGetter, JComponent component) {
            super("Show roots", "Show roots", AllIcons.General.BalloonInformation);
            this.myRootsGetter = rootsGetter;
            this.myComponent = component;
            this.myEnabled = false;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myEnabled);
            e.getPresentation().setVisible(this.myEnabled);
            super.update(e);
        }

        public void actionPerformed(AnActionEvent e) {
            List virtualFiles = (List)this.myRootsGetter.get();
            assert (virtualFiles != null && virtualFiles.size() > 0);
            SortedListModel sortedListModel = new SortedListModel(null);
            JBList jbList = new JBList((ListModel)sortedListModel);
            sortedListModel.add((Object)"Roots:");
            for (VirtualFile virtualFile : virtualFiles) {
                sortedListModel.add((Object)virtualFile.getPath());
            }
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jbList, (JComponent)jbList).setRequestFocus(true).createPopup();
            if (e.getInputEvent() instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }
    }

    private static class MyStructureFilter
    implements StructureFilterI {
        private boolean myAllSelected;
        private final List<VirtualFile> myFiles;
        private final Runnable myReloadCallback;
        private final Getter<List<VirtualFile>> myGetter;

        private MyStructureFilter(Runnable reloadCallback, Getter<List<VirtualFile>> getter) {
            this.myReloadCallback = reloadCallback;
            this.myGetter = getter;
            this.myFiles = new ArrayList<VirtualFile>();
            this.myAllSelected = true;
        }

        @Override
        public void allSelected() {
            if (this.myAllSelected) {
                return;
            }
            this.myAllSelected = true;
            this.myReloadCallback.run();
        }

        @Override
        public void select(Collection<VirtualFile> files) {
            this.myAllSelected = false;
            if (Comparing.haveEqualElements(files, this.myFiles)) {
                return;
            }
            this.myFiles.clear();
            this.myFiles.addAll(files);
            this.myReloadCallback.run();
        }

        @Override
        public Collection<VirtualFile> getSelected() {
            return this.myFiles;
        }

        @Override
        public List<VirtualFile> getRoots() {
            return (List)this.myGetter.get();
        }

        @Override
        public boolean isAllSelected() {
            return this.myAllSelected;
        }
    }

    private class MyFilterUi
    implements UserFilterI {
        private boolean myMeIsKnown;
        private String myMe;
        private String myFilter;
        private boolean myMeSelected;
        private final Runnable myReloadCallback;

        public MyFilterUi(Runnable reloadCallback) {
            this.myReloadCallback = reloadCallback;
        }

        @Override
        public void allSelected() {
            this.myFilter = null;
            this.myMeSelected = false;
            this.myReloadCallback.run();
        }

        @Override
        public void meSelected() {
            this.myFilter = this.myMe;
            this.myMeSelected = true;
            this.myReloadCallback.run();
        }

        @Override
        public void filter(String s) {
            this.myMeSelected = false;
            this.myFilter = s;
            this.myReloadCallback.run();
        }

        @Override
        public boolean isMeKnown() {
            return this.myMeIsKnown;
        }

        public boolean isMeSelected() {
            return this.myMeSelected;
        }

        @Override
        public String getMe() {
            return this.myMe;
        }

        @Override
        public String getUserIfOne() {
            int[] selectedRows = GitLogUI.this.myJBTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                for (int row : selectedRows) {
                    GitHeavyCommit atRow;
                    CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(row);
                    if (commitAt.holdsDecoration() || (atRow = GitLogUI.this.getCommitAtRow(row)) == null || atRow.getCommitter() == null) continue;
                    return atRow.getCommitter();
                }
            }
            return null;
        }

        public void setMe(String me) {
            this.myMeIsKnown = !StringUtil.isEmptyOrSpaces((String)me);
            this.myMe = me == null ? "" : me.trim();
        }
    }

    static interface Colors {
        public static final Color tag = new JBColor(new Color(15855518), new Color(113, 111, 64));
        public static final Color remote = new JBColor(new Color(0xBCBCFC), new Color(0xBCBCFC).darker().darker());
        public static final Color local = new JBColor(new Color(7728839), new Color(879951));
        public static final Color highlighted = new JBColor(new Color(210, 255, 233), UIUtil.getTableBackground());
    }

    private class MyTextFieldAction
    extends SearchFieldAction {
        private MyTextFieldAction() {
            super("Filter:");
        }

        public void actionPerformed(AnActionEvent e) {
            this.checkIfFilterChanged();
        }

        private void checkIfFilterChanged() {
            String newValue = this.getText().trim();
            if (!Comparing.equal((String)GitLogUI.this.myPreviousFilter, (String)newValue)) {
                GitLogUI.this.myPreviousFilter = newValue;
                GitLogUI.this.reloadRequest();
            }
        }
    }

    private class MyRefreshAction
    extends RefreshAction {
        private MyRefreshAction() {
            super("Refresh", "Refresh", AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e) {
            GitLogUI.this.rootsChanged(GitLogUI.this.myRootsUnderVcs);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }
    }

    private class TestIndexAction
    extends DumbAwareAction {
        private TestIndexAction() {
            super("Test Index", "Test Index", PlatformIcons.CHECK_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            GitLogUI.this.myTableModel.printNavigation();
        }
    }

    private class DescriptionRenderer
    implements TableCellRenderer {
        private final Map<String, Icon> myTagMap;
        private final Map<String, Icon> myBranchMap;
        private final JPanel myPanel;
        private final Inner myInner = new Inner();
        private int myCurrentWidth;

        private DescriptionRenderer() {
            this.myTagMap = new HashMap<String, Icon>();
            this.myBranchMap = new HashMap<String, Icon>();
            this.myPanel = new JPanel();
            this.myPanel.setBackground(UIUtil.getTableBackground());
            BoxLayout layout = new BoxLayout(this.myPanel, 0);
            this.myPanel.setLayout(layout);
            this.myCurrentWidth = 0;
        }

        public void resetIcons() {
            this.myBranchMap.clear();
            this.myTagMap.clear();
        }

        public int getCurrentWidth() {
            return this.myCurrentWidth;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bg;
            this.myCurrentWidth = 0;
            Color color = bg = isSelected ? UIUtil.getTableSelectionBackground() : GitLogUI.this.getRowBg(row);
            if (value instanceof GitHeavyCommit) {
                this.myPanel.removeAll();
                this.myPanel.setBackground(bg);
                GitHeavyCommit commit = (GitHeavyCommit)value;
                boolean marked = GitLogUI.this.myMarked.containsKey(commit.getShortHash());
                int localSize = commit.getLocalBranches() == null ? 0 : commit.getLocalBranches().size();
                int remoteSize = commit.getRemoteBranches() == null ? 0 : commit.getRemoteBranches().size();
                int tagsSize = commit.getTags().size();
                if (marked) {
                    this.myPanel.add(new JLabel(Git4ideaIcons.Star));
                    this.myCurrentWidth += Git4ideaIcons.Star.getIconWidth();
                }
                if (localSize + remoteSize > 0) {
                    CommitI commitI = GitLogUI.this.myTableModel.getCommitAt(row);
                    List<Trinity<String, Boolean, Color>> display = this.getBranchesToDisplay(commit, commitI);
                    boolean containsHead = commit.getTags().contains("HEAD");
                    boolean plus = localSize + remoteSize + tagsSize > display.size() + (containsHead ? 1 : 0);
                    for (int i = 0; i < display.size(); ++i) {
                        Trinity<String, Boolean, Color> trinity = display.get(i);
                        boolean withContionuation = containsHead ? false : plus && i == display.size() - 1;
                        String key = (String)trinity.getFirst() + (withContionuation ? "@" : "");
                        Icon icon = this.myBranchMap.get(key);
                        if (icon == null) {
                            icon = new CaptionIcon((Color)trinity.getThird(), table.getFont().deriveFont((float)table.getFont().getSize() - 1.0f), (String)trinity.getFirst(), (Component)table, CaptionIcon.Form.SQUARE, withContionuation, ((Boolean)trinity.getSecond()).booleanValue());
                            this.myBranchMap.put(key, icon);
                        }
                        this.addOneIcon(table, value, isSelected, hasFocus, row, column, icon);
                    }
                    if (tagsSize > 0 && containsHead) {
                        this.addTagIcon(table, value, isSelected, hasFocus, row, column, "HEAD", plus);
                    }
                    this.myInner.setBackground(bg);
                    return this.myPanel;
                }
                if (localSize + remoteSize == 0 && tagsSize > 0) {
                    String tag = commit.getTags().get(0);
                    this.addTagIcon(table, value, isSelected, hasFocus, row, column, tag, tagsSize > 1);
                    this.myInner.setBackground(bg);
                    return this.myPanel;
                }
                if (marked) {
                    this.myInner.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.myPanel.add((Component)((Object)this.myInner));
                    this.myInner.setBackground(bg);
                    return this.myPanel;
                }
            }
            this.myInner.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.myInner.setBackground(bg);
            return this.myInner;
        }

        private void addTagIcon(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, String tag, boolean plus) {
            String key = tag + (plus ? "@" : "");
            Icon icon = this.myTagMap.get(key);
            if (icon == null) {
                icon = new CaptionIcon(Colors.tag, table.getFont().deriveFont((float)table.getFont().getSize() - 1.0f), tag, (Component)table, CaptionIcon.Form.ROUNDED, plus, false);
                this.myTagMap.put(key, icon);
            }
            this.addOneIcon(table, value, isSelected, hasFocus, row, column, icon);
        }

        private List<Trinity<String, Boolean, Color>> getBranchesToDisplay(GitHeavyCommit commit, CommitI commitI) {
            ArrayList<Trinity<String, Boolean, Color>> result = new ArrayList<Trinity<String, Boolean, Color>>();
            List<String> localBranches = commit.getLocalBranches();
            SymbolicRefsI symbolicRefs = (SymbolicRefsI)GitLogUI.this.myRefs.get(commitI.selectRepository(GitLogUI.this.myRootsUnderVcs));
            String currentName = symbolicRefs.getCurrentName();
            String trackedRemoteName = symbolicRefs.getTrackedRemoteName();
            if (currentName != null && localBranches.contains(currentName)) {
                result.add((Trinity<String, Boolean, Color>)new Trinity((Object)currentName, (Object)true, (Object)Colors.local));
            }
            List<String> remoteBranches = commit.getRemoteBranches();
            if (trackedRemoteName != null && remoteBranches.contains(trackedRemoteName)) {
                result.add((Trinity<String, Boolean, Color>)new Trinity((Object)trackedRemoteName, (Object)true, (Object)Colors.remote));
            }
            if (result.isEmpty()) {
                boolean remote = localBranches.isEmpty();
                result.add((Trinity<String, Boolean, Color>)new Trinity((Object)(remote ? remoteBranches.get(0) : localBranches.get(0)), (Object)false, (Object)(remote ? Colors.remote : Colors.local)));
            }
            return result;
        }

        private void addOneIcon(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, Icon icon) {
            this.myCurrentWidth += icon.getIconWidth();
            this.myPanel.add(new JLabel(icon));
            this.myInner.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.myPanel.add((Component)((Object)this.myInner));
        }

        private class Inner
        extends HighLightingRenderer {
            private final IssueLinkRenderer myIssueLinkRenderer;
            private final Consumer<String> myConsumer;

            private Inner() {
                super(HIGHLIGHT_TEXT_ATTRIBUTES, null);
                this.myIssueLinkRenderer = new IssueLinkRenderer(GitLogUI.this.myProject, (SimpleColoredComponent)this);
                this.myConsumer = new Consumer<String>(){

                    public void consume(String s) {
                        Inner.this.myWorker.tryHighlight(s);
                    }
                };
            }

            @Override
            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof GitHeavyCommit) {
                    GitHeavyCommit gitCommit = (GitHeavyCommit)value;
                    this.myIssueLinkRenderer.appendTextWithLinks(gitCommit.getSubject(), SimpleTextAttributes.REGULAR_ATTRIBUTES, this.myConsumer);
                } else {
                    super.customizeCellRenderer(table, value, selected, hasFocus, row, column);
                }
            }
        }
    }

    private class SimpleRenderer
    extends ColoredTableCellRenderer {
        private final SimpleTextAttributes myAtt;
        private final boolean myShowLoading;

        public SimpleRenderer(SimpleTextAttributes att, boolean showLoading) {
            this.myAtt = att;
            this.myShowLoading = showLoading;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setBackground(GitLogUI.this.getRowBg(row));
            if (BigTableTableModel.LOADING == value) {
                if (this.myShowLoading) {
                    this.append("Loading...");
                }
                return;
            }
            this.append(value.toString(), this.myAtt);
        }
    }

    private class HighLightingRenderer
    extends ColoredTableCellRenderer {
        private final SimpleTextAttributes myHighlightAttributes;
        private final SimpleTextAttributes myUsualAttributes;
        private SimpleTextAttributes myUsualAttributesForRun;
        protected final HighlightingRendererBase myWorker;

        public HighLightingRenderer(SimpleTextAttributes highlightAttributes, SimpleTextAttributes usualAttributes) {
            this.myHighlightAttributes = highlightAttributes;
            this.myUsualAttributesForRun = this.myUsualAttributes = usualAttributes == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : usualAttributes;
            this.myWorker = new HighlightingRendererBase(){

                @Override
                protected void usual(String s) {
                    HighLightingRenderer.this.append(s, HighLightingRenderer.this.myUsualAttributesForRun);
                }

                @Override
                protected void highlight(String s) {
                    HighLightingRenderer.this.append(s, SimpleTextAttributes.merge((SimpleTextAttributes)HighLightingRenderer.this.myUsualAttributesForRun, (SimpleTextAttributes)HighLightingRenderer.this.myHighlightAttributes));
                }
            };
        }

        public HighlightingRendererBase getWorker() {
            return this.myWorker;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setBackground(GitLogUI.this.getRowBg(row));
            if (BigTableTableModel.LOADING == value) {
                return;
            }
            String text = value.toString();
            SimpleTextAttributes simpleTextAttributes = this.myUsualAttributesForRun = this.isCurrentUser(row, text) ? SimpleTextAttributes.merge((SimpleTextAttributes)this.myUsualAttributes, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES) : new SimpleTextAttributes(this.myUsualAttributes.getBgColor(), this.myUsualAttributes.getFgColor(), this.myUsualAttributes.getWaveColor(), this.myUsualAttributes.getStyle());
            if (this.myWorker.isEmpty()) {
                this.append(text, this.myUsualAttributesForRun);
                return;
            }
            this.myWorker.tryHighlight(text);
        }

        private boolean isCurrentUser(int row, String text) {
            CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(row);
            if (commitAt == null) {
                return false;
            }
            SymbolicRefsI symbolicRefs = (SymbolicRefsI)GitLogUI.this.myRefs.get(commitAt.selectRepository(GitLogUI.this.myRootsUnderVcs));
            if (symbolicRefs == null) {
                return false;
            }
            return Comparing.equal((String)symbolicRefs.getUsername(), (String)text);
        }
    }

    public static class SubstringsFilter
    extends AbstractFilterChildren<String> {
        protected boolean isAncestor(String parent, String child) {
            return parent.startsWith(child);
        }

        protected void sortAscending(List<String> strings) {
            Collections.sort(strings, new ComparableComparator.Descending());
        }
    }

    private static class CommentSearchContext {
        private final List<HighlightingRendererBase> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private final List<String> mySearchContext = new ArrayList<String>();

        private CommentSearchContext() {
        }

        public void addHighlighter(HighlightingRendererBase renderer) {
            this.myListeners.add(renderer);
        }

        public void clear() {
            this.mySearchContext.clear();
            for (HighlightingRendererBase listener : this.myListeners) {
                listener.setSearchContext(Collections.<String>emptyList());
            }
        }

        public String preparse(String previousFilter) {
            String[] strings = previousFilter.split("[\\s]");
            StringBuilder sb = new StringBuilder();
            this.mySearchContext.clear();
            for (String string : strings) {
                if (string.trim().length() == 0) continue;
                this.mySearchContext.add(string.toLowerCase());
                String word = StringUtil.escapeToRegexp((String)string);
                sb.append(word).append(".*");
            }
            new SubstringsFilter().doFilter(this.mySearchContext);
            for (HighlightingRendererBase listener : this.myListeners) {
                listener.setSearchContext(this.mySearchContext);
            }
            return sb.toString();
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements TypeSafeDataProvider {
        private final GitCommitDetailsProvider myCommitDetailsProvider;

        private DataProviderPanel(LayoutManager layout) {
            super(layout);
            this.myCommitDetailsProvider = new GitCommitDetailsProvider(){

                @Override
                @NotNull
                public List<String> getContainingBranches(@NotNull VirtualFile root, @NotNull AbstractHash commitHash) {
                    if (root == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/wholeTree/GitLogUI$DataProviderPanel$1", "getContainingBranches"));
                    }
                    if (commitHash == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "git4idea/history/wholeTree/GitLogUI$DataProviderPanel$1", "getContainingBranches"));
                    }
                    List<String> branches = GitLogUI.this.myDetailsCache.getBranches(root, commitHash);
                    List<Object> list = branches == null ? Collections.emptyList() : branches;
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/wholeTree/GitLogUI$DataProviderPanel$1", "getContainingBranches"));
                    }
                    return list;
                }
            };
        }

        public void calcData(DataKey key, DataSink sink) {
            if (VcsDataKeys.CHANGES.equals(key) || GitVcs.GIT_COMMIT.equals((Object)key)) {
                int[] rows = GitLogUI.this.myJBTable.getSelectedRows();
                if (rows.length != 1) {
                    return;
                }
                int row = rows[0];
                GitHeavyCommit gitCommit = GitLogUI.this.getCommitAtRow(row);
                if (gitCommit == null) {
                    return;
                }
                if (VcsDataKeys.CHANGES.equals(key)) {
                    ArrayList<Change> changes = new ArrayList<Change>(gitCommit.getChanges());
                    sink.put(key, (Object)changes.toArray(new Change[changes.size()]));
                } else if (GitVcs.GIT_COMMIT.equals((Object)key)) {
                    sink.put(key, (Object)gitCommit);
                }
            } else if (GitVcs.SELECTED_COMMITS.equals((Object)key)) {
                sink.put(key, (Object)GitLogUI.this.getSelectedCommits());
            } else if (GitVcs.COMMIT_DETAILS_PROVIDER.equals((Object)key)) {
                sink.put(key, (Object)this.myCommitDetailsProvider);
            } else if (VcsDataKeys.PRESET_COMMIT_MESSAGE.equals(key)) {
                int[] rows = GitLogUI.this.myJBTable.getSelectedRows();
                if (rows.length != 1) {
                    return;
                }
                CommitI commitAt = GitLogUI.this.myTableModel.getCommitAt(rows[0]);
                if (commitAt == null) {
                    return;
                }
                GitHeavyCommit gitCommit = GitLogUI.this.fullCommitPresentation(commitAt);
                if (gitCommit == null) {
                    return;
                }
                sink.put(key, (Object)gitCommit.getDescription());
            }
        }
    }

    private static class MeaningfulSelection {
        private CommitI myCommitI;
        private int myMeaningfulRows = 0;

        private MeaningfulSelection(int[] rows, BigTableTableModel tableModel) {
            for (int row : rows) {
                CommitI commitAt = tableModel.getCommitAt(row);
                if (commitAt.holdsDecoration()) continue;
                this.myCommitI = commitAt;
                ++this.myMeaningfulRows;
                if (this.myMeaningfulRows > 1) break;
            }
        }

        @Nullable
        public CommitI getCommit() {
            return this.myCommitI;
        }

        public int getMeaningfulRows() {
            return this.myMeaningfulRows;
        }
    }

    private static class TableSelectionKeeper {
        private final List<Pair<Integer, AbstractHash>> myData;
        private final JBTable myTable;
        private final BigTableTableModel myModel;
        private int[] mySelectedRows;

        private TableSelectionKeeper(JBTable table, BigTableTableModel model) {
            this.myTable = table;
            this.myModel = model;
            this.myData = new ArrayList<Pair<Integer, AbstractHash>>();
        }

        public void put() {
            for (int row : this.mySelectedRows = this.myTable.getSelectedRows()) {
                CommitI commitI = this.myModel.getCommitAt(row);
                if (commitI == null) continue;
                this.myData.add((Pair<Integer, AbstractHash>)Pair.create((Object)commitI.selectRepository(SelectorList.getInstance()), (Object)commitI.getHash()));
            }
        }

        public void restore() {
            int rowCount = this.myModel.getRowCount();
            ListSelectionModel selectionModel = this.myTable.getSelectionModel();
            for (int row : this.mySelectedRows) {
                Pair pair;
                CommitI commitI = this.myModel.getCommitAt(row);
                if (commitI == null || !this.myData.remove(pair = Pair.create((Object)commitI.selectRepository(SelectorList.getInstance()), (Object)commitI.getHash()))) continue;
                selectionModel.addSelectionInterval(row, row);
                if (!this.myData.isEmpty()) continue;
                return;
            }
            if (this.myData.isEmpty()) {
                return;
            }
            for (int i = 0; i < rowCount; ++i) {
                Pair pair;
                CommitI commitI = this.myModel.getCommitAt(i);
                if (commitI == null || !this.myData.remove(pair = Pair.create((Object)commitI.selectRepository(SelectorList.getInstance()), (Object)commitI.getHash()))) continue;
                selectionModel.addSelectionInterval(i, i);
                if (this.myData.isEmpty()) break;
            }
        }
    }
}

