/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.WireEvent;
import git4idea.history.wholeTree.WireEventI;
import git4idea.history.wholeTree.WireEventsIterator;
import icons.Git4ideaIcons;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.Nullable;

public class GraphGutter {
    private static final int ourLineWidth = 8;
    private static final int ourInterLineWidth = 2;
    private static final int ourInterRepoLineWidth = 5;
    public static final int ourIndent = 2;
    private boolean myCurrentBranchColored;
    private int myHeaderHeight;
    private int myRowHeight;
    private final BigTableTableModel myModel;
    private MyComponent myComponent;
    private JViewport myTableViewPort;
    private JBTable myJBTable;
    private boolean myStarted;
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.wholeTree.GraphGutter");
    private PresentationStyle myStyle;
    public static final Color OUTLINE_NOT_INCLUDED = Gray._180;
    private static final Icon[] ourIcons = new Icon[]{Git4ideaIcons.Ball0, Git4ideaIcons.Ball1, Git4ideaIcons.Ball2, Git4ideaIcons.Ball3, Git4ideaIcons.Ball4, Git4ideaIcons.Ball5, Git4ideaIcons.Ball6, Git4ideaIcons.Ball7};

    public GraphGutter(BigTableTableModel model) {
        this.myModel = model;
        this.myComponent = new MyComponent();
        this.myStyle = PresentationStyle.multicolour;
        this.myCurrentBranchColored = true;
    }

    public void setHeaderHeight(int headerHeight) {
        this.myHeaderHeight = 0;
    }

    public void setRowHeight(int rowHeight) {
        this.myRowHeight = rowHeight;
    }

    public MyComponent getComponent() {
        return this.myComponent;
    }

    public void setTableViewPort(JViewport tableViewPort) {
        this.myTableViewPort = tableViewPort;
    }

    public void setJBTable(JBTable jbTable) {
        this.myJBTable = jbTable;
    }

    public void start() {
        this.myStarted = true;
    }

    public PresentationStyle getStyle() {
        return this.myStyle;
    }

    public void setStyle(PresentationStyle style) {
        this.myStyle = style;
        this.myComponent.repaint();
    }

    public boolean isCurrentBranchColored() {
        return this.myCurrentBranchColored;
    }

    public void setCurrentBranchColored(boolean currentBranchColored) {
        this.myCurrentBranchColored = currentBranchColored;
    }

    public static enum PresentationStyle {
        multicolour{
            final Color[] ourColors = new Color[]{new Color(255, 128, 0), new Color(0, 102, 204), new Color(0, 130, 130), new Color(255, 45, 45), new Color(64, 64, 255), new Color(128, 64, 0), new Color(255, 0, 255), new Color(128, 0, 255)};

            @Override
            public Color getColorForWire(int wire) {
                return this.ourColors[wire % this.ourColors.length];
            }

            @Override
            public Icon getNodeIcon(int wire) {
                return ourIcons[wire % ourIcons.length];
            }
        }
        ,
        calm{
            final Color darker2 = new Color(35, 107, 178);
            final Color darker = new Color(255, 128, 0);

            @Override
            public Color getColorForWire(int wire) {
                return wire / 2 % 2 == 1 ? this.darker : this.darker2;
            }

            @Override
            public Icon getNodeIcon(int wire) {
                return wire / 2 % 2 == 1 ? ourIcons[0] : ourIcons[1];
            }
        };


        public abstract Color getColorForWire(int var1);

        public abstract Icon getNodeIcon(int var1);
    }

    class MyComponent
    extends JPanel {
        public static final int diameter = 7;

        MyComponent() {
            this.setDoubleBuffered(true);
            this.setBackground(UIUtil.getTableBackground());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MouseEvent mouseEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, (int)GraphGutter.this.myTableViewPort.getViewPosition().getY() + e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    GraphGutter.this.myJBTable.dispatchEvent((AWTEvent)mouseEvent);
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    GraphGutter.this.myTableViewPort.dispatchEvent(e);
                }
            });
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtil.getBorderColor()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (!GraphGutter.this.myStarted) {
                return preferredSize;
            }
            int totalWires = GraphGutter.this.myModel.getTotalWires();
            List<Integer> wiresGroups = this.getWiresGroups();
            return new Dimension(this.endPoint(totalWires, wiresGroups), preferredSize.height);
        }

        private int endPoint(int wireNumber, List<Integer> wiresGroups) {
            int add = 0;
            for (Integer wiresGroup : wiresGroups) {
                if (wiresGroup - 1 > wireNumber) continue;
                add += 3;
            }
            return (wireNumber + 1) * 8 + wireNumber * 2 + add + 2;
        }

        private void drawConnectorsFragment(final Graphics g, int idxFrom, int yOffset, final Set<Integer> wires, final @Nullable WireEventI event, final HashSet<Integer> selected, final List<Integer> wiresGroups, final Map<Integer, Set<Integer>> grey, final HashSet<Integer> wireModificationSet) {
            int rowYOffset = yOffset;
            for (int i = idxFrom; i < event.getCommitIdx(); ++i) {
                CommitI commitAt = GraphGutter.this.myModel.getCommitAt(i);
                if (commitAt == null) continue;
                int commitWire = GraphGutter.this.myModel.getCorrectedWire(commitAt);
                for (Integer wire : wires) {
                    this.verticalLine(g, selected, wiresGroups, grey, rowYOffset, i, wire, wireModificationSet, wire == commitWire);
                }
                rowYOffset += GraphGutter.this.myRowHeight;
            }
            CommitI commitAt1 = GraphGutter.this.myModel.getCommitAt(event.getCommitIdx());
            final int eventWire = commitAt1 == null ? -1 : GraphGutter.this.myModel.getCorrectedWire(commitAt1);
            final HashSet<Integer> skip = new HashSet<Integer>();
            final int finalRowYOffset = rowYOffset;
            Runnable drawEventRowLines = new Runnable(){

                @Override
                public void run() {
                    for (Integer wire : wires) {
                        if (skip.contains(wire)) continue;
                        MyComponent.this.verticalLine(g, selected, wiresGroups, grey, finalRowYOffset, event.getCommitIdx(), wire, wireModificationSet, wire == eventWire);
                    }
                }
            };
            if (commitAt1 == null) {
                drawEventRowLines.run();
                return;
            }
            g.setColor(this.getConnectorColor(g, selected, event.getCommitIdx(), eventWire, grey));
            int eventStartXPoint = this.startPoint(eventWire, wiresGroups) + 4;
            if (event.isStart() && event.isEnd()) {
                return;
            }
            if (event.isStart()) {
                skip.add(eventWire);
                this.doubleLine(g, eventStartXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2, eventStartXPoint, rowYOffset + GraphGutter.this.myRowHeight);
            }
            if (event.isEnd()) {
                skip.add(eventWire);
                this.doubleLine(g, eventStartXPoint, rowYOffset, eventStartXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2);
            }
            int[] commitsStarts = event.getCommitsStarts();
            int[] wireEnds = event.getWireEnds();
            if (wireEnds != null) {
                for (int end : wireEnds) {
                    if (end == -1) continue;
                    int wire = GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(end));
                    skip.add(wire);
                }
            }
            drawEventRowLines.run();
            if (commitsStarts != null) {
                for (int commitsStart : commitsStarts) {
                    if (commitsStart == -1) continue;
                    CommitI commitAt = GraphGutter.this.myModel.getCommitAt(commitsStart);
                    int wire = GraphGutter.this.myModel.getCorrectedWire(commitAt);
                    int startXPoint = this.startPoint(wire, wiresGroups) + 4;
                    g.setColor(this.getConnectorColor(g, selected, event.getCommitIdx(), eventWire, grey));
                    this.doubleLine(g, startXPoint, rowYOffset + GraphGutter.this.myRowHeight, eventStartXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2);
                }
            }
            if (wireEnds != null) {
                for (int end : wireEnds) {
                    if (end == -1) continue;
                    int wire = GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(end));
                    int startXPoint = this.startPoint(wire, wiresGroups) + 4;
                    g.setColor(this.getConnectorColor(g, selected, event.getCommitIdx(), wire, grey));
                    this.doubleLine(g, startXPoint, rowYOffset, eventStartXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2);
                }
            }
        }

        private void verticalLine(Graphics g, HashSet<Integer> selected, List<Integer> wiresGroups, Map<Integer, Set<Integer>> grey, int rowYOffset, int i, Integer wire, HashSet<Integer> wireModificationSet, boolean isCommitWire) {
            Color connectorColor;
            Color connectorStartColor = connectorColor = this.getConnectorColor(g, selected, i, wire, grey);
            if (isCommitWire && wireModificationSet.contains(i)) {
                connectorStartColor = OUTLINE_NOT_INCLUDED;
            }
            int startXPoint = this.startPoint(wire, wiresGroups) + 4;
            if (connectorColor.equals(connectorStartColor)) {
                g.setColor(connectorColor);
                this.doubleLine(g, startXPoint, rowYOffset, startXPoint, rowYOffset + GraphGutter.this.myRowHeight);
            } else {
                g.setColor(connectorStartColor);
                this.doubleLine(g, startXPoint, rowYOffset, startXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2);
                g.setColor(connectorColor);
                this.doubleLine(g, startXPoint, rowYOffset + GraphGutter.this.myRowHeight / 2, startXPoint, rowYOffset + GraphGutter.this.myRowHeight);
            }
        }

        private Color getConnectorStartColor(Graphics g, HashSet<Integer> selected, int i, Integer wire, Map<Integer, Set<Integer>> grey) {
            int prevIdx = GraphGutter.this.myModel.getPreviousAbsoluteIdx(i);
            if (prevIdx == -1) {
                return this.getConnectorColor(g, selected, i, wire, grey);
            }
            Set<Integer> integers = grey.get(prevIdx);
            if (integers == null || !integers.contains(wire)) {
                return OUTLINE_NOT_INCLUDED;
            }
            return selected.contains(i) ? Color.white : GraphGutter.this.myStyle.getColorForWire(wire);
        }

        private Color getConnectorColor(Graphics g, Set<Integer> selected, int i, Integer wire, Map<Integer, Set<Integer>> grey) {
            if (grey == null) {
                return selected.contains(i) ? Color.white : GraphGutter.this.myStyle.getColorForWire(wire);
            }
            Set<Integer> integers = grey.get(i);
            if (GraphGutter.this.myCurrentBranchColored && (integers == null || !integers.contains(wire))) {
                return OUTLINE_NOT_INCLUDED;
            }
            return selected.contains(i) ? Color.white : GraphGutter.this.myStyle.getColorForWire(wire);
        }

        private void doubleLine(Graphics g, int x1, int y1, int x2, int y2) {
            Color color = g.getColor();
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x1 + 1, y1, x2 + 1, y2);
            g.setColor(color);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
                if (!GraphGutter.this.myStarted) {
                    return;
                }
                Graphics graphics = g.create();
                try {
                    int height = this.getHeight();
                    int yOffset = (int)GraphGutter.this.myTableViewPort.getViewPosition().getY();
                    int integerPart = yOffset / GraphGutter.this.myRowHeight;
                    int firstCellPart = yOffset - integerPart * GraphGutter.this.myRowHeight;
                    int width = this.getWidth();
                    int upBound = firstCellPart == 0 ? 0 : -firstCellPart;
                    int idx = integerPart;
                    int lastIdx = idx + (this.getHeight() / GraphGutter.this.myRowHeight + 1);
                    int[] selectedRows = GraphGutter.this.myJBTable.getSelectedRows();
                    this.drawSelection(graphics, width, upBound += GraphGutter.this.myHeaderHeight, idx, lastIdx, selectedRows);
                    HashSet<Integer> selected = new HashSet<Integer>();
                    for (int selectedRow : selectedRows) {
                        selected.add(selectedRow);
                    }
                    List<Integer> wiresGroups = this.getWiresGroups();
                    this.drawRepoBounds(graphics, height, wiresGroups);
                    this.drawConnectors(graphics, lastIdx, upBound, idx, selected, wiresGroups);
                    this.drawPoints(graphics, lastIdx, upBound, idx, selected, wiresGroups);
                }
                finally {
                    graphics.dispose();
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }

        private List<Integer> getWiresGroups() {
            List<Integer> wiresGroups = GraphGutter.this.myModel.getWiresGroups();
            if (wiresGroups == null) {
                return Collections.emptyList();
            }
            int running = 0;
            for (int i = 0; i < wiresGroups.size(); ++i) {
                Integer integer = wiresGroups.get(i);
                wiresGroups.set(i, running + integer);
                running += integer.intValue();
            }
            return wiresGroups;
        }

        private void drawSelection(Graphics graphics, int width, int upBound, int idx, int lastIdx, int[] selectedRows) {
            for (int selectedRow : selectedRows) {
                if (selectedRow < idx || selectedRow > lastIdx) continue;
                graphics.setColor(UIUtil.getTableSelectionBackground());
                graphics.fillRect(0, upBound + (selectedRow - idx) * GraphGutter.this.myRowHeight + 1, width, GraphGutter.this.myRowHeight - 1);
            }
        }

        private void drawPoints(Graphics graphics, int lastIdx, int upBound, int idx, HashSet<Integer> selected, List<Integer> wiresGroups) {
            Color darker = new Color(35, 107, 178);
            Color fill = new Color(166, 220, 255);
            Gray fillNotIncluded = Gray._200;
            while (idx <= lastIdx && idx < GraphGutter.this.myModel.getRowCount()) {
                CommitI commitAt = GraphGutter.this.myModel.getCommitAt(idx);
                boolean contains = selected.contains(idx);
                boolean isInActiveRoots = GraphGutter.this.myModel.getActiveRoots().contains(commitAt.selectRepository(GraphGutter.this.myModel.getRootsHolder().getRoots()));
                if (!commitAt.holdsDecoration() && isInActiveRoots) {
                    int correctedWire = GraphGutter.this.myModel.getCorrectedWire(commitAt);
                    int startXPoint = this.startPoint(correctedWire, wiresGroups);
                    boolean inCurrentBranch = GraphGutter.this.myCurrentBranchColored ? GraphGutter.this.myModel.isInCurrentBranch(idx) : true;
                    Icon icon = inCurrentBranch ? GraphGutter.this.myStyle.getNodeIcon(correctedWire) : Git4ideaIcons.Greyball;
                    icon.paintIcon(this, graphics, startXPoint + 1, upBound + GraphGutter.this.myRowHeight / 2 - 3);
                }
                ++idx;
                upBound += GraphGutter.this.myRowHeight;
            }
        }

        private void drawConnectors(Graphics graphics, int lastIdx, int upBound, int idx, HashSet<Integer> selected, List<Integer> wiresGroups) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Map<VirtualFile, WireEventsIterator> groupIterators = GraphGutter.this.myModel.getGroupIterators(idx);
            for (Map.Entry<VirtualFile, WireEventsIterator> entry : groupIterators.entrySet()) {
                WireEventsIterator eventsIterator = entry.getValue();
                int idxFrom = idx;
                int yOff = upBound;
                HashSet<Integer> used = new HashSet<Integer>(eventsIterator.getFirstUsed());
                Iterator<WireEventI> iterator = eventsIterator.getWireEventsIterator();
                int repoCorrection = GraphGutter.this.myModel.getRepoCorrection(entry.getKey());
                HashSet<Integer> wireModificationSet = new HashSet<Integer>();
                Map<Integer, Set<Integer>> grey = GraphGutter.this.myModel.getGrey(entry.getKey(), idxFrom, lastIdx, repoCorrection, wireModificationSet);
                while (iterator.hasNext()) {
                    int[] commitsStarts;
                    int[] wireEnds;
                    WireEventI wireEvent = iterator.next();
                    if (wireEvent.getCommitIdx() >= idx) {
                        this.drawConnectorsFragment(graphics, idxFrom, yOff, used, wireEvent, selected, wiresGroups, grey, wireModificationSet);
                        int delta = wireEvent.getCommitIdx() + 1 - idxFrom;
                        delta = delta < 0 ? 0 : delta;
                        yOff += delta * GraphGutter.this.myRowHeight;
                        idxFrom = wireEvent.getCommitIdx() + 1;
                    }
                    if ((wireEnds = wireEvent.getWireEnds()) != null) {
                        for (int wireEnd : wireEnds) {
                            used.remove(GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(wireEnd)));
                        }
                    }
                    if (wireEvent.isEnd()) {
                        used.remove(GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(wireEvent.getCommitIdx())));
                    }
                    if ((commitsStarts = wireEvent.getCommitsStarts()) != null) {
                        for (int commitsStart : commitsStarts) {
                            if (commitsStart == -1) continue;
                            used.add(GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(commitsStart)));
                        }
                    }
                    if (wireEvent.isStart() && !wireEvent.isEnd()) {
                        used.add(GraphGutter.this.myModel.getCorrectedWire(GraphGutter.this.myModel.getCommitAt(wireEvent.getCommitIdx())));
                    }
                    if (wireEvent.getCommitIdx() <= lastIdx) continue;
                    break;
                }
                this.drawConnectorsFragment(graphics, idxFrom, yOff, used, new WireEvent(lastIdx, ArrayUtil.EMPTY_INT_ARRAY), selected, wiresGroups, grey, wireModificationSet);
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        private void drawRepoBounds(Graphics graphics, int height, List<Integer> wiresGroups) {
            graphics.setColor(UIUtil.getBorderColor());
            if (wiresGroups.size() > 1) {
                for (int i = 0; i < wiresGroups.size() - 1; ++i) {
                    int x1;
                    Integer integer = wiresGroups.get(i);
                    int n = x1 = integer == 0 ? 0 : this.endPoint(integer - 1, wiresGroups);
                    if (x1 > 0) {
                        x1 -= 3;
                    }
                    graphics.drawLine(x1, 0, x1, height);
                }
            }
        }

        private int startPoint(int correctedWire, List<Integer> wiresGroups) {
            return correctedWire == 0 ? 2 : this.endPoint(correctedWire - 1, wiresGroups);
        }
    }
}

