/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import java.util.ArrayList;
import java.util.List;

abstract class HighlightingRendererBase {
    private final List<String> mySearchContext = new ArrayList<String>();

    HighlightingRendererBase() {
    }

    public void setSearchContext(List<String> list) {
        this.mySearchContext.clear();
        this.mySearchContext.addAll(list);
    }

    protected abstract void usual(String var1);

    protected abstract void highlight(String var1);

    void tryHighlight(String text) {
        String lower = text.toLowerCase();
        int idxFrom = 0;
        while (idxFrom < text.length()) {
            boolean adjusted = false;
            int adjustedIdx = text.length() + 1;
            int adjLen = 0;
            for (String word : this.mySearchContext) {
                int next = lower.indexOf(word, idxFrom);
                if (next == -1 || adjustedIdx <= next) continue;
                adjustedIdx = next;
                adjLen = word.length();
                adjusted = true;
            }
            if (adjusted) {
                if (idxFrom != adjustedIdx) {
                    this.usual(text.substring(idxFrom, adjustedIdx));
                }
                idxFrom = adjustedIdx + adjLen;
                this.highlight(text.substring(adjustedIdx, idxFrom));
                continue;
            }
            this.usual(text.substring(idxFrom));
            return;
        }
    }

    public boolean isEmpty() {
        return this.mySearchContext == null || this.mySearchContext.isEmpty();
    }
}

