/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Ticket;
import com.intellij.util.containers.Convertor;
import git4idea.history.browser.ChangesFilter;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.LowLevelAccessImpl;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.Commit;
import git4idea.history.wholeTree.CommitHashPlusParents;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.DetailsCache;
import git4idea.history.wholeTree.GitCommitToCommitConvertor;
import git4idea.history.wholeTree.LoadAlgorithm;
import git4idea.history.wholeTree.LoadGrowthController;
import git4idea.history.wholeTree.LoaderAndRefresher;
import git4idea.history.wholeTree.Mediator;
import git4idea.history.wholeTree.MultipleRepositoryCommitDecorator;
import git4idea.history.wholeTree.RootsHolder;
import git4idea.history.wholeTree.StepType;
import git4idea.history.wholeTree.UsersIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LoaderAndRefresherImpl
implements LoaderAndRefresher<CommitHashPlusParents> {
    private static final int ourFirstLoadCount = 15;
    private static final int ourPreload = !LoaderAndRefresherImpl.parameterCheck(Integer.getInteger("git.log.preload.size")) ? 100 : Integer.getInteger("git.log.preload.size");
    private final Collection<String> myStartingPoints;
    private final Ticket myTicket;
    private final Collection<ChangesFilter.Filter> myFilters;
    private final Mediator myMediator;
    private final DetailsCache myDetailsCache;
    private final Project myProject;
    private final Getter<Boolean> myProgressAnalog;
    private BufferedListConsumer<CommitHashPlusParents> myBufferConsumer;
    private Consumer<List<CommitHashPlusParents>> myRealConsumer;
    private final MyRootHolder myRootHolder;
    private final UsersIndex myUsersIndex;
    private final boolean myLoadParents;
    private RepeatingLoadConsumer<CommitHashPlusParents> myRepeatingLoadConsumer;
    private LowLevelAccessImpl myLowLevelAccess;
    private SymbolicRefsI mySymbolicRefs;
    private final LoadGrowthController.ID myId;
    private final boolean myHaveStructureFilter;
    @NotNull
    private volatile StepType myStepType;
    private final boolean myTopoOrder;

    private static boolean parameterCheck(Integer i) {
        return i != null && i > 0;
    }

    public LoaderAndRefresherImpl(Ticket ticket, Collection<ChangesFilter.Filter> filters, Mediator mediator, Collection<String> startingPoints, DetailsCache detailsCache, Project project, MyRootHolder rootHolder, UsersIndex usersIndex, LoadGrowthController.ID id, boolean haveStructureFilter, boolean topoOrder, boolean haveDisordering) {
        this.myRootHolder = rootHolder;
        this.myUsersIndex = usersIndex;
        this.myId = id;
        this.myHaveStructureFilter = haveStructureFilter;
        this.myTopoOrder = topoOrder;
        this.myLoadParents = !haveDisordering;
        this.myTicket = ticket;
        this.myFilters = filters;
        this.myMediator = mediator;
        this.myStartingPoints = startingPoints;
        this.myDetailsCache = detailsCache;
        this.myStepType = StepType.CONTINUE;
        this.myProject = project;
        this.myProgressAnalog = new Getter<Boolean>(){

            public Boolean get() {
                return LoaderAndRefresherImpl.this.isInterrupted();
            }
        };
        this.myLowLevelAccess = new LowLevelAccessImpl(this.myProject, this.myRootHolder.getRoot());
        this.myRealConsumer = new Consumer<List<CommitHashPlusParents>>(){

            public void consume(List<CommitHashPlusParents> list) {
                if (LoaderAndRefresherImpl.this.isInterrupted()) {
                    return;
                }
                ArrayList<CommitI> buffer = new ArrayList<CommitI>();
                ArrayList<List<AbstractHash>> parents = LoaderAndRefresherImpl.this.myLoadParents ? new ArrayList<List<AbstractHash>>() : null;
                for (CommitHashPlusParents commitHashPlusParents : list) {
                    CommitI commit = new Commit(commitHashPlusParents.getHash(), commitHashPlusParents.getTime(), LoaderAndRefresherImpl.this.myUsersIndex.put(commitHashPlusParents.getAuthorName()));
                    commit = LoaderAndRefresherImpl.this.myRootHolder.decorateByRoot(commit);
                    buffer.add(commit);
                    if (!LoaderAndRefresherImpl.this.myLoadParents) continue;
                    parents.add(commitHashPlusParents.getParents());
                }
                StepType stepType = LoaderAndRefresherImpl.this.myMediator.appendResult(LoaderAndRefresherImpl.this.myTicket, buffer, parents, LoaderAndRefresherImpl.this.myRootHolder.getRoot(), true);
                if (!StepType.FINISHED.equals((Object)LoaderAndRefresherImpl.this.myStepType)) {
                    LoaderAndRefresherImpl.this.myStepType = stepType;
                }
            }
        };
        this.myBufferConsumer = new BufferedListConsumer(15, this.myRealConsumer, 400);
        this.myRepeatingLoadConsumer = new RepeatingLoadConsumer(this.myProject, this.myBufferConsumer.asConsumer());
    }

    @Override
    public void interrupt() {
        this.myStepType = StepType.STOP;
    }

    @Override
    public boolean isInterrupted() {
        return StepType.STOP.equals((Object)this.myStepType);
    }

    @Override
    public VirtualFile getRoot() {
        return this.myRootHolder.getRoot();
    }

    @Override
    public StepType flushIntoUI() {
        this.myBufferConsumer.flush();
        if (StepType.FINISHED.equals((Object)this.myStepType)) {
            this.myMediator.oneFinished();
        }
        return this.myStepType;
    }

    @Override
    public LoadAlgorithm.Result<CommitHashPlusParents> load(LoadAlgorithm.LoadType loadType, long continuation) {
        long start;
        boolean shouldFull;
        if (this.isInterrupted()) {
            return new LoadAlgorithm.Result<CommitHashPlusParents>(true, 0L, this.myRepeatingLoadConsumer.getLast());
        }
        this.myRepeatingLoadConsumer.reset();
        int count = 340;
        boolean bl = shouldFull = !this.myHaveStructureFilter;
        if (LoadAlgorithm.LoadType.TEST.equals((Object)loadType)) {
            count = 15;
        } else if (LoadAlgorithm.LoadType.SHORT.equals((Object)loadType) || LoadAlgorithm.LoadType.SHORT_START.equals((Object)loadType)) {
            shouldFull = false;
        } else if (LoadAlgorithm.LoadType.FULL_PREVIEW.equals((Object)loadType)) {
            count = ourPreload;
        }
        boolean isOver = false;
        while (true) {
            start = System.currentTimeMillis();
            this.step(count, shouldFull, continuation);
            if (this.isInterrupted()) {
                return new LoadAlgorithm.Result<CommitHashPlusParents>(true, 0L, this.myRepeatingLoadConsumer.getLast());
            }
            List<AbstractHash> lastParents = this.myRepeatingLoadConsumer.getLast() == null ? null : this.myRepeatingLoadConsumer.getLast().getParents();
            boolean bl2 = isOver = lastParents == null || lastParents.isEmpty() || this.myRepeatingLoadConsumer.getTotalRecordsInPack() < count;
            if (isOver) {
                this.myId.finished();
                this.myStepType = StepType.FINISHED;
                break;
            }
            if (this.myRepeatingLoadConsumer.sincePoint() != 0) break;
            count *= 2;
            this.myRepeatingLoadConsumer.reset();
        }
        long end = System.currentTimeMillis();
        if (!isOver && this.myRepeatingLoadConsumer.getLast() != null) {
            this.myId.registerTime(this.myRepeatingLoadConsumer.getLast().getTime());
        }
        return new LoadAlgorithm.Result<CommitHashPlusParents>(isOver, end - start, this.myRepeatingLoadConsumer.getLast());
    }

    private void step(int count, boolean shouldFull, long continuation) {
        if (shouldFull) {
            this.loadFull(count, continuation);
        } else {
            this.loadShort(continuation, count);
        }
    }

    @Override
    public void setSymbolicRefs(SymbolicRefsI symbolicRefs) {
        this.mySymbolicRefs = symbolicRefs;
    }

    private void loadFull(int count, long continuation) {
        try {
            Collection<ChangesFilter.Filter> filters = this.addContinuation(continuation);
            this.myLowLevelAccess.loadCommits(this.myStartingPoints, Collections.<String>emptyList(), filters, new AsynchConsumer<GitHeavyCommit>(){

                public void consume(GitHeavyCommit gitCommit) {
                    if (gitCommit.getParentsHashes().size() <= 1) {
                        LoaderAndRefresherImpl.this.myDetailsCache.acceptAnswer(Collections.singleton(gitCommit), LoaderAndRefresherImpl.this.myRootHolder.getRoot());
                    }
                    LoaderAndRefresherImpl.this.myRepeatingLoadConsumer.consume(GitCommitToCommitConvertor.getInstance().convert(gitCommit));
                }

                public void finished() {
                }
            }, count, this.myProgressAnalog, this.mySymbolicRefs, this.myTopoOrder);
        }
        catch (VcsException e) {
            this.myMediator.acceptException(e);
        }
    }

    private Collection<ChangesFilter.Filter> addContinuation(long continuation) {
        Collection<ChangesFilter.Filter> filters;
        if (continuation > 0L) {
            filters = new ArrayList<ChangesFilter.Filter>(this.myFilters);
            filters.add(new ChangesFilter.BeforeDate(new Date(continuation)));
        } else {
            filters = this.myFilters;
        }
        return filters;
    }

    private void appendCommits(List<CommitI> result, List<List<AbstractHash>> parents, List<GitHeavyCommit> commits) {
        for (GitHeavyCommit commit : commits) {
            Commit commitObj = new Commit(commit.getShortHash().getString(), commit.getDate().getTime(), this.myUsersIndex.put(commit.getAuthor()));
            if (parents != null) {
                Set<String> parentsHashes = commit.getParentsHashes();
                parents.add(ObjectsConvertor.convert(parentsHashes, (Convertor)new Convertor<String, AbstractHash>(){

                    public AbstractHash convert(String o) {
                        return AbstractHash.create(o);
                    }
                }));
            }
            result.add(this.myRootHolder.decorateByRoot(commitObj));
        }
    }

    private void loadShort(long continuation, int maxCount) {
        Collection<ChangesFilter.Filter> filters = this.addContinuation(continuation);
        try {
            this.myLowLevelAccess.loadHashesWithParents(this.myStartingPoints, filters, this.myRepeatingLoadConsumer, this.myProgressAnalog, maxCount, this.myTopoOrder);
        }
        catch (VcsException e) {
            this.myMediator.acceptException(e);
        }
    }

    private static class RepeatingLoadConsumer<T>
    implements AsynchConsumer<T> {
        private final Project myProject;
        private final Consumer<T> myConsumer;
        private int myCnt;
        private T myLastT;
        private int mySavedPoint;
        private int myTotalRecordsInPack;
        private boolean myPointMeet;

        private RepeatingLoadConsumer(Project project, Consumer<T> consumer) {
            this.myProject = project;
            this.myConsumer = consumer;
            this.mySavedPoint = 0;
            this.myCnt = 0;
            this.myLastT = null;
            this.myPointMeet = false;
        }

        public int reset() {
            this.mySavedPoint = this.myCnt;
            this.myTotalRecordsInPack = 0;
            this.myPointMeet = false;
            return this.mySavedPoint;
        }

        public int getTotalRecordsInPack() {
            return this.myTotalRecordsInPack;
        }

        public int sincePoint() {
            return this.myCnt - this.mySavedPoint;
        }

        public T getLast() {
            return this.myLastT;
        }

        public void consume(T t) {
            if (!this.myProject.isDefault() && !this.myProject.isOpen() || this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            ++this.myTotalRecordsInPack;
            if (this.myLastT == null) {
                this.myPointMeet = true;
            }
            if (!this.myPointMeet) {
                this.myPointMeet = t.equals(this.myLastT);
            } else {
                ++this.myCnt;
                this.myConsumer.consume(t);
                this.myLastT = t;
            }
        }

        public void finished() {
        }
    }

    static class ManyCaseHolder
    implements MyRootHolder {
        private final RootsHolder myRootsHolder;
        private final int myNum;

        ManyCaseHolder(int num, RootsHolder rootsHolder) {
            this.myNum = num;
            this.myRootsHolder = rootsHolder;
        }

        @Override
        public CommitI decorateByRoot(CommitI commitI) {
            return new MultipleRepositoryCommitDecorator(commitI, this.myNum);
        }

        @Override
        public VirtualFile getRoot() {
            return this.myRootsHolder.get(this.myNum);
        }
    }

    static class OneRootHolder
    implements MyRootHolder {
        private final VirtualFile myVirtualFile;

        OneRootHolder(VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
        }

        @Override
        public CommitI decorateByRoot(CommitI commitI) {
            return commitI;
        }

        @Override
        public VirtualFile getRoot() {
            return this.myVirtualFile;
        }
    }

    static interface MyRootHolder {
        public VirtualFile getRoot();

        public CommitI decorateByRoot(CommitI var1);
    }
}

