/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Ticket;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import git4idea.history.browser.CachedRefs;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.Commit;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.CommitIComparator;
import git4idea.history.wholeTree.DetailsLoader;
import git4idea.history.wholeTree.GitCommitsSequentially;
import git4idea.history.wholeTree.GitLogFilters;
import git4idea.history.wholeTree.LoadGrowthController;
import git4idea.history.wholeTree.Loader;
import git4idea.history.wholeTree.Mediator;
import git4idea.history.wholeTree.MultipleRepositoryCommitDecorator;
import git4idea.history.wholeTree.RootsHolder;
import git4idea.history.wholeTree.SelectorList;
import git4idea.history.wholeTree.SortListsByFirst;
import git4idea.history.wholeTree.StepType;
import git4idea.history.wholeTree.UIRefresh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MediatorImpl
implements Mediator {
    private boolean myHaveRestrictingFilters;
    private final Ticket myTicket;
    private final Project myProject;
    private final GitCommitsSequentially myGitCommitsSequentially;
    private TableWrapper myTableWrapper;
    private UIRefresh myUIRefresh;
    private Loader myLoader;
    private final LoadGrowthController myController;
    private Map<VirtualFile, SequenceSupportBuffer> mySequenceBuffers;
    private DetailsLoader myDetailsLoader;
    @NonNls
    public static final String GIT_LOG_PAGE_SIZE = "git.log.page.size";
    public static final int ourDefaultPageSize = 1000;
    public static final int ourManyLoadedStep = !MediatorImpl.pageSizeOk(Integer.getInteger("git.log.page.size")) ? 1000 : Integer.getInteger("git.log.page.size");

    public MediatorImpl(Project project, GitCommitsSequentially gitCommitsSequentially) {
        this.myProject = project;
        this.myGitCommitsSequentially = gitCommitsSequentially;
        this.myTicket = new Ticket();
        this.myController = new LoadGrowthController();
        this.mySequenceBuffers = new HashMap<VirtualFile, SequenceSupportBuffer>();
        this.myHaveRestrictingFilters = false;
    }

    @Override
    public StepType appendResult(Ticket ticket, List<CommitI> result, @Nullable List<List<AbstractHash>> parents, VirtualFile root, boolean checkForSequential) {
        if (!this.myTicket.equals((Object)ticket)) {
            return StepType.STOP;
        }
        if (!result.isEmpty()) {
            this.myTableWrapper.appendResult(ticket, result, parents);
        }
        if (this.myTableWrapper.isSuspend()) {
            return StepType.PAUSE;
        }
        return StepType.CONTINUE;
    }

    @Override
    public void reportSymbolicRefs(final Ticket ticket, final VirtualFile root, final CachedRefs symbolicRefs) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!MediatorImpl.this.myTicket.equals((Object)ticket)) {
                    return;
                }
                MediatorImpl.this.myDetailsLoader.reportRefs(root, symbolicRefs);
                MediatorImpl.this.myUIRefresh.reportSymbolicRefs(root, symbolicRefs);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void continueLoading() {
        this.myTableWrapper.clearSuspend();
        this.myLoader.resume();
    }

    @Override
    public void forceStop() {
        this.myTableWrapper.forceStop();
    }

    @Override
    public void acceptException(VcsException e) {
        this.myUIRefresh.acceptException((Exception)((Object)e));
    }

    @Override
    public void acceptStashHead(Ticket ticket, VirtualFile root, Couple<AbstractHash> hash) {
        if (!this.myTicket.equals((Object)ticket)) {
            return;
        }
        this.myUIRefresh.reportStash(root, hash);
    }

    @Override
    public void oneFinished() {
        if (this.myController.isEmpty()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    MediatorImpl.this.myUIRefresh.finished();
                    MediatorImpl.this.myTableWrapper.finished();
                }
            });
        }
    }

    @Override
    public void reloadSetFixed(final Map<AbstractHash, Long> starred, RootsHolder rootsHolder) {
        this.myTicket.increment();
        ArrayList<AbstractHash> hash = new ArrayList<AbstractHash>(starred.keySet());
        Collections.sort(hash, new Comparator<AbstractHash>(){

            @Override
            public int compare(AbstractHash o1, AbstractHash o2) {
                return Comparing.compare((Comparable)((Comparable)starred.get(o2)), (Comparable)((Comparable)starred.get(o1)));
            }
        });
        boolean multipleRoots = rootsHolder.multipleRoots();
        ArrayList<CommitI> filtered = new ArrayList<CommitI>();
        ArrayList<AbstractHash> missing = new ArrayList<AbstractHash>();
        int cInHashes = 0;
        int count = this.myTableWrapper.myTableModel.getRowCount();
        for (int i = 0; i < count && hash.size() > cInHashes; ++i) {
            CommitI at = this.myTableWrapper.myTableModel.getCommitAt(i);
            if (at.holdsDecoration()) continue;
            AbstractHash obj = (AbstractHash)hash.get(cInHashes);
            if (at.getHash().equals(obj)) {
                Commit commit = new Commit(at.getHash().getString(), at.getTime(), at.getAuthorIdx());
                if (multipleRoots) {
                    filtered.add(new MultipleRepositoryCommitDecorator(commit, at.selectRepository(SelectorList.getInstance())));
                } else {
                    filtered.add(commit);
                }
                ++cInHashes;
                continue;
            }
            if (starred.get(obj) <= at.getTime()) continue;
            missing.add(obj);
            ++cInHashes;
        }
        while (cInHashes < hash.size()) {
            missing.add((AbstractHash)hash.get(cInHashes));
            ++cInHashes;
        }
        this.myTableWrapper.reset(false, true);
        this.myController.reset();
        this.myHaveRestrictingFilters = true;
        if (!filtered.isEmpty()) {
            this.myTableWrapper.appendResult(this.myTicket.copy(), filtered, Collections.<List<AbstractHash>>emptyList());
        }
        if (!missing.isEmpty()) {
            GitLogFilters filters = new GitLogFilters(null, null, null, null, ObjectsConvertor.convert(missing, (Convertor)new Convertor<AbstractHash, String>(){

                public String convert(AbstractHash o) {
                    return o.getString();
                }
            }));
            filters.setUseOnlyHashes(true);
            this.myLoader.loadSkeleton(this.myTicket.copy(), rootsHolder, Collections.<String>emptyList(), filters, this.myController, true);
        } else {
            this.myUIRefresh.finished();
            this.myTableWrapper.finished();
        }
    }

    @Override
    public void reload(RootsHolder rootsHolder, Collection<String> startingPoints, Collection<String> endPoints, GitLogFilters filters, boolean topoOrder) {
        this.myTicket.increment();
        this.myTableWrapper.reset(!filters.haveDisordering(), startingPoints.isEmpty());
        this.myController.reset();
        this.myHaveRestrictingFilters = filters.haveCommitterOrCommentFilters();
        this.myLoader.loadSkeleton(this.myTicket.copy(), rootsHolder, startingPoints, filters, this.myController, topoOrder);
    }

    public void setLoader(Loader loader) {
        this.myLoader = loader;
    }

    public void setTableModel(BigTableTableModel tableWrapper) {
        this.myTableWrapper = new TableWrapper(tableWrapper);
    }

    public void setUIRefresh(UIRefresh UIRefresh2) {
        this.myUIRefresh = UIRefresh2;
    }

    public void setDetailsLoader(DetailsLoader loader) {
        this.myDetailsLoader = loader;
    }

    private static boolean pageSizeOk(Integer size) {
        return size != null && size > 0;
    }

    private int getLoadSize() {
        return this.myHaveRestrictingFilters ? ourManyLoadedStep / 2 : ourManyLoadedStep;
    }

    private class TableWrapper {
        private int myRecentCut;
        private volatile boolean mySuspend;
        private boolean myForcedStop;
        private final BigTableTableModel myTableModel;

        public TableWrapper(BigTableTableModel tableModel) {
            this.myTableModel = tableModel;
            this.myRecentCut = 0;
            this.mySuspend = false;
            this.myForcedStop = false;
        }

        public boolean isSuspend() {
            return this.mySuspend;
        }

        public void appendResult(final Ticket ticket, final List<CommitI> result, final @Nullable List<List<AbstractHash>> parents) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int nextCut;
                    if (!MediatorImpl.this.myTicket.equals((Object)ticket)) {
                        return;
                    }
                    TableWrapper.this.myTableModel.appendData(result, parents);
                    if (MediatorImpl.this.myController.isEmpty()) {
                        TableWrapper.this.myTableModel.restore();
                        TableWrapper.this.mySuspend = false;
                    } else if (!TableWrapper.this.myForcedStop && (nextCut = TableWrapper.this.nextCut()) + 1 < TableWrapper.this.myTableModel.getTrueCount() && nextCut > TableWrapper.this.myRecentCut) {
                        TableWrapper.this.mySuspend = true;
                        TableWrapper.this.myRecentCut = nextCut;
                        TableWrapper.this.myTableModel.cutAt(TableWrapper.this.myRecentCut);
                    }
                    MediatorImpl.this.myUIRefresh.linesReloaded(TableWrapper.this.mySuspend);
                    if (MediatorImpl.this.myController.isEmpty()) {
                        MediatorImpl.this.myUIRefresh.finished();
                    }
                }
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        private int nextCut() {
            CommitI commitAt;
            int nextCut = this.myRecentCut;
            while ((commitAt = this.myTableModel.getCommitAt(nextCut + MediatorImpl.this.getLoadSize())) != null && MediatorImpl.this.myController.isEverybodyLoadedMoreThan(commitAt.getTime())) {
                nextCut += MediatorImpl.this.getLoadSize();
            }
            return nextCut;
        }

        public void finished() {
            this.mySuspend = false;
            this.myForcedStop = false;
            this.myTableModel.restore();
        }

        public void clearSuspend() {
            this.mySuspend = false;
            this.myForcedStop = false;
        }

        public void reset(boolean noFilters, boolean noStartingPoints) {
            this.mySuspend = false;
            this.myForcedStop = false;
            this.myRecentCut = 0;
            this.myTableModel.clear(noFilters, noStartingPoints);
        }

        public void forceStop() {
            this.mySuspend = true;
            this.myForcedStop = true;
        }
    }

    private static class SequenceSupportBuffer {
        private CommitI myTail;
        private List<CommitI> myCommits;
        private List<List<AbstractHash>> myParents;
        private final TableWrapper myTableWrapper;
        private final GitCommitsSequentially myCommitsSequentially;
        private final VirtualFile myRoot;

        private SequenceSupportBuffer(TableWrapper tableWrapper, GitCommitsSequentially commitsSequentially, VirtualFile root) {
            this.myTableWrapper = tableWrapper;
            this.myCommitsSequentially = commitsSequentially;
            this.myRoot = root;
            this.myCommits = Collections.emptyList();
            this.myParents = Collections.emptyList();
        }

        public void appendResult(Ticket ticket, final List<CommitI> result, @Nullable List<List<AbstractHash>> parents) throws VcsException {
            assert (result.size() == parents.size());
            result.addAll(this.myCommits);
            parents.addAll(this.myParents);
            SortListsByFirst<CommitI> sortListsByFirst = new SortListsByFirst<CommitI>(result, CommitIComparator.getInstance());
            sortListsByFirst.sortAnyOther(parents);
            final long commitTime = this.myTail == null ? result.get(0).getTime() : this.myTail.getTime();
            final Ref cnt = new Ref((Object)(this.myTail == null ? 0 : -1));
            this.myCommitsSequentially.iterateDescending(this.myRoot, commitTime, new Processor<Pair<AbstractHash, Long>>(){
                boolean startFound = false;

                public boolean process(Pair<AbstractHash, Long> pair) {
                    if ((Integer)cnt.get() == -1) {
                        if (!((AbstractHash)pair.getFirst()).getString().startsWith(SequenceSupportBuffer.this.myTail.getHash().getString())) {
                            System.out.println("!!!!!!!!! (1) pair: " + ((AbstractHash)pair.getFirst()).getString() + " commit (" + cnt.get() + "): " + SequenceSupportBuffer.this.myTail.getHash().getString());
                            return !this.startFound ? (Long)pair.getSecond() == commitTime : false;
                        }
                        cnt.set((Object)0);
                        this.startFound = true;
                        return true;
                    }
                    if (!((AbstractHash)pair.getFirst()).getString().startsWith(((CommitI)result.get((Integer)cnt.get())).getHash().getString())) {
                        System.out.println("(2) pair: " + ((AbstractHash)pair.getFirst()).getString() + " commit (" + cnt.get() + "): " + ((CommitI)result.get((Integer)cnt.get())).getHash().getString());
                        return !this.startFound ? (Long)pair.getSecond() == commitTime : false;
                    }
                    cnt.set((Object)((Integer)cnt.get() + 1));
                    this.startFound = true;
                    return (Integer)cnt.get() < result.size();
                }
            });
            this.myCommits = new ArrayList<CommitI>(result.subList((Integer)cnt.get(), result.size()));
            this.myParents = new ArrayList<List<AbstractHash>>(parents.subList((Integer)cnt.get(), parents.size()));
            if ((Integer)cnt.get() > 0) {
                this.myTableWrapper.appendResult(ticket, result.subList(0, (Integer)cnt.get()), parents.subList(0, (Integer)cnt.get()));
                this.myTail = result.get((Integer)cnt.get() - 1);
            }
        }
    }
}

