/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.vcs.Ring;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ReadonlyList;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.WireEventsListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SkeletonBuilder {
    private final WireEventsListener mySkeleton;
    private final MultiMap<AbstractHash, WaitingItem> myAwaitingParents;
    private final MultiMap<Integer, WaitingItem> myBackIndex;
    private final Ring.IntegerRing myRing;
    private final BidirectionalMap<Integer, Integer> mySeizedWires;
    private final BidirectionalMap<Integer, AbstractHash> myFutureSeizedWires;
    private final Convertor<Integer, List<Integer>> myFutureConvertor;
    private int myMaxWireNum;

    public SkeletonBuilder(WireEventsListener treeNavigation) {
        this.mySkeleton = treeNavigation;
        this.myAwaitingParents = new MultiMap();
        this.myBackIndex = new MultiMap();
        this.myRing = new Ring.IntegerRing();
        this.mySeizedWires = new BidirectionalMap();
        this.myFutureSeizedWires = new BidirectionalMap();
        this.myFutureConvertor = new Convertor<Integer, List<Integer>>(){

            public List<Integer> convert(Integer o) {
                return SkeletonBuilder.this.getFutureWireStarts(o);
            }
        };
        this.myMaxWireNum = 0;
    }

    public void consume(CommitI commitI, List<AbstractHash> parents, ReadonlyList<CommitI> commits, int rowCount) {
        int wireNumber = -1;
        this.myFutureSeizedWires.removeValue((Object)commitI.getHash());
        Collection awaiting = this.myAwaitingParents.remove((Object)commitI.getHash());
        if (awaiting != null) {
            List awaitingList = (List)awaiting;
            if (awaitingList.size() > 1) {
                Collections.sort(awaitingList, CommitsComparator.getInstance());
            }
            SmartList willReturnTheirWires = new SmartList();
            for (WaitingItem waiting : awaitingList) {
                Collection waitingCommits = this.myBackIndex.get((Object)waiting.myIdx);
                waitingCommits.remove(waiting);
                if (waitingCommits.isEmpty()) {
                    this.myBackIndex.remove((Object)waiting.myIdx);
                }
                if (wireNumber == -1) {
                    wireNumber = waiting.getWire();
                } else assert (wireNumber == waiting.getWire());
                CommitI waitingI = (CommitI)commits.get(waiting.myIdx);
                if (waiting.isMerge()) {
                    this.mySkeleton.addStartToEvent(waiting.myIdx, rowCount, waiting.getWire());
                }
                Integer seized = (Integer)this.mySeizedWires.get((Object)waitingI.getWireNumber());
                AbstractHash something = (AbstractHash)this.myFutureSeizedWires.get((Object)waitingI.getWireNumber());
                if (seized == null || seized != waiting.myIdx || waitingI.getWireNumber() == wireNumber || something != null) continue;
                willReturnTheirWires.add(waiting);
            }
            for (WaitingItem waitingItem : willReturnTheirWires) {
                CommitI waitingI = (CommitI)commits.get(waitingItem.myIdx);
                this.myRing.back((Comparable)Integer.valueOf(waitingI.getWireNumber()));
                this.mySeizedWires.remove((Object)waitingI.getWireNumber());
                this.mySkeleton.parentWireEnds(rowCount, waitingItem.myIdx);
            }
            if (awaitingList.size() > 1) {
                int[] ends = new int[awaitingList.size()];
                for (int i = 0; i < awaitingList.size(); ++i) {
                    WaitingItem waiting = (WaitingItem)awaitingList.get(i);
                    ends[i] = waiting.myIdx;
                }
                this.mySkeleton.setEnds(rowCount, ends);
            }
        } else {
            wireNumber = (Integer)this.myRing.getFree();
            this.mySkeleton.wireStarts(rowCount);
            this.mySkeleton.setEnds(rowCount, new int[]{-1});
        }
        this.mySeizedWires.put((Object)wireNumber, (Object)rowCount);
        commitI.setWireNumber(wireNumber);
        this.myMaxWireNum = Math.max(this.myMaxWireNum, (Integer)this.myRing.getMaxNumber());
        if (parents.isEmpty()) {
            this.mySkeleton.wireEnds(rowCount);
            this.myRing.back((Comparable)Integer.valueOf(wireNumber));
            this.mySeizedWires.remove((Object)wireNumber);
        } else {
            boolean selfUsed = false;
            ArrayList<Integer> parentWires = new ArrayList<Integer>();
            for (AbstractHash parent : parents) {
                WaitingItem item;
                Collection existing = this.myAwaitingParents.get((Object)parent);
                if (existing != null && !existing.isEmpty()) {
                    int wire = ((WaitingItem)existing.iterator().next()).getWire();
                    item = new WaitingItem(rowCount, wire, parents.size() > 1);
                    parentWires.add(wire);
                } else {
                    Integer parentWire;
                    if (!selfUsed) {
                        parentWire = wireNumber;
                        selfUsed = true;
                    } else {
                        parentWire = (Integer)this.myRing.getFree();
                        this.mySkeleton.wireStarts(rowCount);
                    }
                    parentWires.add(parentWire);
                    this.myFutureSeizedWires.put((Object)parentWire, (Object)parent);
                    item = new WaitingItem(rowCount, parentWire, parents.size() > 1);
                }
                this.myAwaitingParents.putValue((Object)parent, (Object)item);
                this.myBackIndex.putValue((Object)item.myIdx, (Object)item);
            }
            if (parents.size() > 1) {
                this.mySkeleton.setWireStartsNumber(rowCount, parentWires.toArray(new Integer[parentWires.size()]));
            }
        }
    }

    public int getMaxWireNum() {
        return this.myMaxWireNum;
    }

    public List<Integer> getFutureWireStarts(int idx) {
        Collection waitingItems = this.myBackIndex.get((Object)idx);
        if (waitingItems == null || waitingItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (WaitingItem item : waitingItems) {
            result.add(item.getWire());
        }
        return result;
    }

    public Convertor<Integer, List<Integer>> getFutureConvertor() {
        return this.myFutureConvertor;
    }

    private static class WaitingItem {
        private int myIdx;
        private int myWire;
        private boolean myIsMerge;

        private WaitingItem(int idx, int wire, boolean isMerge) {
            this.myIdx = idx;
            this.myWire = wire;
            this.myIsMerge = isMerge;
        }

        public boolean isMerge() {
            return this.myIsMerge;
        }

        public int getIdx() {
            return this.myIdx;
        }

        public int getWire() {
            return this.myWire;
        }
    }

    private static class CommitsComparator
    implements Comparator<WaitingItem> {
        private static final CommitsComparator ourInstance = new CommitsComparator();

        private CommitsComparator() {
        }

        public static CommitsComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(WaitingItem wc1, WaitingItem wc2) {
            return new Integer(wc1.getWire()).compareTo(wc2.getWire());
        }
    }
}

