/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.vfs.VirtualFile;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.history.wholeTree.BigTableTableModel;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.WireEventI;
import git4idea.history.wholeTree.WireEventsIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class TreeHighlighter {
    private AbstractHash myPoint;
    private final VirtualFile myRoot;
    private int myInitIdx;
    private int myIdx;
    private final Set<AbstractHash> myParents;
    private final BigTableTableModel myModel;
    private final Set<Integer> myIncludedWires;
    private final boolean mySingleRoot;
    private boolean myInitialized;
    private static final int ourIndexInterval = 200;
    private final TreeMap<Integer, Set<Integer>> myIndexOfGrey;
    private final TreeMap<Integer, Set<Integer>> myIndexOfGreyNotReady;
    private boolean myDumb;

    public TreeHighlighter(BigTableTableModel model, VirtualFile root, int idx) {
        this.myModel = model;
        this.myDumb = false;
        this.myRoot = root;
        this.myInitIdx = idx;
        this.myInitialized = false;
        this.myIndexOfGrey = new TreeMap();
        this.myIndexOfGreyNotReady = new TreeMap();
        this.myParents = new HashSet<AbstractHash>();
        this.myIncludedWires = new HashSet<Integer>();
        this.mySingleRoot = this.myModel.getRootsHolder().getRoots().size() == 1;
    }

    public void setPoint(AbstractHash point) {
        this.myDumb = false;
        this.myPoint = point;
        this.myParents.clear();
        this.myIndexOfGrey.clear();
        this.myIndexOfGreyNotReady.clear();
        this.myInitIdx = -1;
        this.myIdx = -1;
        this.myIncludedWires.clear();
        this.myInitialized = false;
    }

    public boolean isIncluded(AbstractHash idx) {
        return this.myDumb ? true : this.myParents.contains(idx);
    }

    private boolean init() {
        CommitI commitAt = null;
        if (this.myInitIdx == -1) {
            for (int i = 0; i < this.myModel.getRowCount(); ++i) {
                commitAt = this.myModel.getCommitAt(i);
                if (commitAt.holdsDecoration() || !AbstractHash.hashesEqual(commitAt.getHash(), this.myPoint)) continue;
                this.myInitIdx = i;
                break;
            }
            if (this.myInitIdx == -1) {
                return false;
            }
        }
        if (commitAt == null) {
            commitAt = this.myModel.getCommitAt(this.myInitIdx);
        }
        this.myIdx = this.myInitIdx;
        this.myIncludedWires.add(commitAt.getWireNumber());
        return true;
    }

    public Map<Integer, Set<Integer>> getGreyForInterval(int from, int to, int repoCorrection, Set<Integer> wireModificationSet) {
        HashSet<Integer> value;
        HashSet<Integer> firstUsed;
        WireEventsIterator eventsIterator;
        assert (from < to);
        if (this.myDumb) {
            return null;
        }
        int idxPoint = -1;
        if (from < this.myInitIdx) {
            Map<VirtualFile, WireEventsIterator> groupIterators = this.myModel.getAllGroupIterators(from);
            eventsIterator = groupIterators.get(this.myRoot);
            Map.Entry<Integer, Set<Integer>> entry = this.myIndexOfGreyNotReady.floorEntry(eventsIterator.getFloor());
            firstUsed = new HashSet<Integer>();
            if (entry == null) {
                entry = this.myIndexOfGreyNotReady.firstEntry();
            } else {
                firstUsed.addAll((Collection)entry.getValue());
            }
            if (entry == null) {
                return Collections.emptyMap();
            }
            idxPoint = entry.getKey();
        } else {
            Map.Entry<Integer, Set<Integer>> entry = this.myIndexOfGreyNotReady.floorEntry(from);
            if (entry == null) {
                entry = this.myIndexOfGreyNotReady.firstEntry();
            }
            if (entry == null) {
                return Collections.emptyMap();
            }
            idxPoint = entry.getKey();
            firstUsed = new HashSet(entry.getValue());
            Map<VirtualFile, WireEventsIterator> groupIterators = this.myModel.getAllGroupIterators(entry.getKey());
            eventsIterator = groupIterators.get(this.myRoot);
        }
        if (eventsIterator.getFloor() > to) {
            return Collections.emptyMap();
        }
        Iterator<WireEventI> wireEventsIterator = eventsIterator.getWireEventsIterator();
        wireModificationSet.add(this.myInitIdx);
        int previous = idxPoint;
        if (previous == this.myInitIdx && from > previous) {
            firstUsed.add(this.myModel.getCommitAt(this.myInitIdx).getWireNumber());
        }
        WireEventI event = null;
        while (wireEventsIterator.hasNext() && (event = wireEventsIterator.next()).getCommitIdx() < from) {
            if (this.myInitIdx > previous && this.myInitIdx <= event.getCommitIdx()) {
                firstUsed.add(this.myModel.getCommitAt(this.myInitIdx).getWireNumber());
            }
            this.applyEventToGrey(firstUsed, event, wireModificationSet);
            previous = event.getCommitIdx();
            event = null;
        }
        int idx = from;
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        boolean nextToExit = false;
        while (wireEventsIterator.hasNext() && !nextToExit) {
            Set<Integer> integers1;
            if (event == null) {
                event = wireEventsIterator.next();
            }
            if (event.getCommitIdx() > to) {
                nextToExit = true;
            }
            value = this.copyOfUsed(repoCorrection, firstUsed);
            for (int i = idx; i <= event.getCommitIdx(); ++i) {
                value = this.putForIdx(repoCorrection, wireModificationSet, firstUsed, result, value, i);
            }
            CommitI eventCommit = this.myModel.getCommitAt(event.getCommitIdx());
            if (this.myParents.contains(eventCommit.getHash()) && (integers1 = result.get(event.getCommitIdx())) != null && !integers1.contains(eventCommit.getWireNumber() + repoCorrection)) {
                wireModificationSet.add(event.getCommitIdx());
                HashSet<Integer> integers = new HashSet<Integer>(integers1);
                integers.add(eventCommit.getWireNumber() + repoCorrection);
                result.put(event.getCommitIdx(), integers);
            }
            this.applyEventToGrey(firstUsed, event, wireModificationSet);
            idx = event.getCommitIdx() + 1;
            event = null;
        }
        value = this.copyOfUsed(repoCorrection, firstUsed);
        for (int i = idx; i < to; ++i) {
            value = this.putForIdx(repoCorrection, wireModificationSet, firstUsed, result, value, i);
        }
        return result;
    }

    private HashSet<Integer> putForIdx(int repoCorrection, Set<Integer> wireModificationSet, Set<Integer> firstUsed, HashMap<Integer, Set<Integer>> result, HashSet<Integer> value, int i) {
        int wireNumber;
        if (i == this.myInitIdx && !value.contains((wireNumber = this.myModel.getCommitAt(this.myInitIdx).getWireNumber()) + repoCorrection)) {
            wireModificationSet.add(this.myInitIdx);
            firstUsed.add(wireNumber);
            value = new HashSet();
            for (Integer integer : firstUsed) {
                value.add(integer + repoCorrection);
            }
        }
        result.put(i, value);
        return value;
    }

    private HashSet<Integer> copyOfUsed(int repoCorrection, Set<Integer> firstUsed) {
        HashSet<Integer> value = new HashSet<Integer>();
        for (Integer integer : firstUsed) {
            value.add(integer + repoCorrection);
        }
        return value;
    }

    private void recalcIndex() {
        HashSet<Integer> firstUsed;
        WireEventsIterator eventsIterator;
        Integer lastKey;
        if (this.myIdx == -1) {
            return;
        }
        Integer n = lastKey = this.myIndexOfGrey.isEmpty() ? null : this.myIndexOfGrey.lastKey();
        if (lastKey == null) {
            CommitI initCommit = this.myModel.getCommitAt(this.myInitIdx);
            Map<VirtualFile, WireEventsIterator> groupIterators = this.myModel.getAllGroupIterators(this.myInitIdx);
            eventsIterator = groupIterators.get(this.myRoot);
            firstUsed = new HashSet<Integer>();
            Integer floor = eventsIterator.getFloor();
            if (floor == null) {
                return;
            }
            this.myIndexOfGrey.put(floor, new HashSet(firstUsed));
            lastKey = floor;
        } else {
            if (lastKey + 200 > this.myModel.getRowCount()) {
                return;
            }
            Map<VirtualFile, WireEventsIterator> groupIterators = this.myModel.getAllGroupIterators(lastKey);
            eventsIterator = groupIterators.get(this.myRoot);
            firstUsed = new HashSet(this.myIndexOfGrey.get(lastKey));
        }
        Iterator<WireEventI> iterator = eventsIterator.getWireEventsIterator();
        this.myIndexOfGreyNotReady.clear();
        boolean isCompletePart = true;
        while (iterator.hasNext()) {
            WireEventI event = iterator.next();
            if (event.getCommitIdx() >= 200 + lastKey) {
                if (isCompletePart) {
                    this.myIndexOfGrey.put(event.getCommitIdx(), new HashSet<Integer>(firstUsed));
                } else {
                    this.myIndexOfGreyNotReady.put(event.getCommitIdx(), new HashSet<Integer>(firstUsed));
                }
                lastKey = event.getCommitIdx();
            }
            this.applyEventToGrey(firstUsed, event, null);
            isCompletePart = isCompletePart && event.getWaitStartsNumber() == 0;
        }
        this.myIndexOfGreyNotReady.putAll(this.myIndexOfGrey);
    }

    private void applyEventToGrey(Set<Integer> firstUsed, WireEventI event, Set<Integer> wireModificationSet) {
        CommitI eventCommit = this.myModel.getCommitAt(event.getCommitIdx());
        if (event.getCommitIdx() == this.myInitIdx && !firstUsed.contains(eventCommit.getWireNumber())) {
            firstUsed.add(eventCommit.getWireNumber());
            if (wireModificationSet != null) {
                wireModificationSet.add(this.myInitIdx);
            }
        }
        int[] wireEnds = event.getWireEnds();
        boolean anyWireIncluded = false;
        if (wireEnds != null) {
            for (int wireEnd : wireEnds) {
                if (wireEnd == -1) continue;
                int wireNumber = this.myModel.getCommitAt(wireEnd).getWireNumber();
                anyWireIncluded |= firstUsed.remove(wireNumber);
            }
        }
        if (anyWireIncluded) {
            if (!firstUsed.contains(eventCommit.getWireNumber()) && wireModificationSet != null) {
                wireModificationSet.add(event.getCommitIdx());
            }
            firstUsed.add(eventCommit.getWireNumber());
        }
        int[] commitsStarts = event.getCommitsStarts();
        int[] futureWireStarts = event.getFutureWireStarts();
        if (this.myParents.contains(eventCommit.getHash())) {
            if (commitsStarts != null) {
                for (int commitsStart : commitsStarts) {
                    if (commitsStart == -1) continue;
                    CommitI commitAt = this.myModel.getCommitAt(commitsStart);
                    firstUsed.add(commitAt.getWireNumber());
                }
            }
            if (futureWireStarts != null && futureWireStarts.length > 0) {
                for (int futureWireStart : futureWireStarts) {
                    firstUsed.add(futureWireStart);
                }
            }
        }
    }

    public void update(int recountFrom) {
        if (recountFrom <= this.myInitIdx) {
            this.reset();
        } else {
            NavigableMap<Integer, Set<Integer>> tailIdx = this.myIndexOfGrey.tailMap(recountFrom, true);
            Iterator iterator = tailIdx.keySet().iterator();
            while (iterator.hasNext()) {
                Integer next = (Integer)iterator.next();
                iterator.remove();
            }
            NavigableMap<Integer, Set<Integer>> tailNotReadyIdx = this.myIndexOfGreyNotReady.tailMap(recountFrom, true);
            Iterator iterator1 = tailNotReadyIdx.keySet().iterator();
            while (iterator1.hasNext()) {
                Integer next = (Integer)iterator1.next();
                iterator1.remove();
            }
        }
        if (this.myPoint == null) {
            return;
        }
        if (!this.myInitialized) {
            this.myInitialized = this.init();
            if (!this.myInitialized) {
                return;
            }
        }
        Map<VirtualFile, WireEventsIterator> groupIterators = this.myModel.getAllGroupIterators(this.myIdx);
        WireEventsIterator eventsIterator = groupIterators.get(this.myRoot);
        Iterator<WireEventI> iterator2 = eventsIterator.getWireEventsIterator();
        int runningIdx = this.myIdx;
        HashSet<Integer> includedWires = new HashSet<Integer>();
        includedWires.addAll(this.myIncludedWires);
        this.myIncludedWires.clear();
        int lastEventIdx = this.myIdx;
        while (iterator2.hasNext() && !includedWires.isEmpty()) {
            WireEventI event = iterator2.next();
            lastEventIdx = event.getCommitIdx();
            HashSet<Integer> ends = new HashSet<Integer>();
            int self = this.myModel.getCommitAt(event.getCommitIdx()).getWireNumber();
            ends.add(self);
            int[] wireEnds = event.getWireEnds();
            if (wireEnds != null) {
                for (int wireEnd : wireEnds) {
                    if (wireEnd == -1) continue;
                    ends.add(this.myModel.getCommitAt(wireEnd).getWireNumber());
                }
            }
            boolean containsAny = false;
            for (Integer end : ends) {
                if (!includedWires.contains(end)) continue;
                containsAny = true;
                break;
            }
            if (!containsAny) continue;
            this.fillCommits(runningIdx, event.getCommitIdx(), includedWires);
            if (event.getWaitStartsNumber() > 0 && this.myIncludedWires.isEmpty()) {
                this.myIncludedWires.addAll(includedWires);
            }
            includedWires.removeAll(ends);
            includedWires.add(self);
            int[] commitsStarts = event.getCommitsStarts();
            if (commitsStarts != null) {
                for (int commitsStart : commitsStarts) {
                    if (commitsStart == -1) continue;
                    includedWires.add(this.myModel.getCommitAt(commitsStart).getWireNumber());
                }
            }
            runningIdx = event.getCommitIdx();
            if (event.getWaitStartsNumber() != 0 || !this.myIncludedWires.isEmpty()) continue;
            this.myIdx = event.getCommitIdx();
        }
        int lastForRoot = this.myModel.getLastForRoot(this.myRoot);
        if (runningIdx < lastForRoot) {
            this.fillCommits(runningIdx, lastForRoot, includedWires);
        }
        if (this.myIncludedWires.isEmpty()) {
            this.myIncludedWires.addAll(includedWires);
        }
        this.recalcIndex();
    }

    private void fillCommits(int curIdx, int commitIdx, Set<Integer> includedWires) {
        for (int i = curIdx; i <= commitIdx; ++i) {
            CommitI commitAt = this.myModel.getCommitAt(i);
            if (!this.mySingleRoot && !commitAt.selectRepository(this.myModel.getRootsHolder().getRoots()).equals(this.myRoot) || !includedWires.contains(commitAt.getWireNumber())) continue;
            this.myParents.add(commitAt.getHash());
        }
    }

    public void reset() {
        this.myIncludedWires.clear();
        this.myIdx = -1;
        this.myInitIdx = -1;
        this.myInitialized = false;
    }

    public void setDumb() {
        this.myDumb = true;
    }

    public boolean isDumb() {
        return this.myDumb;
    }

    public AbstractHash getPoint() {
        return this.myPoint;
    }
}

