/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.vcs.Ring;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.ReadonlyList;
import git4idea.history.wholeTree.CommitI;
import git4idea.history.wholeTree.TreeNavigation;
import git4idea.history.wholeTree.WireEvent;
import git4idea.history.wholeTree.WireEventI;
import git4idea.history.wholeTree.WireEventsListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class TreeNavigationImpl
implements TreeNavigation,
WireEventsListener {
    public static final int[] MARKER = new int[]{-1};
    private final TreeMap<Integer, WireEvent> myWireEvents;
    private final TreeMap<Integer, RingIndex> myRingIndex;
    private final int myCommitIndexInterval;
    private final int myNumWiresInGroup;

    public TreeNavigationImpl(int commitIndexInterval, int numWiresInGroup) {
        this.myCommitIndexInterval = commitIndexInterval;
        this.myNumWiresInGroup = numWiresInGroup;
        this.myWireEvents = new TreeMap();
        this.myRingIndex = new TreeMap();
    }

    public Set<Integer> getRingIndexPoints() {
        return this.myRingIndex.keySet();
    }

    public void recalcIndex(ReadonlyList<CommitI> commits, Convertor<Integer, List<Integer>> future) {
        Ring<Integer> ring;
        NavigableMap<Integer, WireEvent> tail;
        Integer lastIndexKey;
        if (this.myWireEvents.isEmpty()) {
            return;
        }
        Integer n = lastIndexKey = this.myRingIndex.isEmpty() ? null : this.myRingIndex.lastKey();
        if (lastIndexKey != null) {
            tail = this.myWireEvents.tailMap(lastIndexKey, true);
            int size = tail.size();
            if (size == 1) {
                return;
            }
            Integer lastKey = this.myWireEvents.lastKey();
            if (lastKey - lastIndexKey < this.myCommitIndexInterval || size < this.myNumWiresInGroup) {
                return;
            }
            ring = this.myRingIndex.lastEntry().getValue().getUsedInRing();
        } else {
            lastIndexKey = this.myWireEvents.firstKey();
            ring = new Ring<Integer>();
            List used = ring.getUsed();
            this.myRingIndex.put(lastIndexKey, new RingIndex(used.toArray(new Integer[used.size()])));
            WireEventI firstEvent = this.myWireEvents.firstEntry().getValue();
            this.performOnRing(ring, firstEvent, commits, (List)future.convert((Object)firstEvent.getCommitIdx()));
            tail = this.myWireEvents.tailMap(lastIndexKey, false);
        }
        int cnt = 0;
        int recordCommitIdx = this.myCommitIndexInterval + this.myWireEvents.floorKey(lastIndexKey);
        for (Integer integer : tail.keySet()) {
            if (++cnt >= this.myNumWiresInGroup || integer >= recordCommitIdx) {
                List used = ring.getUsed();
                this.myRingIndex.put(integer, new RingIndex(used.toArray(new Integer[used.size()])));
                cnt = 0;
                recordCommitIdx += this.myCommitIndexInterval;
            }
            WireEventI event = (WireEventI)tail.get(integer);
            this.performOnRing(ring, event, commits, (List)future.convert((Object)event.getCommitIdx()));
        }
    }

    private void performOnRing(Ring<Integer> ring, WireEventI event, ReadonlyList<CommitI> convertor, List<Integer> futureWireStarts) {
        int[] wireEnds = event.getWireEnds();
        if (wireEnds != null) {
            for (int wireEnd : wireEnds) {
                int wireNumber = ((CommitI)convertor.get(wireEnd)).getWireNumber();
                ring.back((Comparable)Integer.valueOf(wireNumber));
            }
        }
        if (event.isStart()) {
            int commitWire = ((CommitI)convertor.get(event.getCommitIdx())).getWireNumber();
            ring.minus((Comparable)Integer.valueOf(commitWire));
        }
        if (event.isEnd()) {
            int commitWire = ((CommitI)convertor.get(event.getCommitIdx())).getWireNumber();
            ring.back((Comparable)Integer.valueOf(commitWire));
        } else {
            int[] commitsStarts;
            for (int commitStart : commitsStarts = event.getCommitsStarts()) {
                int commitWire = ((CommitI)convertor.get(commitStart)).getWireNumber();
                ring.minus((Comparable)Integer.valueOf(commitWire));
            }
        }
        int[] futureWireStarts1 = event.getFutureWireStarts();
        if (futureWireStarts1 != null && futureWireStarts1.length > 0) {
            for (int i : futureWireStarts1) {
                ring.minus((Comparable)Integer.valueOf(i));
            }
        }
        for (Integer wireStart : futureWireStarts) {
            ring.minus((Comparable)wireStart);
        }
    }

    public Collection<WireEvent> getTail(int rowInclusive) {
        return this.myWireEvents.tailMap(rowInclusive).values();
    }

    public WireEventI getEventForRow(int row) {
        return this.myWireEvents.get(row);
    }

    @Override
    public Iterator<WireEvent> createWireEventsIterator(int rowInclusive) {
        return this.myWireEvents.tailMap(rowInclusive).values().iterator();
    }

    private Iterator<WireEvent> createWireEventsBackIterator(int rowExclusive) {
        return this.myWireEvents.headMap(rowExclusive, false).descendingMap().values().iterator();
    }

    @Override
    public Ring<Integer> getUsedWires(int row, ReadonlyList<CommitI> commits, Convertor<Integer, List<Integer>> future) {
        Map.Entry<Integer, RingIndex> entry = this.myRingIndex.floorEntry(row);
        if (entry == null) {
            return new Ring.IntegerRing();
        }
        Ring<Integer> ring = entry.getValue().getUsedInRing();
        if (entry.getKey() == row) {
            return ring;
        }
        Iterator<WireEvent> iterator = this.createWireEventsIterator(entry.getKey());
        while (iterator.hasNext()) {
            WireEventI event = iterator.next();
            if (event.getCommitIdx() >= row) {
                return ring;
            }
            this.performOnRing(ring, event, commits, (List)future.convert((Object)event.getCommitIdx()));
        }
        return ring;
    }

    @Override
    public void addStartToEvent(int row, final int parentRow, final int wireNumber) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
                wireEvent.addStart(parentRow, wireNumber);
            }
        });
    }

    @Override
    public void setWireStartsNumber(int row, final Integer[] number) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
                wireEvent.setWaitStartsNumber(number);
            }
        });
    }

    @Override
    public void wireStarts(int row) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
            }
        });
    }

    @Override
    public void wireEnds(int row) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
                wireEvent.addStart(-1, -1);
            }
        });
    }

    @Override
    public void setEnds(int row, final int[] commitEnds) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
                wireEvent.setCommitEnds(commitEnds);
            }
        });
    }

    @Override
    public void parentWireEnds(int row, final int parentRow) {
        this.modify(row, new Consumer<WireEvent>(){

            public void consume(WireEvent wireEvent) {
                wireEvent.addWireEnd(parentRow);
            }
        });
    }

    private void modify(int row, Consumer<WireEvent> consumer) {
        WireEvent event = this.myWireEvents.get(row);
        if (event == null) {
            event = new WireEvent(row, null);
            this.myWireEvents.put(row, event);
        }
        consumer.consume((Object)event);
    }

    public void printSelf() {
        System.out.println("============== EVENTS =================");
        for (WireEvent event : this.myWireEvents.values()) {
            System.out.println(((Object)event).toString());
        }
        System.out.println("==============********=================");
    }

    private void recountFragmentZwichem(ReadonlyList<CommitI> commits, Map<Integer, Integer> recalculateMap, int runningCommitNumber, int inclusive) {
        if (!recalculateMap.isEmpty()) {
            for (int i = runningCommitNumber; i <= inclusive; ++i) {
                CommitI commit = (CommitI)commits.get(i);
                Integer newWire = recalculateMap.get(commit.getWireNumber());
                if (newWire == null) continue;
                commit.setWireNumber(newWire);
            }
        }
    }

    private static class RingIndex {
        private final Integer[] myWireNumbers;

        private RingIndex(Integer[] wireNumbers) {
            this.myWireNumbers = wireNumbers;
        }

        public Ring<Integer> getUsedInRing() {
            return new Ring.IntegerRing(Arrays.asList(this.myWireNumbers));
        }
    }
}

