/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.settings.GitPushSettings;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final boolean myForce;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitPushSettings myPushSettings;
    private final GitPlatformFacade myPlatformFacade;

    public GitPushOperation(@NotNull Project project, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/push/GitPushOperation", "<init>"));
        }
        if (pushSpecs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSpecs", "git4idea/push/GitPushOperation", "<init>"));
        }
        this.myProject = project;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForce = force;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myPushSettings = GitPushSettings.getInstance(this.myProject);
        this.myPlatformFacade = (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class);
        HashMap currentHeads = ContainerUtil.newHashMap();
        for (GitRepository repository : pushSpecs.keySet()) {
            repository.update();
            String head = repository.getCurrentRevision();
            if (head == null) {
                LOG.error("This repository has no commits");
                continue;
            }
            currentHeads.put(repository, new GitRevisionNumber(head));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        HashMap results = ContainerUtil.newHashMap();
        HashMap updatedRoots = ContainerUtil.newHashMap();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(remainingRoots);
                results.putAll(resultMap);
                GroupedPushResult result = GroupedPushResult.group(resultMap);
                if (!result.errors.isEmpty()) {
                    break;
                }
                if (!result.rejected.isEmpty()) {
                    boolean shouldUpdate = true;
                    if (GitPushOperation.pushingToNotTrackedBranch(result.rejected)) {
                        shouldUpdate = false;
                    } else if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        updateSettings = this.showDialogAndGetExitCode(result.rejected.keySet(), updateSettings);
                        if (updateSettings != null) {
                            this.savePushUpdateSettings(updateSettings);
                        } else {
                            shouldUpdate = false;
                        }
                    }
                    if (!shouldUpdate) {
                        break;
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
                    }
                    Set<GitRepository> rootsToUpdate = updateSettings.shouldUpdateAllRoots() ? this.myPushSpecs.keySet() : result.rejected.keySet();
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod());
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "After push");
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        GitPushResult gitPushResult = this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
        if (gitPushResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "execute"));
        }
        return gitPushResult;
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "git4idea/push/GitPushOperation", "pushingToNotTrackedBranch"));
        }
        return ContainerUtil.exists(rejected.entrySet(), (Condition)new Condition<Map.Entry<GitRepository, GitPushRepoResult>>(){

            public boolean value(Map.Entry<GitRepository, GitPushRepoResult> entry) {
                GitRepository repository = entry.getKey();
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                assert (currentBranch != null);
                GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
                return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(entry.getValue().getTargetBranch());
            }
        });
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(final @NotNull Map<GitRepository, GitPushRepoResult> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "git4idea/push/GitPushOperation", "getRejectedAndNotPushed"));
        }
        List list = ContainerUtil.filter(results.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "getRejectedAndNotPushed"));
        }
        return list;
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Map map = ContainerUtil.map2Map(this.myPushSpecs.keySet(), (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(GitRepository repository) {
                repository.update();
                return Pair.create((Object)repository, (Object)repository.getCurrentRevision());
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "updateRootInfoAndRememberPositions"));
        }
        return map;
    }

    private GitPushResult prepareCombinedResult(Map<GitRepository, GitPushRepoResult> allRoots, Map<GitRepository, GitUpdateResult> updatedRoots, Map<GitRepository, String> preUpdatePositions, Label beforeUpdateLabel, Label afterUpdateLabel) {
        HashMap results = ContainerUtil.newHashMap();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel);
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull Collection<GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/push/GitPushOperation", "push"));
        }
        LinkedHashMap results = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(repository);
            Pair<List<GitPushNativeResult>, String> resultOrError = this.doPush(repository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + resultOrError);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultOrError.second != null) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), (String)resultOrError.second);
            } else {
                List result = (List)resultOrError.first;
                final GitPushNativeResult branchResult = GitPushOperation.getBranchResult(result);
                if (branchResult == null) {
                    LOG.error("No result for branch among: [" + result + "]");
                    continue;
                }
                List tagResults = ContainerUtil.filter((Collection)result, (Condition)new Condition<GitPushNativeResult>(){

                    public boolean value(GitPushNativeResult result) {
                        return !result.equals(branchResult) && (result.getType() == GitPushNativeResult.Type.NEW_REF || result.getType() == GitPushNativeResult.Type.FORCED_UPDATE);
                    }
                });
                int commits = this.collectNumberOfPushedCommits(repository.getRoot(), branchResult);
                repoResult = GitPushRepoResult.convertFromNative(branchResult, tagResults, commits, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(repository, repoResult);
        }
        for (GitRepository repository : repositories) {
            if (results.containsKey(repository)) continue;
            spec = this.myPushSpecs.get(repository);
            results.put(repository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        LinkedHashMap linkedHashMap = results;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "push"));
        }
        return linkedHashMap;
    }

    @Nullable
    private static GitPushNativeResult getBranchResult(@NotNull List<GitPushNativeResult> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "git4idea/push/GitPushOperation", "getBranchResult"));
        }
        return (GitPushNativeResult)ContainerUtil.find(results, (Condition)new Condition<GitPushNativeResult>(){

            public boolean value(GitPushNativeResult result) {
                return result.getSourceRef().startsWith("refs/heads/");
            }
        });
    }

    @NotNull
    private static <T> List<T> without(@NotNull List<T> collection, @NotNull T toRemove) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "git4idea/push/GitPushOperation", "without"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "git4idea/push/GitPushOperation", "without"));
        }
        ArrayList result = ContainerUtil.newArrayList(collection);
        result.remove(toRemove);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "without"));
        }
        return arrayList;
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/push/GitPushOperation", "collectNumberOfPushedCommits"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/push/GitPushOperation", "collectNumberOfPushedCommits"));
        }
        if (result.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/push/GitPushOperation", "collectUpdatedFiles"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushOperation", "collectUpdatedFiles"));
        }
        if (preUpdatePosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preUpdatePosition", "git4idea/push/GitPushOperation", "collectUpdatedFiles"));
        }
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, repository.getRoot(), new GitRevisionNumber(preUpdatePosition));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(updatedFiles, exceptions);
        for (VcsException exception : exceptions) {
            LOG.info((Throwable)exception);
        }
    }

    @NotNull
    private Pair<List<GitPushNativeResult>, String> doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        String tagMode;
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushOperation", "doPush"));
        }
        if (pushSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSpec", "git4idea/push/GitPushOperation", "doPush"));
        }
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = ((GitPushSource)pushSpec.getSource()).getBranch();
        GitRemoteBranch targetBranch = target.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = ((GitPushTarget)pushSpec.getTarget()).isNewBranchCreated() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        GitCommandResult res = this.myGit.push(repository, sourceBranch, targetBranch, this.myForce, setUpstream, tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument(), progressListener);
        List<GitPushNativeResult> result = GitPushNativeResultParser.parse(res.getOutput());
        if (result.isEmpty()) {
            Pair pair = Pair.create(null, (Object)res.getErrorOutputAsJoinedString());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "doPush"));
            }
            return pair;
        }
        Pair pair = Pair.create(result, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "doPush"));
        }
        return pair;
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, final @NotNull GitLocalBranch source) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushOperation", "branchTrackingInfoIsSet"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "git4idea/push/GitPushOperation", "branchTrackingInfoIsSet"));
        }
        return ContainerUtil.exists(repository.getBranchTrackInfos(), (Condition)new Condition<GitBranchTrackInfo>(){

            public boolean value(GitBranchTrackInfo info) {
                return info.getLocalBranch().equals(source);
            }
        });
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/push/GitPushOperation", "savePushUpdateSettings"));
        }
        UpdateMethod updateMethod = settings.getUpdateMethod();
        this.myPushSettings.setUpdateAllRoots(settings.shouldUpdateAllRoots());
        this.myPushSettings.setUpdateMethod(updateMethod);
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        boolean updateAllRoots = this.myPushSettings.shouldUpdateAllRoots();
        UpdateMethod updateMethod = this.myPushSettings.getUpdateMethod();
        PushUpdateSettings pushUpdateSettings = new PushUpdateSettings(updateAllRoots, updateMethod);
        if (pushUpdateSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "readPushUpdateSettings"));
        }
        return pushUpdateSettings;
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(final @NotNull Set<GitRepository> repositories, final @NotNull PushUpdateSettings initialSettings) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/push/GitPushOperation", "showDialogAndGetExitCode"));
        }
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "git4idea/push/GitPushOperation", "showDialogAndGetExitCode"));
        }
        final Ref updateSettings = Ref.create();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(GitPushOperation.this.myProject, repositories, initialSettings);
                DialogManager.show(dialog);
                int exitCode = dialog.getExitCode();
                if (exitCode != 1) {
                    GitPushOperation.this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
                    updateSettings.set((Object)new PushUpdateSettings(dialog.shouldUpdateAll(), GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
                }
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                UpdateMethod updateMethod = UpdateMethod.MERGE;
                if (updateMethod == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "convertUpdateMethodFromDialogExitCode"));
                }
                return updateMethod;
            }
            case 3: {
                UpdateMethod updateMethod = UpdateMethod.REBASE;
                if (updateMethod == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "convertUpdateMethodFromDialogExitCode"));
                }
                return updateMethod;
            }
        }
        throw new IllegalStateException("Unexpected exit code: " + exitCode);
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod) {
        if (rootsToUpdate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToUpdate", "git4idea/push/GitPushOperation", "update"));
        }
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/push/GitPushOperation", "update"));
        }
        GitUpdateProcess.UpdateMethod um = updateMethod == UpdateMethod.MERGE ? GitUpdateProcess.UpdateMethod.MERGE : GitUpdateProcess.UpdateMethod.REBASE;
        GitUpdateResult updateResult = new GitUpdateProcess(this.myProject, this.myPlatformFacade, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create()).update(um);
        for (GitRepository repository : rootsToUpdate) {
            repository.getRoot().refresh(true, true);
            repository.update();
        }
        GitUpdateResult gitUpdateResult = updateResult;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushOperation", "update"));
        }
        return gitUpdateResult;
    }
}

