/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class EnumProcessor {
    public static void clearEnum(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invexpr;
            Statement firstData;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String descriptor = mt.getDescriptor();
            if ("values".equals(name)) {
                if (!descriptor.equals("()[L" + cl.qualifiedName + ";")) continue;
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, descriptor));
                continue;
            }
            if ("valueOf".equals(name)) {
                if (!descriptor.equals("(Ljava/lang/String;)L" + cl.qualifiedName + ";")) continue;
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, descriptor));
                continue;
            }
            if (!"<init>".equals(name) || (firstData = EnumProcessor.findFirstData(method.root)) == null || firstData.getExprents().isEmpty()) continue;
            Exprent exprent = firstData.getExprents().get(0);
            if (exprent.type != 8 || !EnumProcessor.isInvocationSuperConstructor(invexpr = (InvocationExprent)exprent, method, wrapper)) continue;
            firstData.getExprents().remove(0);
        }
        for (StructField fd : cl.getFields()) {
            String descriptor = fd.getDescriptor();
            if (!fd.isSynthetic() || !descriptor.equals("[L" + cl.qualifiedName + ";")) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), descriptor));
        }
    }

    private static Statement findFirstData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        if (stat.isLabeled()) {
            return null;
        }
        switch (stat.type) {
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 15: {
                return EnumProcessor.findFirstData(stat.getFirst());
            }
        }
        return null;
    }

    private static boolean isInvocationSuperConstructor(InvocationExprent inv, MethodWrapper meth, ClassWrapper wrapper) {
        if (inv.getFunctype() == 2 && inv.getInstance().type == 12) {
            VarExprent instvar = (VarExprent)inv.getInstance();
            VarVersionPaar varpaar = new VarVersionPaar(instvar);
            String classname = meth.varproc.getThisvars().get(varpaar);
            if (classname != null && !wrapper.getClassStruct().qualifiedName.equals(inv.getClassname())) {
                return true;
            }
        }
        return false;
    }
}

