/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.PrintStream;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class PrintStreamLogger
extends IFernflowerLogger {
    private final PrintStream stream;
    private int indent;

    public PrintStreamLogger(PrintStream printStream) {
        this.stream = printStream;
        this.indent = 0;
    }

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (this.accepts(severity)) {
            this.stream.println(severity.prefix + InterpreterUtil.getIndentString(this.indent) + message);
        }
    }

    @Override
    public void writeMessage(String message, Throwable t) {
        this.writeMessage(message, IFernflowerLogger.Severity.ERROR);
        if (this.accepts(IFernflowerLogger.Severity.ERROR)) {
            t.printStackTrace(this.stream);
        }
    }

    @Override
    public void startReadingClass(String className) {
        this.writeMessage("Decompiling class " + className, IFernflowerLogger.Severity.INFO);
        ++this.indent;
    }

    @Override
    public void endReadingClass() {
        --this.indent;
        this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
    }

    @Override
    public void startClass(String className) {
        this.writeMessage("Processing class " + className, IFernflowerLogger.Severity.TRACE);
        ++this.indent;
    }

    @Override
    public void endClass() {
        --this.indent;
        this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
    }

    @Override
    public void startMethod(String methodName) {
        this.writeMessage("Processing method " + methodName, IFernflowerLogger.Severity.TRACE);
        ++this.indent;
    }

    @Override
    public void endMethod() {
        --this.indent;
        this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
    }

    @Override
    public void startWriteClass(String className) {
        this.writeMessage("Writing class " + className, IFernflowerLogger.Severity.TRACE);
        ++this.indent;
    }

    @Override
    public void endWriteClass() {
        --this.indent;
        this.writeMessage("... written", IFernflowerLogger.Severity.TRACE);
    }
}

