/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class NestedClassProcessor {
    public void processClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ClassesProcessor.ClassNode node_content;
        if (node.type == 8 && !node.lambda_information.is_method_reference && (node_content = DecompilerContext.getClassProcessor().getMapRootClasses().get(node.classStruct.qualifiedName)) != null && node_content.wrapper != null) {
            node_content.wrapper.getHiddenMembers().add(node.lambda_information.content_method_key);
        }
        if (node.nested.isEmpty()) {
            return;
        }
        if (node.type != 8) {
            NestedClassProcessor.computeLocalVarsAndDefinitions(node);
            NestedClassProcessor.checkNotFoundClasses(root, node);
        }
        int nameless = 0;
        int synthetics = 0;
        for (ClassesProcessor.ClassNode child : node.nested) {
            if (child.type != 4 && child.type != 1 || child.simpleName != null) continue;
            StructClass cl = child.classStruct;
            if ((child.access & 0x1000) != 0 || cl.isSynthetic()) {
                child.simpleName = "SyntheticClass_" + ++synthetics;
                continue;
            }
            DecompilerContext.getLogger().writeMessage("Nameless local or member class " + cl.qualifiedName + "!", IFernflowerLogger.Severity.WARN);
            child.simpleName = "NamelessClass_" + ++nameless;
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            if (child.type == 8) {
                NestedClassProcessor.setLambdaVars(node, child);
                continue;
            }
            if (child.type == 1 && (child.access & 8) != 0) continue;
            NestedClassProcessor.insertLocalVars(node, child);
            if (child.type != 4) continue;
            NestedClassProcessor.setLocalClassDefinition(node.wrapper.getMethods().getWithKey(child.enclosingMethod), child);
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.processClass(root, child);
        }
    }

    private static void setLambdaVars(ClassesProcessor.ClassNode parent, ClassesProcessor.ClassNode child) {
        if (child.lambda_information.is_method_reference) {
            return;
        }
        MethodWrapper meth = parent.wrapper.getMethods().getWithKey(child.lambda_information.content_method_key);
        final MethodWrapper encmeth = parent.wrapper.getMethods().getWithKey(child.enclosingMethod);
        MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(child.lambda_information.method_descriptor);
        final MethodDescriptor md_content = MethodDescriptor.parseDescriptor(child.lambda_information.content_method_descriptor);
        final int vars_count = md_content.params.length - md_lambda.params.length;
        final boolean is_static_lambda_content = child.lambda_information.is_content_method_static;
        String parent_class_name = parent.wrapper.getClassStruct().qualifiedName;
        String lambda_class_name = child.simpleName;
        final VarType lambda_class_type = new VarType(lambda_class_name, true);
        if (!is_static_lambda_content && DecompilerContext.getOption("lac")) {
            meth.varproc.getThisvars().put(new VarVersionPaar(0, 0), parent_class_name);
            meth.varproc.setVarName(new VarVersionPaar(0, 0), parent.simpleName + ".this");
        }
        DirectGraph graph = encmeth.getOrBuildGraph();
        final HashMap mapNewNames = new HashMap();
        graph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    NewExprent new_expr;
                    if (expr.type != 10 || !(new_expr = (NewExprent)expr).isLambda() || !lambda_class_type.equals(new_expr.getNewtype())) continue;
                    InvocationExprent inv_dynamic = new_expr.getConstructor();
                    int param_index = is_static_lambda_content ? 0 : 1;
                    int varindex = is_static_lambda_content ? 0 : 1;
                    for (int i = 0; i < vars_count; ++i) {
                        Exprent param = inv_dynamic.getLstParameters().get(param_index + i);
                        if (param.type == 12) {
                            VarVersionPaar enc_varpaar = new VarVersionPaar((VarExprent)param);
                            String enc_varname = encmeth.varproc.getVarName(enc_varpaar);
                            mapNewNames.put(new VarVersionPaar(varindex, 0), enc_varname);
                        }
                        varindex += md_content.params[i].stack_size;
                    }
                }
                return 0;
            }
        });
        HashSet<String> setNewOuterNames = new HashSet<String>(mapNewNames.values());
        setNewOuterNames.removeAll(meth.setOuterVarNames);
        meth.varproc.refreshVarNames(new VarNamesCollector(setNewOuterNames));
        meth.setOuterVarNames.addAll(setNewOuterNames);
        for (Map.Entry entr : mapNewNames.entrySet()) {
            meth.varproc.setVarName((VarVersionPaar)entr.getKey(), (String)entr.getValue());
        }
    }

    private static void checkNotFoundClasses(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode node) {
        ArrayList<ClassesProcessor.ClassNode> lstChildren = new ArrayList<ClassesProcessor.ClassNode>(node.nested);
        for (ClassesProcessor.ClassNode child : lstChildren) {
            String message;
            boolean hasEnclosing;
            StructEnclosingMethodAttribute attr;
            if (child.type != 4 && child.type != 2 || child.enclosingMethod != null) continue;
            Set<String> setEnclosing = child.enclosingClasses;
            if (setEnclosing.size() == 1 && (attr = (StructEnclosingMethodAttribute)child.classStruct.getAttributes().getWithKey("EnclosingMethod")) != null && attr.getMethodName() != null && node.classStruct.qualifiedName.equals(attr.getClassName()) && node.classStruct.getMethod(attr.getMethodName(), attr.getMethodDescriptor()) != null) {
                child.enclosingMethod = InterpreterUtil.makeUniqueKey(attr.getMethodName(), attr.getMethodDescriptor());
                continue;
            }
            node.nested.remove(child);
            child.parent = null;
            setEnclosing.remove(node.classStruct.qualifiedName);
            boolean bl = hasEnclosing = !setEnclosing.isEmpty();
            if (hasEnclosing) {
                hasEnclosing = NestedClassProcessor.insertNestedClass(root, child);
            }
            if (hasEnclosing) continue;
            if (child.type == 2) {
                message = "Unreferenced anonymous class " + child.classStruct.qualifiedName + "!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            if (child.type != 4) continue;
            message = "Unreferenced local class " + child.classStruct.qualifiedName + "!";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
    }

    private static boolean insertNestedClass(ClassesProcessor.ClassNode root, ClassesProcessor.ClassNode child) {
        Set<String> setEnclosing = child.enclosingClasses;
        LinkedList<ClassesProcessor.ClassNode> stack = new LinkedList<ClassesProcessor.ClassNode>();
        stack.add(root);
        while (!stack.isEmpty()) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)stack.removeFirst();
            if (setEnclosing.contains(node.classStruct.qualifiedName)) {
                node.nested.add(child);
                child.parent = node;
                return true;
            }
            stack.addAll(node.nested);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void computeLocalVarsAndDefinitions(final ClassesProcessor.ClassNode node) {
        final HashMap<String, HashMap<String, List<VarFieldPair>>> mapVarMasks = new HashMap<String, HashMap<String, List<VarFieldPair>>>();
        int cltypes = 0;
        for (ClassesProcessor.ClassNode nd : node.nested) {
            if (nd.type == 8 || (nd.access & 8) != 0 || (nd.access & 0x200) != 0) continue;
            cltypes |= nd.type;
            HashMap<String, List<VarFieldPair>> mask = NestedClassProcessor.getMaskLocalVars(nd.wrapper);
            if (mask.isEmpty()) {
                String message = "Nested class " + nd.classStruct.qualifiedName + " has no constructor!";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                continue;
            }
            mapVarMasks.put(nd.classStruct.qualifiedName, mask);
        }
        final HashMap mapVarFieldPairs = new HashMap();
        if (cltypes != 1) {
            for (final MethodWrapper meth : node.wrapper.getMethods()) {
                if (meth.root == null) continue;
                DirectGraph graph = meth.getOrBuildGraph();
                graph.iterateExprents(new DirectGraph.ExprentIterator(){

                    @Override
                    public int processExprent(Exprent exprent) {
                        List<Exprent> lst = exprent.getAllExprents(true);
                        lst.add(exprent);
                        for (Exprent expr : lst) {
                            InvocationExprent constr;
                            if (expr.type != 10 || (constr = ((NewExprent)expr).getConstructor()) == null || !mapVarMasks.containsKey(constr.getClassname())) continue;
                            String refclname = constr.getClassname();
                            ClassesProcessor.ClassNode nestedClassNode = node.getClassNode(refclname);
                            if (nestedClassNode.type == 1) continue;
                            List mask = (List)((HashMap)mapVarMasks.get(refclname)).get(constr.getStringDescriptor());
                            if (!mapVarFieldPairs.containsKey(refclname)) {
                                mapVarFieldPairs.put(refclname, new HashMap());
                            }
                            ArrayList<VarFieldPair> lstTemp = new ArrayList<VarFieldPair>();
                            for (int i = 0; i < mask.size(); ++i) {
                                Exprent param = constr.getLstParameters().get(i);
                                VarFieldPair pair = null;
                                if (param.type == 12 && mask.get(i) != null) {
                                    VarVersionPaar varpaar = new VarVersionPaar((VarExprent)param);
                                    pair = new VarFieldPair(((VarFieldPair)mask.get((int)i)).keyfield, varpaar);
                                }
                                lstTemp.add(pair);
                            }
                            ArrayList<VarFieldPair> pairmask = (ArrayList<VarFieldPair>)((HashMap)mapVarFieldPairs.get(refclname)).get(constr.getStringDescriptor());
                            if (pairmask == null) {
                                pairmask = lstTemp;
                            } else {
                                for (int i = 0; i < pairmask.size(); ++i) {
                                    if (InterpreterUtil.equalObjects(pairmask.get(i), lstTemp.get(i))) continue;
                                    pairmask.set(i, null);
                                }
                            }
                            ((HashMap)mapVarFieldPairs.get(refclname)).put(constr.getStringDescriptor(), pairmask);
                            nestedClassNode.enclosingMethod = InterpreterUtil.makeUniqueKey(meth.methodStruct.getName(), meth.methodStruct.getDescriptor());
                        }
                        return 0;
                    }
                });
            }
        }
        for (Map.Entry entcl : mapVarMasks.entrySet()) {
            ClassesProcessor.ClassNode nestedNode = node.getClassNode((String)entcl.getKey());
            ArrayList<VarFieldPair> intrPairMask = null;
            if (mapVarFieldPairs.containsKey(entcl.getKey())) {
                for (List mask : ((HashMap)mapVarFieldPairs.get(entcl.getKey())).values()) {
                    if (intrPairMask == null) {
                        intrPairMask = new ArrayList(mask);
                        continue;
                    }
                    NestedClassProcessor.mergeListSignatures(intrPairMask, mask, false);
                }
            }
            ArrayList intrMask = null;
            for (List list : ((HashMap)entcl.getValue()).values()) {
                if (intrMask == null) {
                    intrMask = new ArrayList(list);
                    continue;
                }
                NestedClassProcessor.mergeListSignatures(intrMask, list, false);
            }
            if (intrPairMask == null) {
                void var10_15;
                intrPairMask = new ArrayList<VarFieldPair>(intrMask);
                boolean found = false;
                boolean bl = false;
                while (var10_15 < intrPairMask.size()) {
                    if (intrPairMask.get((int)var10_15) != null) {
                        if (found) {
                            intrPairMask.set((int)var10_15, null);
                        }
                        found = true;
                    }
                    ++var10_15;
                }
            }
            NestedClassProcessor.mergeListSignatures(intrPairMask, intrMask, true);
            for (int i = 0; i < intrPairMask.size(); ++i) {
                VarFieldPair varFieldPair = (VarFieldPair)intrPairMask.get(i);
                if (varFieldPair == null || varFieldPair.keyfield.length() <= 0) continue;
                nestedNode.mapFieldsToVars.put(varFieldPair.keyfield, varFieldPair.varpaar);
            }
            for (Map.Entry entry : ((HashMap)entcl.getValue()).entrySet()) {
                NestedClassProcessor.mergeListSignatures((List)entry.getValue(), intrPairMask, false);
                MethodWrapper meth = nestedNode.wrapper.getMethodWrapper("<init>", (String)entry.getKey());
                meth.signatureFields = new ArrayList<VarVersionPaar>();
                for (VarFieldPair pair : (List)entry.getValue()) {
                    meth.signatureFields.add(pair == null ? null : pair.varpaar);
                }
            }
        }
    }

    private static void insertLocalVars(ClassesProcessor.ClassNode parent, final ClassesProcessor.ClassNode child) {
        MethodWrapper encmeth = parent.wrapper.getMethods().getWithKey(child.enclosingMethod);
        for (final MethodWrapper meth : child.wrapper.getMethods()) {
            if (meth.root == null) continue;
            HashMap<VarVersionPaar, String> mapNewNames = new HashMap<VarVersionPaar, String>();
            HashMap<VarVersionPaar, VarType> mapNewTypes = new HashMap<VarVersionPaar, VarType>();
            final HashMap<Integer, VarVersionPaar> mapParamsToNewVars = new HashMap<Integer, VarVersionPaar>();
            if (meth.signatureFields != null) {
                int index = 0;
                int varindex = 1;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(meth.methodStruct.getDescriptor());
                for (VarVersionPaar paar : meth.signatureFields) {
                    if (paar != null) {
                        VarVersionPaar newvar = new VarVersionPaar(meth.counter.getCounterAndIncrement(2), 0);
                        mapParamsToNewVars.put(varindex, newvar);
                        String varname = null;
                        VarType vartype = null;
                        if (child.type != 1) {
                            varname = encmeth.varproc.getVarName(paar);
                            vartype = encmeth.varproc.getVarType(paar);
                            encmeth.varproc.setVarFinal(paar, 2);
                        }
                        if (paar.var == -1 || "this".equals(varname)) {
                            varname = parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : parent.simpleName + ".this";
                            meth.varproc.getThisvars().put(newvar, parent.classStruct.qualifiedName);
                        }
                        mapNewNames.put(newvar, varname);
                        mapNewTypes.put(newvar, vartype);
                    }
                    varindex += md.params[index++].stack_size;
                }
            }
            final HashMap<String, VarVersionPaar> mapFieldsToNewVars = new HashMap<String, VarVersionPaar>();
            ClassesProcessor.ClassNode clnode = child;
            while (clnode != null) {
                for (Map.Entry<String, VarVersionPaar> entry : clnode.mapFieldsToVars.entrySet()) {
                    VarVersionPaar newvar = new VarVersionPaar(meth.counter.getCounterAndIncrement(2), 0);
                    mapFieldsToNewVars.put(InterpreterUtil.makeUniqueKey(clnode.classStruct.qualifiedName, entry.getKey()), newvar);
                    String varname = null;
                    VarType vartype = null;
                    if (clnode.type != 1) {
                        MethodWrapper enclosing_method = clnode.parent.wrapper.getMethods().getWithKey(clnode.enclosingMethod);
                        varname = enclosing_method.varproc.getVarName(entry.getValue());
                        vartype = enclosing_method.varproc.getVarType(entry.getValue());
                        enclosing_method.varproc.setVarFinal(entry.getValue(), 2);
                    }
                    if (entry.getValue().var == -1 || "this".equals(varname)) {
                        varname = clnode.parent.simpleName == null ? "<VAR_NAMELESS_ENCLOSURE>" : clnode.parent.simpleName + ".this";
                        meth.varproc.getThisvars().put(newvar, clnode.parent.classStruct.qualifiedName);
                    }
                    mapNewNames.put(newvar, varname);
                    mapNewTypes.put(newvar, vartype);
                    if (clnode != child) continue;
                    StructField fd = child.classStruct.getFields().getWithKey(entry.getKey());
                    child.wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                }
                clnode = clnode.parent;
            }
            HashSet<String> setNewOuterNames = new HashSet<String>(mapNewNames.values());
            setNewOuterNames.removeAll(meth.setOuterVarNames);
            meth.varproc.refreshVarNames(new VarNamesCollector(setNewOuterNames));
            meth.setOuterVarNames.addAll(setNewOuterNames);
            for (Map.Entry<String, VarVersionPaar> entry : mapNewNames.entrySet()) {
                VarVersionPaar varpaar = (VarVersionPaar)((Object)entry.getKey());
                VarType vartype = (VarType)mapNewTypes.get(varpaar);
                meth.varproc.setVarName(varpaar, (String)((Object)entry.getValue()));
                if (vartype == null) continue;
                meth.varproc.setVarType(varpaar, vartype);
            }
            DirectGraph graph = meth.getOrBuildGraph();
            graph.iterateExprents(new DirectGraph.ExprentIterator(){

                @Override
                public int processExprent(Exprent exprent) {
                    InvocationExprent invexpr;
                    if (exprent.type == 2) {
                        FieldExprent fexpr;
                        AssignmentExprent asexpr = (AssignmentExprent)exprent;
                        if (asexpr.getLeft().type == 5 && (fexpr = (FieldExprent)asexpr.getLeft()).getClassname().equals(child.classStruct.qualifiedName) && mapFieldsToNewVars.containsKey(InterpreterUtil.makeUniqueKey(child.classStruct.qualifiedName, InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString)))) {
                            return 2;
                        }
                    }
                    if (child.type == 2 && "<init>".equals(meth.methodStruct.getName()) && exprent.type == 8 && (invexpr = (InvocationExprent)exprent).getFunctype() == 2) {
                        child.superInvocation = invexpr;
                        return 2;
                    }
                    this.replaceExprent(exprent);
                    return 0;
                }

                private Exprent replaceExprent(Exprent exprent) {
                    FieldExprent fexpr;
                    String keyField;
                    if (exprent.type == 12) {
                        int varindex = ((VarExprent)exprent).getIndex();
                        if (mapParamsToNewVars.containsKey(varindex)) {
                            VarVersionPaar newvar = (VarVersionPaar)mapParamsToNewVars.get(varindex);
                            meth.varproc.getExternvars().add(newvar);
                            return new VarExprent(newvar.var, meth.varproc.getVarType(newvar), meth.varproc);
                        }
                    } else if (exprent.type == 5 && mapFieldsToNewVars.containsKey(keyField = InterpreterUtil.makeUniqueKey((fexpr = (FieldExprent)exprent).getClassname(), InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString)))) {
                        VarVersionPaar newvar = (VarVersionPaar)mapFieldsToNewVars.get(keyField);
                        meth.varproc.getExternvars().add(newvar);
                        return new VarExprent(newvar.var, meth.varproc.getVarType(newvar), meth.varproc);
                    }
                    boolean replaced = true;
                    block0: while (replaced) {
                        replaced = false;
                        for (Exprent expr : exprent.getAllExprents()) {
                            Exprent retexpr = this.replaceExprent(expr);
                            if (retexpr == null) continue;
                            exprent.replaceExprent(expr, retexpr);
                            replaced = true;
                            continue block0;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static HashMap<String, List<VarFieldPair>> getMaskLocalVars(ClassWrapper wrapper) {
        HashMap<String, List<VarFieldPair>> mapMasks = new HashMap<String, List<VarFieldPair>>();
        StructClass cl = wrapper.getClassStruct();
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            MethodWrapper meth = wrapper.getMethodWrapper("<init>", mt.getDescriptor());
            DirectGraph graph = meth.getOrBuildGraph();
            if (graph == null) continue;
            ArrayList<VarFieldPair> fields = new ArrayList<VarFieldPair>();
            int varindex = 1;
            for (int i = 0; i < md.params.length; ++i) {
                String keyField = NestedClassProcessor.getEnclosingVarField(cl, meth, graph, varindex);
                fields.add(keyField == null ? null : new VarFieldPair(keyField, new VarVersionPaar(-1, 0)));
                varindex += md.params[i].stack_size;
            }
            mapMasks.put(mt.getDescriptor(), fields);
        }
        return mapMasks;
    }

    private static String getEnclosingVarField(StructClass cl, MethodWrapper meth, DirectGraph graph, int index) {
        String field = "";
        if (meth.varproc.getVarFinal(new VarVersionPaar(index, 0)) == 1) {
            return null;
        }
        boolean noSynthFlag = DecompilerContext.getOption("nns");
        DirectNode firstnode = graph.first;
        if (firstnode.preds.isEmpty()) {
            for (Exprent exprent : firstnode.exprents) {
                FieldExprent left;
                StructField fd;
                if (exprent.type != 2) continue;
                AssignmentExprent asexpr = (AssignmentExprent)exprent;
                if (asexpr.getRight().type != 12 || ((VarExprent)asexpr.getRight()).getIndex() != index || asexpr.getLeft().type != 5 || (fd = cl.getField((left = (FieldExprent)asexpr.getLeft()).getName(), left.getDescriptor().descriptorString)) == null || !cl.qualifiedName.equals(left.getClassname()) || !fd.hasModifier(16) || !fd.isSynthetic() && (!noSynthFlag || !fd.hasModifier(2))) continue;
                field = InterpreterUtil.makeUniqueKey(left.getName(), left.getDescriptor().descriptorString);
                break;
            }
        }
        return field;
    }

    private static void mergeListSignatures(List<VarFieldPair> first, List<VarFieldPair> second, boolean both) {
        int j;
        boolean eq;
        VarFieldPair sobj;
        int i;
        for (i = 1; first.size() > i && second.size() > i; ++i) {
            VarFieldPair fobj = first.get(first.size() - i);
            sobj = second.get(second.size() - i);
            eq = false;
            if (fobj == null || sobj == null) {
                eq = fobj == sobj;
            } else {
                eq = true;
                if (fobj.keyfield.length() == 0) {
                    fobj.keyfield = sobj.keyfield;
                } else if (sobj.keyfield.length() == 0) {
                    if (both) {
                        sobj.keyfield = fobj.keyfield;
                    }
                } else {
                    eq = fobj.keyfield.equals(sobj.keyfield);
                }
            }
            if (!eq) {
                first.set(first.size() - i, null);
                if (!both) continue;
                second.set(second.size() - i, null);
                continue;
            }
            if (fobj == null) continue;
            if (fobj.varpaar.var == -1) {
                fobj.varpaar = sobj.varpaar;
                continue;
            }
            sobj.varpaar = fobj.varpaar;
        }
        for (j = 1; j <= first.size() - i; ++j) {
            first.set(j, null);
        }
        if (both) {
            for (j = 1; j <= second.size() - i; ++j) {
                second.set(j, null);
            }
        }
        if (first.isEmpty()) {
            if (!second.isEmpty() && both) {
                second.set(0, null);
            }
        } else if (second.isEmpty()) {
            first.set(0, null);
        } else {
            VarFieldPair fobj = first.get(0);
            sobj = second.get(0);
            eq = false;
            if (fobj == null || sobj == null) {
                eq = fobj == sobj;
            } else {
                eq = true;
                if (fobj.keyfield.length() == 0) {
                    fobj.keyfield = sobj.keyfield;
                } else if (sobj.keyfield.length() == 0) {
                    if (both) {
                        sobj.keyfield = fobj.keyfield;
                    }
                } else {
                    eq = fobj.keyfield.equals(sobj.keyfield);
                }
            }
            if (!eq) {
                first.set(0, null);
                if (both) {
                    second.set(0, null);
                }
            } else if (fobj != null) {
                if (fobj.varpaar.var == -1) {
                    fobj.varpaar = sobj.varpaar;
                } else {
                    sobj.varpaar = fobj.varpaar;
                }
            }
        }
    }

    private static void setLocalClassDefinition(MethodWrapper meth, ClassesProcessor.ClassNode node) {
        Statement first;
        RootStatement root = meth.root;
        VarType classtype = new VarType(node.classStruct.qualifiedName, true);
        HashSet<Statement> setStats = new HashSet<Statement>();
        Statement stdef = NestedClassProcessor.getDefStatement(root, classtype, setStats);
        if (stdef == null) {
            stdef = root.getFirst();
        }
        List<Exprent> lst = (first = NestedClassProcessor.findFirstBlock(stdef, setStats)) == null ? stdef.getVarDefinitions() : (first.getExprents() == null ? first.getVarDefinitions() : first.getExprents());
        int addindex = 0;
        for (Exprent expr : lst) {
            if (NestedClassProcessor.searchForClass(expr, classtype)) break;
            ++addindex;
        }
        VarExprent var = new VarExprent(meth.counter.getCounterAndIncrement(2), classtype, meth.varproc);
        var.setDefinition(true);
        var.setClassdef(true);
        lst.add(addindex, var);
    }

    private static Statement findFirstBlock(Statement stat, HashSet<Statement> setStats) {
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.add(stat);
        block4: while (!stack.isEmpty()) {
            Statement st = (Statement)stack.remove(0);
            if (!stack.isEmpty() && !setStats.contains(st)) continue;
            if (st.isLabeled() && !stack.isEmpty()) {
                return st;
            }
            if (st.getExprents() != null) {
                return st;
            }
            stack.clear();
            switch (st.type) {
                case 15: {
                    stack.addAll(0, st.getStats());
                    continue block4;
                }
                case 2: 
                case 6: 
                case 10: 
                case 13: {
                    stack.add(st.getFirst());
                    continue block4;
                }
            }
            return st;
        }
        return null;
    }

    private static Statement getDefStatement(Statement stat, VarType classtype, HashSet<Statement> setStats) {
        List<Object> condlst = new ArrayList();
        Statement retstat = null;
        if (stat.getExprents() == null) {
            int counter = 0;
            for (Object obj : stat.getSequentialObjects()) {
                if (obj instanceof Statement) {
                    Statement st = (Statement)obj;
                    Statement stTemp = NestedClassProcessor.getDefStatement(st, classtype, setStats);
                    if (stTemp != null) {
                        if (counter == 1) {
                            retstat = stat;
                            break;
                        }
                        retstat = stTemp;
                        ++counter;
                    }
                    if (st.type != 5) continue;
                    DoStatement dost = (DoStatement)st;
                    condlst.addAll(dost.getInitExprentList());
                    condlst.addAll(dost.getConditionExprentList());
                    continue;
                }
                if (!(obj instanceof Exprent)) continue;
                condlst.add((Exprent)obj);
            }
        } else {
            condlst = stat.getExprents();
        }
        if (retstat != stat) {
            for (Exprent exprent : condlst) {
                if (exprent == null || !NestedClassProcessor.searchForClass(exprent, classtype)) continue;
                retstat = stat;
                break;
            }
        }
        if (retstat != null) {
            setStats.add(stat);
        }
        return retstat;
    }

    private static boolean searchForClass(Exprent exprent, VarType classtype) {
        List<Exprent> lst = exprent.getAllExprents(true);
        lst.add(exprent);
        String classname = classtype.value;
        for (Exprent expr : lst) {
            boolean res = false;
            switch (expr.type) {
                case 3: {
                    ConstExprent cexpr = (ConstExprent)expr;
                    res = VarType.VARTYPE_CLASS.equals(cexpr.getConsttype()) && classname.equals(cexpr.getValue()) || classtype.equals(cexpr.getConsttype());
                    break;
                }
                case 5: {
                    res = classname.equals(((FieldExprent)expr).getClassname());
                    break;
                }
                case 8: {
                    res = classname.equals(((InvocationExprent)expr).getClassname());
                    break;
                }
                case 10: {
                    VarType newType = expr.getExprType();
                    res = newType.type == 8 && classname.equals(newType.value);
                    break;
                }
                case 12: {
                    VarType vtype;
                    VarExprent vexpr = (VarExprent)expr;
                    if (!vexpr.isDefinition() || !classtype.equals(vtype = vexpr.getVartype()) && (vtype.arraydim <= 0 || !classtype.value.equals(vtype.value))) break;
                    res = true;
                }
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    private static class VarFieldPair {
        public String keyfield = "";
        public VarVersionPaar varpaar;

        public VarFieldPair(String field, VarVersionPaar varpaar) {
            this.keyfield = field;
            this.varpaar = varpaar;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof VarFieldPair)) {
                return false;
            }
            VarFieldPair pair = (VarFieldPair)o;
            return this.keyfield.equals(pair.keyfield) && this.varpaar.equals(pair.varpaar);
        }

        public int hashCode() {
            return this.keyfield.hashCode() + this.varpaar.hashCode();
        }
    }
}

