/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPaar;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;

public class NewExprent
extends Exprent {
    private InvocationExprent constructor;
    private VarType newtype;
    private List<Exprent> lstDims = new ArrayList<Exprent>();
    private List<Exprent> lstArrayElements = new ArrayList<Exprent>();
    private boolean directArrayInit;
    private boolean anonymous;
    private boolean lambda;
    private boolean enumconst;

    public NewExprent(VarType newtype, ListStack<Exprent> stack, int arraydim) {
        this.type = 10;
        this.newtype = newtype;
        for (int i = 0; i < arraydim; ++i) {
            this.lstDims.add(0, stack.pop());
        }
        this.setAnonymous();
    }

    public NewExprent(VarType newtype, List<Exprent> lstDims) {
        this.type = 10;
        this.newtype = newtype;
        this.lstDims = lstDims;
        this.setAnonymous();
    }

    private void setAnonymous() {
        ClassesProcessor.ClassNode node;
        this.anonymous = false;
        this.lambda = false;
        if (this.newtype.type == 8 && this.newtype.arraydim == 0 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newtype.value)) != null && (node.type == 2 || node.type == 8)) {
            this.anonymous = true;
            if (node.type == 8) {
                this.lambda = true;
            }
        }
    }

    @Override
    public VarType getExprType() {
        if (this.anonymous) {
            ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newtype.value);
            return node.anonymousClassType;
        }
        return this.newtype;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.newtype.arraydim != 0) {
            for (Exprent dim : this.lstDims) {
                result.addMinTypeExprent(dim, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(dim, VarType.VARTYPE_INT);
            }
            if (this.newtype.arraydim == 1) {
                VarType leftType = this.newtype.copy();
                leftType.decArrayDim();
                for (Exprent element : this.lstArrayElements) {
                    result.addMinTypeExprent(element, VarType.getMinTypeInFamily(leftType.type_family));
                    result.addMaxTypeExprent(element, leftType);
                }
            }
        } else if (this.constructor != null) {
            return this.constructor.checkExprTypeBounds();
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.newtype.arraydim == 0) {
            if (this.constructor != null) {
                Exprent constructor_instance = this.constructor.getInstance();
                if (constructor_instance != null) {
                    lst.add(constructor_instance);
                }
                lst.addAll(this.constructor.getLstParameters());
            }
        } else {
            lst.addAll(this.lstDims);
            lst.addAll(this.lstArrayElements);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstDims) {
            lst.add(expr.copy());
        }
        NewExprent ret = new NewExprent(this.newtype, lst);
        ret.setConstructor(this.constructor == null ? null : (InvocationExprent)this.constructor.copy());
        ret.setLstArrayElements(this.lstArrayElements);
        ret.setDirectArrayInit(this.directArrayInit);
        ret.setAnonymous(this.anonymous);
        ret.setEnumconst(this.enumconst);
        return ret;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        StringBuilder buf = new StringBuilder();
        if (this.anonymous) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newtype.value);
            buf.append("(");
            if (!this.lambda && this.constructor != null) {
                InvocationExprent invsuper = child.superInvocation;
                ClassesProcessor.ClassNode newnode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invsuper.getClassname());
                List<VarVersionPaar> sigFields = null;
                if (newnode != null) {
                    if (newnode.wrapper != null) {
                        sigFields = newnode.wrapper.getMethodWrapper((String)"<init>", (String)invsuper.getStringDescriptor()).signatureFields;
                    } else if (newnode.type == 1 && (newnode.access & 8) == 0 && !this.constructor.getLstParameters().isEmpty()) {
                        sigFields = new ArrayList<VarVersionPaar>(Collections.nCopies(this.constructor.getLstParameters().size(), null));
                        sigFields.set(0, new VarVersionPaar(-1, 0));
                    }
                }
                boolean firstpar = true;
                int start = 0;
                int end = invsuper.getLstParameters().size();
                if (this.enumconst) {
                    start += 2;
                    --end;
                }
                for (int i = start; i < end; ++i) {
                    int varindex;
                    if (sigFields != null && sigFields.get(i) != null) continue;
                    if (!firstpar) {
                        buf.append(", ");
                    }
                    Exprent param = invsuper.getLstParameters().get(i);
                    if (param.type == 12 && (varindex = ((VarExprent)param).getIndex()) > 0 && varindex <= this.constructor.getLstParameters().size()) {
                        param = this.constructor.getLstParameters().get(varindex - 1);
                    }
                    StringBuilder buff = new StringBuilder();
                    ExprProcessor.getCastedExprent(param, invsuper.getDescriptor().params[i], buff, indent, true, tracer);
                    buf.append((CharSequence)buff);
                    firstpar = false;
                }
            }
            if (!this.enumconst) {
                String enclosing = null;
                if (!this.lambda && this.constructor != null) {
                    enclosing = NewExprent.getQualifiedNewInstance(child.anonymousClassType.value, this.constructor.getLstParameters(), indent, tracer);
                }
                String typename = ExprProcessor.getCastTypeName(child.anonymousClassType);
                if (enclosing != null) {
                    ClassesProcessor.ClassNode anonimousNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(child.anonymousClassType.value);
                    typename = anonimousNode != null ? anonimousNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.insert(0, "new " + typename);
                if (enclosing != null) {
                    buf.insert(0, enclosing + ".");
                }
            }
            buf.append(")");
            if (this.enumconst && buf.length() == 2) {
                buf.setLength(0);
            }
            if (this.lambda) {
                if (!DecompilerContext.getOption("lac")) {
                    buf.setLength(0);
                }
                Exprent methodObject = this.constructor == null ? null : this.constructor.getInstance();
                new ClassWriter().classLambdaToJava(child, buf, methodObject, indent);
            } else {
                new ClassWriter().classToJava(child, buf, indent);
            }
        } else if (this.directArrayInit) {
            VarType leftType = this.newtype.copy();
            leftType.decArrayDim();
            buf.append("{");
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
            }
            buf.append("}");
        } else if (this.newtype.arraydim == 0) {
            if (this.constructor != null) {
                int start;
                List<Exprent> lstParameters = this.constructor.getLstParameters();
                ClassesProcessor.ClassNode newnode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.constructor.getClassname());
                List<VarVersionPaar> sigFields = null;
                if (newnode != null) {
                    if (newnode.wrapper != null) {
                        sigFields = newnode.wrapper.getMethodWrapper((String)"<init>", (String)this.constructor.getStringDescriptor()).signatureFields;
                    } else if (newnode.type == 1 && (newnode.access & 8) == 0 && !this.constructor.getLstParameters().isEmpty()) {
                        sigFields = new ArrayList<VarVersionPaar>(Collections.nCopies(lstParameters.size(), null));
                        sigFields.set(0, new VarVersionPaar(-1, 0));
                    }
                }
                int n = start = this.enumconst ? 2 : 0;
                if (!this.enumconst || start < lstParameters.size()) {
                    buf.append("(");
                    boolean firstpar = true;
                    for (int i = start; i < lstParameters.size(); ++i) {
                        if (sigFields != null && sigFields.get(i) != null) continue;
                        if (!firstpar) {
                            buf.append(", ");
                        }
                        StringBuilder buff = new StringBuilder();
                        ExprProcessor.getCastedExprent(lstParameters.get(i), this.constructor.getDescriptor().params[i], buff, indent, true, tracer);
                        buf.append((CharSequence)buff);
                        firstpar = false;
                    }
                    buf.append(")");
                }
            }
            if (!this.enumconst) {
                String enclosing = null;
                if (this.constructor != null) {
                    enclosing = NewExprent.getQualifiedNewInstance(this.newtype.value, this.constructor.getLstParameters(), indent, tracer);
                }
                String typename = ExprProcessor.getTypeName(this.newtype);
                if (enclosing != null) {
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newtype.value);
                    typename = newNode != null ? newNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.insert(0, "new " + typename);
                if (enclosing != null) {
                    buf.insert(0, enclosing + ".");
                }
            }
        } else {
            buf.append("new ").append(ExprProcessor.getTypeName(this.newtype));
            if (this.lstArrayElements.isEmpty()) {
                for (int i = 0; i < this.newtype.arraydim; ++i) {
                    buf.append("[").append(i < this.lstDims.size() ? this.lstDims.get(i).toJava(indent, tracer) : "").append("]");
                }
            } else {
                for (int i = 0; i < this.newtype.arraydim; ++i) {
                    buf.append("[]");
                }
                VarType leftType = this.newtype.copy();
                leftType.decArrayDim();
                buf.append("{");
                for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    StringBuilder buff = new StringBuilder();
                    ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buff, indent, false, tracer);
                    buf.append((CharSequence)buff);
                }
                buf.append("}");
            }
        }
        return buf.toString();
    }

    private static String getQualifiedNewInstance(String classname, List<Exprent> lstParams, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
        if (node != null && node.type != 0 && (node.access & 8) == 0 && !lstParams.isEmpty()) {
            Exprent enclosing = lstParams.get(0);
            boolean isQualifiedNew = false;
            if (enclosing.type == 12) {
                VarExprent varEnclosing = (VarExprent)enclosing;
                StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                String this_classname = varEnclosing.getProcessor().getThisvars().get(new VarVersionPaar(varEnclosing));
                if (!current_class.qualifiedName.equals(this_classname)) {
                    isQualifiedNew = true;
                }
            } else {
                isQualifiedNew = true;
            }
            if (isQualifiedNew) {
                return enclosing.toJava(indent, tracer);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof NewExprent)) {
            return false;
        }
        NewExprent ne = (NewExprent)o;
        return InterpreterUtil.equalObjects(this.newtype, ne.getNewtype()) && InterpreterUtil.equalLists(this.lstDims, ne.getLstDims()) && InterpreterUtil.equalObjects(this.constructor, ne.getConstructor()) && this.directArrayInit == ne.directArrayInit && InterpreterUtil.equalLists(this.lstArrayElements, ne.getLstArrayElements());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        int i;
        if (oldexpr == this.constructor) {
            this.constructor = (InvocationExprent)newexpr;
        }
        if (this.constructor != null) {
            this.constructor.replaceExprent(oldexpr, newexpr);
        }
        for (i = 0; i < this.lstDims.size(); ++i) {
            if (oldexpr != this.lstDims.get(i)) continue;
            this.lstDims.set(i, newexpr);
        }
        for (i = 0; i < this.lstArrayElements.size(); ++i) {
            if (oldexpr != this.lstArrayElements.get(i)) continue;
            this.lstArrayElements.set(i, newexpr);
        }
    }

    public InvocationExprent getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExprent constructor) {
        this.constructor = constructor;
    }

    public List<Exprent> getLstDims() {
        return this.lstDims;
    }

    public VarType getNewtype() {
        return this.newtype;
    }

    public List<Exprent> getLstArrayElements() {
        return this.lstArrayElements;
    }

    public void setLstArrayElements(List<Exprent> lstArrayElements) {
        this.lstArrayElements = lstArrayElements;
    }

    public boolean isDirectArrayInit() {
        return this.directArrayInit;
    }

    public void setDirectArrayInit(boolean directArrayInit) {
        this.directArrayInit = directArrayInit;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isEnumconst() {
        return this.enumconst;
    }

    public void setEnumconst(boolean enumconst) {
        this.enumconst = enumconst;
    }
}

