/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputLineReader {
    private static final Pattern LINE_BREAK = Pattern.compile("\\r?\\n");
    @NotNull
    private final String[] myLines;
    private final int myLineCount;
    private int myPosition;

    OutputLineReader(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/output/parser/OutputLineReader", "<init>"));
        }
        this.myLines = LINE_BREAK.split(text);
        this.myLineCount = this.myLines.length;
    }

    public int getLineCount() {
        return this.myLineCount;
    }

    @Nullable
    public String readLine() {
        if (this.myPosition >= 0 && this.myPosition < this.myLineCount) {
            return this.myLines[this.myPosition++];
        }
        return null;
    }

    @Nullable
    public String peek(int lineToSkipCount) {
        int tempPosition = lineToSkipCount + this.myPosition;
        if (tempPosition >= 0 && tempPosition < this.myLineCount) {
            return this.myLines[tempPosition];
        }
        return null;
    }

    public boolean hasNextLine() {
        return this.myPosition < this.myLineCount - 1;
    }

    public void skipNextLine() {
        ++this.myPosition;
    }

    public void pushBack(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/output/parser/OutputLineReader", "pushBack"));
        }
        --this.myPosition;
    }
}

