/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesReferenceProvider;
import com.intellij.lang.properties.ResourceBundleReferenceProvider;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PropertiesReferenceContributor
extends PsiReferenceContributor {
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider(){

        public boolean isSoft() {
            return true;
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/properties/PropertiesReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression(), (PsiReferenceProvider)new PropertiesReferenceProvider(true));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().withParent((ElementPattern)PsiJavaPatterns.psiNameValuePair().withName("resourceBundle")), (PsiReferenceProvider)new ResourceBundleReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyValueImpl.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/PropertiesReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/properties/PropertiesReferenceContributor$2", "getReferencesByElement"));
                }
                String text = element.getText();
                String[] words = text.split("\\s");
                if (words.length != 1) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = CLASS_REFERENCE_PROVIDER.getReferencesByString(words[0], element, 0);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

