/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraRemoteApi {
    protected final JiraRepository myRepository;

    protected JiraRemoteApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi", "<init>"));
        }
        this.myRepository = repository;
    }

    @NotNull
    public abstract List<Task> findTasks(@NotNull String var1, int var2) throws Exception;

    @Nullable
    public abstract Task findTask(@NotNull String var1) throws Exception;

    public abstract void setTaskState(@NotNull Task var1, @NotNull TaskState var2) throws Exception;

    public abstract void updateTimeSpend(@NotNull LocalTask var1, @NotNull String var2, String var3) throws Exception;

    @NotNull
    public final String getVersionName() {
        String string = this.getType().getVersionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi", "getVersionName"));
        }
        return string;
    }

    public final String toString() {
        return "JiraRemoteApi(" + this.getType().getVersionName() + ")";
    }

    @NotNull
    public abstract ApiType getType();

    public static enum ApiType {
        LEGACY("XML-RPC + RSS"){

            @Override
            @NotNull
            public JiraLegacyApi createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$1", "createApi"));
                }
                JiraLegacyApi jiraLegacyApi = new JiraLegacyApi(repository);
                if (jiraLegacyApi == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$1", "createApi"));
                }
                return jiraLegacyApi;
            }
        }
        ,
        REST_2_0("REST 2.0"){

            @Override
            @NotNull
            public JiraRestApi2 createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$2", "createApi"));
                }
                JiraRestApi2 jiraRestApi2 = new JiraRestApi2(repository);
                if (jiraRestApi2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$2", "createApi"));
                }
                return jiraRestApi2;
            }
        }
        ,
        REST_2_0_ALPHA("REST 2.0.alpha1"){

            @Override
            @NotNull
            public JiraRestApi20Alpha1 createApi(@NotNull JiraRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$3", "createApi"));
                }
                JiraRestApi20Alpha1 jiraRestApi20Alpha1 = new JiraRestApi20Alpha1(repository);
                if (jiraRestApi20Alpha1 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi$ApiType$3", "createApi"));
                }
                return jiraRestApi20Alpha1;
            }
        };

        private String myVersionName;

        private ApiType(String versionName) {
            this.myVersionName = versionName;
        }

        @NotNull
        public abstract JiraRemoteApi createApi(@NotNull JiraRepository var1);

        @NotNull
        public String getVersionName() {
            String string = this.myVersionName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRemoteApi$ApiType", "getVersionName"));
            }
            return string;
        }
    }
}

