/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelativeOverlapDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("RelativeOverlap", "Overlapping items in RelativeLayout", "If relative layout has text or button items aligned to left and right sides they can overlap each other due to localized text expansion unless they have mutual constraints like `toEndOf`/`toStartOf`.", Category.I18N, 3, Severity.WARNING, new Implementation(RelativeOverlapDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("RelativeLayout");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        NodeList childNodes = element.getChildNodes();
        int count = childNodes.getLength();
        HashMap nodes = Maps.newHashMap();
        for (int i = 0; i < count; ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            LayoutNode ln = new LayoutNode((Element)node, i);
            nodes.put(ln.getNodeId(), ln);
        }
        for (LayoutNode ln : nodes.values()) {
            ln.processNode(nodes);
        }
        for (LayoutNode right : nodes.values()) {
            if (!right.mLastLeft || right.skip()) continue;
            Set<LayoutNode> canGrowLeft = right.canGrowLeft();
            for (LayoutNode left : nodes.values()) {
                if (left == right || !left.mLastRight || left.skip() || !left.sameBucket(right)) continue;
                Set<LayoutNode> canGrowRight = left.canGrowRight();
                if (canGrowLeft.size() <= 0 && canGrowRight.size() <= 0) continue;
                canGrowRight.addAll(canGrowLeft);
                LayoutNode nodeToBlame = right;
                LayoutNode otherNode = left;
                if (!canGrowRight.contains(right) && canGrowRight.contains(left)) {
                    nodeToBlame = left;
                    otherNode = right;
                }
                context.report(ISSUE, nodeToBlame.getNode(), context.getLocation(nodeToBlame.getNode()), String.format("`%1$s` can overlap `%2$s` if %3$s %4$s due to localized text expansion", nodeToBlame.getNodeId(), otherNode.getNodeId(), Joiner.on((String)", ").join(canGrowRight), canGrowRight.size() > 1 ? "grow" : "grows"));
            }
        }
    }

    private static class LayoutNode {
        private int mIndex;
        private boolean mProcessed;
        private Element mNode;
        private Bucket mBucket;
        private LayoutNode mToLeft;
        private LayoutNode mToRight;
        private boolean mLastLeft;
        private boolean mLastRight;

        public LayoutNode(@NonNull Element node, int index) {
            this.mNode = node;
            this.mIndex = index;
            this.mProcessed = false;
            this.mLastLeft = true;
            this.mLastRight = true;
        }

        @NonNull
        public String getNodeId() {
            String nodeid = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (nodeid.isEmpty()) {
                return String.format("%1$s-%2$d", this.mNode.getTagName(), this.mIndex);
            }
            return LayoutNode.uniformId(nodeid);
        }

        @NonNull
        public String getNodeTextId() {
            String text = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", "text");
            if (text.isEmpty()) {
                return this.getNodeId();
            }
            return LayoutNode.uniformId(text);
        }

        @NonNull
        public String toString() {
            return this.getNodeTextId();
        }

        public boolean isInvisible() {
            String visibility = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", "visibility");
            return visibility.equals("gone") || visibility.equals("invisible");
        }

        public boolean fixedWidth() {
            String width = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
            if (width.equals("wrap_content")) {
                NodeList childNodes = this.mNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    LayoutNode childLayout;
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 1 || (childLayout = new LayoutNode((Element)child, i)).fixedWidth()) continue;
                    return false;
                }
                String text = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", "text");
                if (!text.isEmpty()) {
                    return !text.startsWith("@") && !text.startsWith("?");
                }
                String nodeName = this.mNode.getTagName();
                if (nodeName.contains("Image") || nodeName.contains("Progress") || nodeName.contains("Radio")) {
                    return true;
                }
                if (nodeName.contains("Button") || nodeName.contains("Text")) {
                    return false;
                }
            }
            return true;
        }

        @NonNull
        public Element getNode() {
            return this.mNode;
        }

        public void processNode(@NonNull Map<String, LayoutNode> nodes) {
            if (this.mProcessed) {
                return;
            }
            this.mProcessed = true;
            if (this.isInvisible() || this.hasAttr("layout_alignRight") || this.hasAttr("layout_alignEnd") || this.hasAttr("layout_alignLeft") || this.hasAttr("layout_alignStart")) {
                this.mBucket = Bucket.SKIP;
            } else if (this.hasTrueAttr("layout_alignParentTop")) {
                this.mBucket = Bucket.TOP;
            } else if (this.hasTrueAttr("layout_alignParentBottom")) {
                this.mBucket = Bucket.BOTTOM;
            } else if (this.hasAttr("layout_above") || this.hasAttr("layout_below")) {
                this.mBucket = Bucket.SKIP;
            } else {
                String[] checkAlignment;
                for (String alignment : checkAlignment = new String[]{"layout_alignTop", "layout_alignBottom", "layout_alignBaseline"}) {
                    LayoutNode otherNode;
                    String value = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", alignment);
                    if (value.isEmpty() || (otherNode = nodes.get(LayoutNode.uniformId(value))) == null) continue;
                    otherNode.processNode(nodes);
                    this.mBucket = otherNode.mBucket;
                }
            }
            if (this.mBucket == null) {
                this.mBucket = Bucket.TOP;
            }
            this.mToLeft = this.findNodeByAttr(nodes, "layout_toStartOf");
            if (this.mToLeft == null) {
                this.mToLeft = this.findNodeByAttr(nodes, "layout_toLeftOf");
            }
            if (this.mToLeft != null) {
                this.mToLeft.mLastLeft = false;
                this.mLastRight = false;
            }
            this.mToRight = this.findNodeByAttr(nodes, "layout_toEndOf");
            if (this.mToRight == null) {
                this.mToRight = this.findNodeByAttr(nodes, "layout_toRightOf");
            }
            if (this.mToRight != null) {
                this.mToRight.mLastLeft = false;
                this.mLastRight = false;
            }
            if (this.hasTrueAttr("layout_alignParentEnd") || this.hasTrueAttr("layout_alignParentRight")) {
                this.mLastRight = false;
            }
            if (this.hasTrueAttr("layout_alignParentStart") || this.hasTrueAttr("layout_alignParentLeft")) {
                this.mLastLeft = false;
            }
            if (this.mToLeft == null && this.mToRight == null && this.mLastRight && this.mLastLeft) {
                this.mLastLeft = false;
            }
        }

        @NonNull
        public Set<LayoutNode> canGrowLeft() {
            Set<LayoutNode> nodes = this.mToRight != null ? this.mToRight.canGrowLeft() : new LinkedHashSet<LayoutNode>();
            if (!this.fixedWidth()) {
                nodes.add(this);
            }
            return nodes;
        }

        @NonNull
        public Set<LayoutNode> canGrowRight() {
            Set<LayoutNode> nodes = this.mToLeft != null ? this.mToLeft.canGrowRight() : new LinkedHashSet<LayoutNode>();
            if (!this.fixedWidth()) {
                nodes.add(this);
            }
            return nodes;
        }

        public boolean skip() {
            if (this.mBucket == Bucket.SKIP) {
                return true;
            }
            return this.mNode.getTagName().equals("include") || this.mNode.getTagName().equals("View");
        }

        public boolean sameBucket(@NonNull LayoutNode node) {
            return this.mBucket == node.mBucket;
        }

        @Nullable
        private LayoutNode findNodeByAttr(@NonNull Map<String, LayoutNode> nodes, @NonNull String attrName) {
            String value = this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", attrName);
            if (!value.isEmpty()) {
                return nodes.get(LayoutNode.uniformId(value));
            }
            return null;
        }

        private boolean hasAttr(@NonNull String key) {
            return this.mNode.hasAttributeNS("http://schemas.android.com/apk/res/android", key);
        }

        private boolean hasTrueAttr(@NonNull String key) {
            return this.mNode.getAttributeNS("http://schemas.android.com/apk/res/android", key).equals("true");
        }

        @NonNull
        private static String uniformId(@NonNull String value) {
            return value.replaceFirst("@\\+", "@");
        }

        private static enum Bucket {
            TOP,
            BOTTOM,
            SKIP;

        }
    }
}

