/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.If;
import lombok.ast.InlineIfExpression;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReferencePart;
import lombok.ast.VariableDefinition;

public class ViewHolderDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ViewHolderDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ViewHolder", "View Holder Candidates", "When implementing a view Adapter, you should avoid unconditionally inflating a new layout; if an available item is passed in for reuse, you should try to use that one instead. This helps make for example ListView scrolling much smoother.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/improving-layouts/smooth-scrolling.html#ViewHolder");
    private static final String GET_VIEW = "getView";
    static final String INFLATE = "inflate";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(MethodDeclaration.class);
    }

    @Override
    public AstVisitor createJavaVisitor(@NonNull JavaContext context) {
        return new ViewAdapterVisitor(context);
    }

    private static class InflationVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private List<Node> mNodes;
        private boolean mHaveConditional;

        public InflationVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            String methodName;
            if (node.astOperand() != null && (methodName = node.astName().astValue()).equals(ViewHolderDetector.INFLATE) && node.astArguments().size() >= 1) {
                boolean insideIf = false;
                for (Node p = node.getParent(); p != null; p = p.getParent()) {
                    if (p instanceof If || p instanceof InlineIfExpression) {
                        insideIf = true;
                        this.mHaveConditional = true;
                        break;
                    }
                    if (p == node) break;
                }
                if (!insideIf) {
                    if (this.mNodes == null) {
                        this.mNodes = Lists.newArrayList();
                    }
                    this.mNodes.add((Node)node);
                }
            }
            return super.visitMethodInvocation(node);
        }

        public void finish() {
            if (!this.mHaveConditional && this.mNodes != null) {
                for (Node node : this.mNodes) {
                    String message = "Unconditional layout inflation from view adapter: Should use View Holder pattern (use recycled view passed into this method as the second parameter) for smoother scrolling";
                    this.mContext.report(ISSUE, node, this.mContext.getLocation(node), message);
                }
            }
        }
    }

    private static class ViewAdapterVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public ViewAdapterVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitMethodDeclaration(MethodDeclaration node) {
            if (ViewAdapterVisitor.isViewAdapterMethod(node)) {
                InflationVisitor visitor = new InflationVisitor(this.mContext);
                node.accept((AstVisitor)visitor);
                visitor.finish();
            }
            return super.visitMethodDeclaration(node);
        }

        private static boolean isViewAdapterMethod(MethodDeclaration node) {
            StrictListAccessor parameters;
            if (ViewHolderDetector.GET_VIEW.equals(node.astMethodName().astValue()) && (parameters = node.astParameters()) != null && parameters.size() == 3) {
                Iterator iterator = parameters.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                VariableDefinition first = (VariableDefinition)iterator.next();
                if (!((TypeReferencePart)first.astTypeReference().astParts().last()).getTypeName().equals("int")) {
                    return false;
                }
                if (!iterator.hasNext()) {
                    return false;
                }
                VariableDefinition second = (VariableDefinition)iterator.next();
                if (!((TypeReferencePart)second.astTypeReference().astParts().last()).getTypeName().equals("View")) {
                    return false;
                }
                if (!iterator.hasNext()) {
                    return false;
                }
                VariableDefinition third = (VariableDefinition)iterator.next();
                return ((TypeReferencePart)third.astTypeReference().astParts().last()).getTypeName().equals("ViewGroup");
            }
            return false;
        }
    }
}

