/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.DefaultExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectSerializer;

@Order(value=42)
public class ExternalProjectDataService
implements ProjectDataService<ExternalProject, Project> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataService.class);
    @NotNull
    public static final Key<ExternalProject> KEY = Key.create(ExternalProject.class, (int)(ProjectKeys.TASK.getProcessingWeight() + 1));
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, ExternalProject> myExternalRootProjects;
    @NotNull
    private ProjectDataManager myProjectDataManager;

    public ExternalProjectDataService(@NotNull ProjectDataManager projectDataManager) {
        if (projectDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataManager", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "<init>"));
        }
        this.myProjectDataManager = projectDataManager;
        this.myExternalRootProjects = new ConcurrentFactoryMap<Pair<ProjectSystemId, File>, ExternalProject>(){

            @Nullable
            protected ExternalProject create(Pair<ProjectSystemId, File> key) {
                return new ExternalProjectSerializer().load((ProjectSystemId)key.first, (File)key.second);
            }

            public ExternalProject put(Pair<ProjectSystemId, File> key, ExternalProject value) {
                new ExternalProjectSerializer().save(value);
                return (ExternalProject)super.put(key, (Object)value);
            }
        };
    }

    @NotNull
    public Key<ExternalProject> getTargetDataKey() {
        Key<ExternalProject> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ExternalProject>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "importData"));
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single external project but got %d: %s", toImport.size(), toImport));
        }
        this.saveExternalProject((ExternalProject)toImport.iterator().next().getData());
    }

    public void removeData(@NotNull Collection<? extends Project> modules, @NotNull Project project, boolean synchronous) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "removeData"));
        }
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull ProjectSystemId systemId, @NotNull File projectRootDir) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "getRootExternalProject"));
        }
        if (projectRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectRootDir", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "getRootExternalProject"));
        }
        return this.myExternalRootProjects.get(Pair.create((Object)systemId, (Object)projectRootDir));
    }

    public void saveExternalProject(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "saveExternalProject"));
        }
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)new ProjectSystemId(externalProject.getExternalSystemId()), (Object)externalProject.getProjectDir()), (ExternalProject)new DefaultExternalProject(externalProject));
    }

    @Nullable
    public ExternalProject findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        if (parentProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentProject", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "findExternalProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "findExternalProject"));
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        return externalProjectId != null ? ExternalProjectDataService.findExternalProject(parentProject, externalProjectId) : null;
    }

    @Nullable
    private static ExternalProject findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId) {
        if (parentProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentProject", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "findExternalProject"));
        }
        if (externalProjectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectId", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "findExternalProject"));
        }
        if (parentProject.getQName().equals(externalProjectId)) {
            return parentProject;
        }
        if (parentProject.getChildProjects().containsKey(externalProjectId)) {
            return (ExternalProject)parentProject.getChildProjects().get(externalProjectId);
        }
        for (ExternalProject externalProject : parentProject.getChildProjects().values()) {
            ExternalProject project = ExternalProjectDataService.findExternalProject(externalProject, externalProjectId);
            if (project == null) continue;
            return project;
        }
        return null;
    }
}

