/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class SvnRootsDetector {
    private static final Logger LOG = Logger.getInstance(SvnRootsDetector.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final SvnFileUrlMappingImpl myMapping;
    @NotNull
    private final Result myResult;
    @NotNull
    private final RepositoryRoots myRepositoryRoots;
    @NotNull
    private final NestedCopiesHolder myNestedCopiesHolder;

    public SvnRootsDetector(@NotNull SvnVcs vcs, @NotNull SvnFileUrlMappingImpl mapping, @NotNull NestedCopiesHolder holder) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnRootsDetector", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/idea/svn/SvnRootsDetector", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/svn/SvnRootsDetector", "<init>"));
        }
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myResult = new Result();
        this.myNestedCopiesHolder = holder;
        this.myRepositoryRoots = new RepositoryRoots(this.myVcs);
    }

    public void detectCopyRoots(VirtualFile[] roots, boolean clearState, Runnable callback) {
        for (VirtualFile vcsRoot : roots) {
            List<Node> foundRoots = new ForNestedRootChecker(this.myVcs).getAllNestedWorkingCopies(vcsRoot, false);
            this.registerLonelyRoots(vcsRoot, foundRoots);
            this.registerTopRoots(vcsRoot, foundRoots);
        }
        this.addNestedRoots(clearState, callback);
    }

    private void registerLonelyRoots(VirtualFile vcsRoot, List<Node> foundRoots) {
        if (foundRoots.isEmpty()) {
            this.myResult.myLonelyRoots.add(vcsRoot);
        }
    }

    private void registerTopRoots(@NotNull VirtualFile vcsRoot, @NotNull List<Node> foundRoots) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/jetbrains/idea/svn/SvnRootsDetector", "registerTopRoots"));
        }
        if (foundRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundRoots", "org/jetbrains/idea/svn/SvnRootsDetector", "registerTopRoots"));
        }
        for (Node foundRoot : foundRoots) {
            RootUrlInfo root = new RootUrlInfo(foundRoot, SvnFormatSelector.findRootAndGetFormat(foundRoot.getIoFile()), vcsRoot);
            if (!foundRoot.hasError()) {
                this.myRepositoryRoots.register(foundRoot.getRepositoryRootUrl());
                this.myResult.myTopRoots.add(root);
                continue;
            }
            this.myResult.myErrorRoots.add(root);
        }
    }

    private void addNestedRoots(final boolean clearState, final Runnable callback) {
        final List basicVfRoots = ObjectsConvertor.convert((Collection)this.myResult.myTopRoots, (Convertor)new Convertor<RootUrlInfo, VirtualFile>(){

            public VirtualFile convert(RootUrlInfo real) {
                return real.getVirtualFile();
            }
        });
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        if (clearState) {
            this.myNestedCopiesHolder.getAndClear();
        }
        clManager.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                ArrayList nestedRoots = new ArrayList();
                for (NestedCopyInfo info : SvnRootsDetector.this.myNestedCopiesHolder.getAndClear()) {
                    if (NestedCopyType.external.equals((Object)info.getType()) || NestedCopyType.switched.equals((Object)info.getType())) {
                        RootUrlInfo topRoot = SvnRootsDetector.this.findTopRoot(VfsUtilCore.virtualToIoFile((VirtualFile)info.getFile()));
                        if (topRoot != null) {
                            topRoot.setType(info.getType());
                            continue;
                        }
                        if (!SvnRootsDetector.this.refreshPointInfo(info)) continue;
                    }
                    SvnRootsDetector.this.registerRootUrlFromNestedPoint(info, nestedRoots);
                }
                SvnRootsDetector.this.myResult.myTopRoots.addAll(nestedRoots);
                SvnRootsDetector.this.myMapping.applyDetectionResult(SvnRootsDetector.this.myResult);
                callback.run();
            }
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, null, (Consumer)new Consumer<VcsDirtyScopeManager>(){

            public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                if (clearState) {
                    vcsDirtyScopeManager.filesDirty(null, (Collection)basicVfRoots);
                }
            }
        }, null);
    }

    private void registerRootUrlFromNestedPoint(@NotNull NestedCopyInfo info, @NotNull List<RootUrlInfo> nestedRoots) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/SvnRootsDetector", "registerRootUrlFromNestedPoint"));
        }
        if (nestedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nestedRoots", "org/jetbrains/idea/svn/SvnRootsDetector", "registerRootUrlFromNestedPoint"));
        }
        RootUrlInfo topRoot = this.findAncestorTopRoot(info.getFile());
        if (topRoot != null) {
            SVNURL repoRoot = info.getRootURL();
            SVNURL sVNURL = repoRoot = repoRoot == null ? this.myRepositoryRoots.ask(info.getUrl(), info.getFile()) : repoRoot;
            if (repoRoot != null) {
                Node node = new Node(info.getFile(), info.getUrl(), repoRoot);
                nestedRoots.add(new RootUrlInfo(node, info.getFormat(), topRoot.getRoot(), info.getType()));
            }
        }
    }

    private boolean refreshPointInfo(@NotNull NestedCopyInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/SvnRootsDetector", "refreshPointInfo"));
        }
        boolean refreshed = false;
        try {
            File infoFile = VfsUtilCore.virtualToIoFile((VirtualFile)info.getFile());
            Status svnStatus = SvnUtil.getStatus(this.myVcs, infoFile);
            if (svnStatus != null && svnStatus.getURL() != null) {
                info.setUrl(svnStatus.getURL());
                info.setFormat(this.myVcs.getWorkingCopyFormat(infoFile, false));
                if (svnStatus.getRepositoryRootURL() != null) {
                    info.setRootURL(svnStatus.getRepositoryRootURL());
                }
                refreshed = true;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return refreshed;
    }

    @Nullable
    private RootUrlInfo findTopRoot(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnRootsDetector", "findTopRoot"));
        }
        return (RootUrlInfo)ContainerUtil.find((Iterable)this.myResult.myTopRoots, (Condition)new Condition<RootUrlInfo>(){

            public boolean value(RootUrlInfo topRoot) {
                return FileUtil.filesEqual((File)topRoot.getIoFile(), (File)file);
            }
        });
    }

    @Nullable
    private RootUrlInfo findAncestorTopRoot(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnRootsDetector", "findAncestorTopRoot"));
        }
        return (RootUrlInfo)ContainerUtil.find((Iterable)this.myResult.myTopRoots, (Condition)new Condition<RootUrlInfo>(){

            public boolean value(RootUrlInfo topRoot) {
                return VfsUtilCore.isAncestor((VirtualFile)topRoot.getVirtualFile(), (VirtualFile)file, (boolean)true);
            }
        });
    }

    public static class Result {
        @NotNull
        private final List<VirtualFile> myLonelyRoots;
        @NotNull
        private final List<RootUrlInfo> myTopRoots = new ArrayList<RootUrlInfo>();
        @NotNull
        private final List<RootUrlInfo> myErrorRoots = new ArrayList<RootUrlInfo>();

        public Result() {
            this.myLonelyRoots = new ArrayList<VirtualFile>();
        }

        @NotNull
        public List<VirtualFile> getLonelyRoots() {
            List<VirtualFile> list = this.myLonelyRoots;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRootsDetector$Result", "getLonelyRoots"));
            }
            return list;
        }

        @NotNull
        public List<RootUrlInfo> getTopRoots() {
            List<RootUrlInfo> list = this.myTopRoots;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRootsDetector$Result", "getTopRoots"));
            }
            return list;
        }

        @NotNull
        public List<RootUrlInfo> getErrorRoots() {
            List<RootUrlInfo> list = this.myErrorRoots;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnRootsDetector$Result", "getErrorRoots"));
            }
            return list;
        }
    }

    private static class RepositoryRoots {
        private final SvnVcs myVcs;
        private final Set<SVNURL> myRoots;

        private RepositoryRoots(SvnVcs vcs) {
            this.myVcs = vcs;
            this.myRoots = new HashSet<SVNURL>();
        }

        public void register(SVNURL url) {
            this.myRoots.add(url);
        }

        public SVNURL ask(SVNURL url, VirtualFile file) {
            for (SVNURL root : this.myRoots) {
                if (!root.equals((Object)SVNURLUtil.getCommonURLAncestor((SVNURL)root, (SVNURL)url))) continue;
                return root;
            }
            SVNURL newUrl = SvnUtil.getRepositoryRoot(this.myVcs, new File(file.getPath()));
            if (newUrl != null) {
                this.myRoots.add(newUrl);
                return newUrl;
            }
            return null;
        }
    }
}

