/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdHistoryClient
extends BaseSvnClient
implements HistoryClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public void doLog(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, @Nullable String[] revisionProperties, @Nullable LogEntryConsumer logEntryConsumer) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevision", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endRevision", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        List<String> parameters = CmdHistoryClient.prepareCommand(target, startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit);
        try {
            void handler;
            CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.log, parameters, null);
            CmdHistoryClient.parseOutput(command, (LogEntryConsumer)handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static void parseOutput(@NotNull CommandExecutor command, @Nullable LogEntryConsumer handler) throws VcsException, SVNException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/history/CmdHistoryClient", "parseOutput"));
        }
        try {
            LogInfo log = CommandUtil.parse(command.getOutput(), LogInfo.class);
            if (handler != null && log != null) {
                for (LogEntry.Builder entry : log.entries) {
                    CmdHistoryClient.iterateRecursively(entry, handler);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void iterateRecursively(@NotNull LogEntry.Builder entry, @NotNull LogEntryConsumer handler) throws SVNException {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/history/CmdHistoryClient", "iterateRecursively"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/history/CmdHistoryClient", "iterateRecursively"));
        }
        handler.consume(entry.build());
        for (LogEntry.Builder childEntry : entry.getChildEntries()) {
            CmdHistoryClient.iterateRecursively(childEntry, handler);
        }
        if (entry.hasChildren()) {
            handler.consume(LogEntry.EMPTY);
        }
    }

    private static List<String> prepareCommand(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevision", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endRevision", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        parameters.add("--revision");
        parameters.add(startRevision + ":" + endRevision);
        CommandUtil.put(parameters, stopOnCopy, "--stop-on-copy");
        CommandUtil.put(parameters, discoverChangedPaths, "--verbose");
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        if (limit > 0L) {
            parameters.add("--limit");
            parameters.add(String.valueOf(limit));
        }
        parameters.add("--xml");
        return parameters;
    }

    @XmlRootElement(name="log")
    public static class LogInfo {
        @XmlElement(name="logentry")
        public List<LogEntry.Builder> entries = ContainerUtil.newArrayList();
    }
}

