/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jetbrains.idea.svn.NativeLogReader;
import org.jetbrains.idea.svn.SSLExceptionsHelper;
import org.jetbrains.idea.svn.SvnNativeLogParser;
import org.jetbrains.idea.svn.networking.SSLProtocolExceptionParser;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnKitDebugLogger
extends SVNDebugLogAdapter {
    private final boolean myLoggingEnabled;
    private final boolean myLogNative;
    private final Logger myLog;
    private static final long ourErrorNotificationInterval = TimeUnit.MINUTES.toMillis(2L);
    private long myPreviousTime = 0L;

    public SvnKitDebugLogger(boolean loggingEnabled, boolean logNative, Logger log) {
        this.myLoggingEnabled = loggingEnabled;
        this.myLogNative = logNative;
        this.myLog = log;
    }

    private boolean shouldLog(SVNLogType logType) {
        return this.myLoggingEnabled || this.myLogNative && SVNLogType.NATIVE_CALL.equals(logType);
    }

    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        this.handleSpecificSSLExceptions(th);
        if (this.shouldLog(logType)) {
            this.myLog.info(th);
        }
    }

    private void handleSpecificSSLExceptions(Throwable th) {
        String message;
        long time = System.currentTimeMillis();
        if (time - this.myPreviousTime <= ourErrorNotificationInterval) {
            return;
        }
        if (th instanceof SSLHandshakeException) {
            if (th.getCause() instanceof SVNSSLUtil.CertificateNotTrustedException) {
                this.myLog.info(th);
                return;
            }
            this.myPreviousTime = time;
            String info = SSLExceptionsHelper.getAddInfo();
            String string = info = info == null ? "" : " (" + info + ") ";
            if (th.getCause() instanceof CertificateException) {
                PopupUtil.showBalloonForActiveFrame((String)("Subversion: " + info + th.getCause().getMessage()), (MessageType)MessageType.ERROR);
            } else {
                String postMessage = "\nPlease check Subversion SSL settings (Settings | Version Control | Subversion | Network)\nMaybe you should specify SSL protocol manually - SSLv3 or TLSv1";
                PopupUtil.showBalloonForActiveFrame((String)("Subversion: " + info + th.getMessage() + "\nPlease check Subversion SSL settings (Settings | Version Control | Subversion | Network)\nMaybe you should specify SSL protocol manually - SSLv3 or TLSv1"), (MessageType)MessageType.ERROR);
            }
        } else if (th instanceof SSLProtocolException && !StringUtil.isEmptyOrSpaces((String)(message = th.getMessage()))) {
            this.myPreviousTime = time;
            String info = SSLExceptionsHelper.getAddInfo();
            info = info == null ? "" : " (" + info + ") ";
            SSLProtocolExceptionParser parser = new SSLProtocolExceptionParser(message);
            parser.parse();
            String errMessage = "Subversion: " + info + parser.getParsedMessage();
            PopupUtil.showBalloonForActiveFrame((String)errMessage, (MessageType)MessageType.ERROR);
        }
    }

    public void log(SVNLogType logType, String message, Level logLevel) {
        if (SVNLogType.NATIVE_CALL.equals(logType)) {
            SvnKitDebugLogger.logNative(message);
        }
        if (this.shouldLog(logType)) {
            this.myLog.info(message);
        }
    }

    private static void logNative(String message) {
        if (message == null) {
            return;
        }
        NativeLogReader.CallInfo callInfo = SvnNativeLogParser.parse(message);
        if (callInfo == null) {
            return;
        }
        NativeLogReader.putInfo(callInfo);
    }

    public void log(SVNLogType logType, String message, byte[] data) {
        if (this.shouldLog(logType)) {
            if (data != null) {
                try {
                    this.myLog.info(message + "\n" + new String(data, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.myLog.info(message + "\n" + new String(data));
                }
            } else {
                this.myLog.info(message);
            }
        }
    }
}

