/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalInspectionTool
extends InspectionProfileEntry {
    public static final LocalInspectionTool[] EMPTY_ARRAY = new LocalInspectionTool[0];
    private static final Logger LOG = Logger.getInstance((String)("#" + LocalInspectionTool.class.getName()));
    @NonNls
    @Language(value="RegExp")
    public static final String VALID_ID_PATTERN = "[a-zA-Z_0-9.-]+";

    public static boolean isValidID(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/LocalInspectionTool", "isValidID"));
        }
        return !id.isEmpty() && id.matches(VALID_ID_PATTERN);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NonNls
    @NotNull
    public String getID() {
        String id;
        if (this.myNameProvider instanceof LocalDefaultNameProvider && (id = ((LocalDefaultNameProvider)this.myNameProvider).getDefaultID()) != null) {
            String string = id;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalInspectionTool", "getID"));
            }
            return string;
        }
        String string = this.getShortName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalInspectionTool", "getID"));
        }
        return string;
    }

    @Override
    protected String getSuppressId() {
        return this.getID();
    }

    @Override
    @NonNls
    @Nullable
    public String getAlternativeID() {
        if (this.myNameProvider instanceof LocalDefaultNameProvider) {
            return ((LocalDefaultNameProvider)this.myNameProvider).getDefaultAlternativeID();
        }
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LocalInspectionTool", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LocalInspectionTool", "checkFile"));
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LocalInspectionTool", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/LocalInspectionTool", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = this.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalInspectionTool", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LocalInspectionTool", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                this.addDescriptors(LocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        LOG.assertTrue(descriptor != null, (Object)LocalInspectionTool.this.getClass().getName());
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalInspectionTool", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nullable
    public PsiNamedElement getProblemElement(PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiFile)) {
            psiElement = psiElement.getParent();
        }
        return (PsiFile)psiElement;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/LocalInspectionTool", "inspectionStarted"));
        }
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/LocalInspectionTool", "inspectionFinished"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInspection/LocalInspectionTool", "inspectionFinished"));
        }
        this.inspectionFinished(session);
    }

    @Deprecated
    public void inspectionFinished(@NotNull LocalInspectionToolSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInspection/LocalInspectionTool", "inspectionFinished"));
        }
    }

    @NotNull
    public List<ProblemDescriptor> processFile(@NotNull PsiFile file, @NotNull InspectionManager manager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/LocalInspectionTool", "processFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/LocalInspectionTool", "processFile"));
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, false);
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PsiElementVisitor customVisitor = this.buildVisitor(holder, false, session);
        LOG.assertTrue(!(customVisitor instanceof PsiRecursiveElementVisitor), (Object)"The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive");
        this.inspectionStarted(session, false);
        file.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                element.accept(customVisitor);
                super.visitElement(element);
            }
        });
        this.inspectionFinished(session, holder);
        List<ProblemDescriptor> list = holder.getResults();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalInspectionTool", "processFile"));
        }
        return list;
    }

    static interface LocalDefaultNameProvider
    extends InspectionProfileEntry.DefaultNameProvider {
        @Nullable
        public String getDefaultID();

        @Nullable
        public String getDefaultAlternativeID();
    }
}

