/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaVersionService {
    public static JavaVersionService getInstance() {
        return ServiceManager.getService(JavaVersionService.class);
    }

    public boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion version) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaVersionService", "isAtLeast"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/projectRoots/JavaVersionService", "isAtLeast"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(version.getMaxLanguageLevel());
    }

    public JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaVersionService", "getJavaSdkVersion"));
        }
        return JavaSdkVersion.fromLanguageLevel(PsiUtil.getLanguageLevel(element));
    }
}

