/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ComparatorDelegate;
import com.intellij.util.containers.Convertor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FilterDescendantVirtualFileConvertible<T>
extends AbstractFilterChildren<T> {
    private final ComparatorDelegate<T, VirtualFile> myComparator;
    private final Convertor<T, VirtualFile> myConvertor;

    public FilterDescendantVirtualFileConvertible(Convertor<T, VirtualFile> convertor, Comparator<VirtualFile> comparator) {
        this.myConvertor = convertor;
        this.myComparator = new ComparatorDelegate(this.myConvertor, comparator);
    }

    @Override
    protected void sortAscending(List<T> ts) {
        Collections.sort(ts, this.myComparator);
    }

    @Override
    protected boolean isAncestor(T parent, T child) {
        return VfsUtil.isAncestor((VirtualFile)this.myConvertor.convert(parent), (VirtualFile)this.myConvertor.convert(child), false);
    }
}

