/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.SideBorder;
import com.intellij.ui.border.IdeaTitledBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public class IdeBorderFactory {
    public static final int BORDER_ROUNDNESS = 5;
    public static final int TITLED_BORDER_TOP_INSET = 7;
    public static final int TITLED_BORDER_LEFT_INSET = 0;
    public static final int TITLED_BORDER_BOTTOM_INSET = 10;
    public static final int TITLED_BORDER_RIGHT_INSET = 0;
    public static final int TITLED_BORDER_INDENT = 20;

    private IdeBorderFactory() {
    }

    public static Border createBorder() {
        return IdeBorderFactory.createBorder(15);
    }

    public static Border createBorder(int borders) {
        return new SideBorder(IdeBorderFactory.getBorderColor(), borders);
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder() {
        RoundedLineBorder roundedLineBorder = IdeBorderFactory.createRoundedBorder(5);
        if (roundedLineBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/IdeBorderFactory", "createRoundedBorder"));
        }
        return roundedLineBorder;
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder(int arcSize) {
        RoundedLineBorder roundedLineBorder = new RoundedLineBorder(IdeBorderFactory.getBorderColor(), arcSize);
        if (roundedLineBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/IdeBorderFactory", "createRoundedBorder"));
        }
        return roundedLineBorder;
    }

    @NotNull
    public static RoundedLineBorder createRoundedBorder(int arcSize, int thickness) {
        RoundedLineBorder roundedLineBorder = new RoundedLineBorder(IdeBorderFactory.getBorderColor(), arcSize, thickness);
        if (roundedLineBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/IdeBorderFactory", "createRoundedBorder"));
        }
        return roundedLineBorder;
    }

    public static Border createEmptyBorder(Insets insets) {
        return new EmptyBorder(insets);
    }

    public static Border createEmptyBorder() {
        return IdeBorderFactory.createEmptyBorder(0);
    }

    public static Border createEmptyBorder(int thickness) {
        return new EmptyBorder(thickness, thickness, thickness, thickness);
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(top, left, bottom, right);
    }

    public static TitledBorder createTitledBorder(String s) {
        return IdeBorderFactory.createTitledBorder(s, true);
    }

    @Deprecated
    public static IdeaTitledBorder createTitledBorder(String title, boolean hasBoldFont, boolean hasIndent, boolean hasSmallFont) {
        return IdeBorderFactory.createTitledBorder(title, hasIndent);
    }

    @Deprecated
    public static IdeaTitledBorder createTitledBorder(String title, boolean hasBoldFont, boolean hasIndent, boolean hasSmallFont, Insets insets) {
        return IdeBorderFactory.createTitledBorder(title, hasIndent, insets);
    }

    public static IdeaTitledBorder createTitledBorder(String title, boolean hasIndent) {
        Insets insets = new Insets(7, 0, 10, 0);
        return IdeBorderFactory.createTitledBorder(title, hasIndent, insets);
    }

    public static IdeaTitledBorder createTitledBorder(String title, boolean hasIndent, Insets insets) {
        int indent = hasIndent ? 20 : 0;
        return new IdeaTitledBorder(title, indent, insets);
    }

    @Deprecated
    public static TitledBorder createTitledHeaderBorder(String title) {
        return new IdeaTitledBorder(title, 10, new Insets(5, 0, 10, 0));
    }

    private static Color getBorderColor() {
        return JBColor.border();
    }

    public static class PlainSmallWithIndentWithoutInsets {
        private PlainSmallWithIndentWithoutInsets() {
        }

        public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, true, new Insets(7, 0, 0, 0));
        }
    }

    public static class PlainSmallWithoutIndentWithoutInsets {
        private PlainSmallWithoutIndentWithoutInsets() {
        }

        public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, false, new Insets(7, 0, 0, 0));
        }
    }

    public static class PlainSmallWithoutIndent {
        private PlainSmallWithoutIndent() {
        }

        public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, false);
        }
    }

    public static class PlainSmallWithIndent {
        private PlainSmallWithIndent() {
        }

        public static TitledBorder createTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
            return IdeBorderFactory.createTitledBorder(title, true);
        }
    }
}

